/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class ArtifactRepositorySearch {
    @NotNull
    private final List<ArtifactRepository> myRepositories;

    public ArtifactRepositorySearch(@NotNull List<ArtifactRepository> repositories) {
        if (repositories == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(0);
        }
        this.myRepositories = repositories;
    }

    @NotNull
    public Callback start(@NotNull SearchRequest request) {
        if (request == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(1);
        }
        Callback callback = new Callback();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)this.myRepositories.size());
        ArrayList results = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (request == null) {
                ArtifactRepositorySearch.$$$reportNull$$$0(3);
            }
            for (ArtifactRepository repository : this.myRepositories) {
                jobs.add(application.executeOnPooledThread(() -> {
                    if (request == null) {
                        ArtifactRepositorySearch.$$$reportNull$$$0(4);
                    }
                    return repository.search(request);
                }));
            }
            for (Future job : jobs) {
                try {
                    results.add(Futures.getChecked((Future)job, Exception.class));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            callback.setDone(results, errors);
        });
        Callback callback2 = callback;
        if (callback2 == null) {
            ArtifactRepositorySearch.$$$reportNull$$$0(2);
        }
        return callback2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$start$1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Callback
    extends ActionCallback {
        @NotNull
        private final List<SearchResult> mySearchResults = Lists.newArrayList();
        @NotNull
        private final List<Exception> myErrors = Lists.newArrayList();

        void setDone(@NotNull List<SearchResult> searchResults, @NotNull List<Exception> errors) {
            if (searchResults == null) {
                Callback.$$$reportNull$$$0(0);
            }
            if (errors == null) {
                Callback.$$$reportNull$$$0(1);
            }
            searchResults.forEach(searchResult -> {
                Exception error = searchResult.getError();
                if (error != null) {
                    this.myErrors.add(error);
                    return;
                }
                this.mySearchResults.add((SearchResult)searchResult);
            });
            this.myErrors.addAll(errors);
            this.setDone();
        }

        @NotNull
        public List<SearchResult> getSearchResults() {
            this.checkIsDone();
            List<SearchResult> list = this.mySearchResults;
            if (list == null) {
                Callback.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public List<Exception> getErrors() {
            this.checkIsDone();
            List<Exception> list = this.myErrors;
            if (list == null) {
                Callback.$$$reportNull$$$0(3);
            }
            return list;
        }

        private void checkIsDone() {
            if (!this.isDone()) {
                throw new IllegalStateException("Repository search has not finished yet");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchResults";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepositorySearch$Callback";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchResults";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setDone";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

