/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class QuickFixes {
    public static final char QUICK_FIX_PATH_SEPARATOR = '/';
    @NonNls
    public static final String SET_LIBRARY_DEPENDENCY_QUICK_FIX = "setLibraryDependency";

    private QuickFixes() {
    }

    public static void executeQuickFix(@NotNull String quickFix, @NonNls PsContext context) {
        if (quickFix == null) {
            QuickFixes.$$$reportNull$$$0(0);
        }
        List segments = Splitter.on((char)'/').splitToList((CharSequence)quickFix);
        assert (!segments.isEmpty());
        String action = (String)segments.get(0);
        if (SET_LIBRARY_DEPENDENCY_QUICK_FIX.equals(action)) {
            assert (segments.size() == 4);
            String moduleName = (String)segments.get(1);
            String dependency = (String)segments.get(2);
            String version = (String)segments.get(3);
            QuickFixes.setLibraryDependencyVersion(context, moduleName, dependency, version);
        }
    }

    private static void setLibraryDependencyVersion(@NonNls PsContext context, @NotNull String moduleName, @NotNull String dependency, @NotNull String version) {
        PsModule module;
        if (moduleName == null) {
            QuickFixes.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            QuickFixes.$$$reportNull$$$0(2);
        }
        if (version == null) {
            QuickFixes.$$$reportNull$$$0(3);
        }
        if ((module = context.getProject().findModuleByName(moduleName)) instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)module;
            androidModule.forEachDeclaredDependency(declaredDependency -> {
                if (dependency == null) {
                    QuickFixes.$$$reportNull$$$0(9);
                }
                if (version == null) {
                    QuickFixes.$$$reportNull$$$0(10);
                }
                if (declaredDependency instanceof PsLibraryDependency) {
                    QuickFixes.setLibraryDependencyVersion((PsLibraryDependency)((Object)declaredDependency), dependency, version);
                }
            });
        } else if (module instanceof PsJavaModule) {
            PsJavaModule javaModule = (PsJavaModule)module;
            javaModule.forEachDeclaredDependency(declaredDependency -> {
                if (dependency == null) {
                    QuickFixes.$$$reportNull$$$0(7);
                }
                if (version == null) {
                    QuickFixes.$$$reportNull$$$0(8);
                }
                if (declaredDependency instanceof PsLibraryDependency) {
                    QuickFixes.setLibraryDependencyVersion((PsLibraryDependency)((Object)declaredDependency), dependency, version);
                }
            });
        }
    }

    private static void setLibraryDependencyVersion(@NotNull PsLibraryDependency dependency, @NotNull String dependencySpec, @NotNull String version) {
        PsArtifactDependencySpec declaredSpec;
        if (dependency == null) {
            QuickFixes.$$$reportNull$$$0(4);
        }
        if (dependencySpec == null) {
            QuickFixes.$$$reportNull$$$0(5);
        }
        if (version == null) {
            QuickFixes.$$$reportNull$$$0(6);
        }
        if ((declaredSpec = dependency.getDeclaredSpec()) != null && dependencySpec.equals(declaredSpec.compactNotation())) {
            dependency.setVersion(version);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySpec";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/quickfix/QuickFixes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setLibraryDependencyVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setLibraryDependencyVersion$1";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$setLibraryDependencyVersion$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

