/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.instantapp;

import com.android.tools.idea.model.MergedManifest;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InstantAppUrlFinder {
    @NotNull
    private final Collection<Element> myActivities;

    public InstantAppUrlFinder(@NotNull MergedManifest manifest) {
        if (manifest == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(0);
        }
        this(manifest.getActivities());
    }

    InstantAppUrlFinder(@NotNull Collection<Element> activities) {
        if (activities == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(1);
        }
        this.myActivities = activities;
    }

    @NotNull
    public ImmutableCollection<String> getAllUrls() {
        TreeMultimap allUrls = TreeMultimap.create();
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                UrlData urlData = wrapper.getUrlData();
                if (!urlData.isValid()) continue;
                allUrls.put((Object)wrapper.getOrder(), (Object)urlData.getUrl());
            }
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)allUrls.values());
        if (immutableList == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    public String getDefaultUrl() {
        ImmutableCollection<String> urls = this.getAllUrls();
        if (!urls.isEmpty()) {
            String string = (String)urls.iterator().next();
            if (string == null) {
                InstantAppUrlFinder.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("" == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(4);
        }
        return "";
    }

    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            InstantAppUrlFinder.$$$reportNull$$$0(5);
        }
        for (Element activity : this.myActivities) {
            for (Node node = activity.getFirstChild(); node != null; node = node.getNextSibling()) {
                InstantAppIntentFilterWrapper wrapper = InstantAppIntentFilterWrapper.of(node);
                if (!wrapper.matchesUrl(url)) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUrls";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchesUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class UrlData {
        @NotNull
        private final Collection<String> mySchemes = new HashSet<String>();
        @NotNull
        private final Collection<String> myHosts = new HashSet<String>();
        @NotNull
        private final Collection<String> myPaths = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPrefixes = new HashSet<String>();
        @NotNull
        private final Collection<String> myPathPatterns = new HashSet<String>();

        UrlData() {
        }

        void addFromStrings(@NotNull String scheme, @NotNull String host, @NotNull String path, @NotNull String pathPrefix, @NotNull String pathPattern) {
            if (scheme == null) {
                UrlData.$$$reportNull$$$0(0);
            }
            if (host == null) {
                UrlData.$$$reportNull$$$0(1);
            }
            if (path == null) {
                UrlData.$$$reportNull$$$0(2);
            }
            if (pathPrefix == null) {
                UrlData.$$$reportNull$$$0(3);
            }
            if (pathPattern == null) {
                UrlData.$$$reportNull$$$0(4);
            }
            UrlData.addTo(this.mySchemes, scheme);
            UrlData.addTo(this.myHosts, host);
            UrlData.addTo(this.myPaths, path);
            UrlData.addTo(this.myPathPrefixes, pathPrefix);
            UrlData.addTo(this.myPathPatterns, pathPattern);
        }

        void addFromNode(@NotNull Node node) {
            if (node == null) {
                UrlData.$$$reportNull$$$0(5);
            }
            if (node.getNodeType() == 1 && "data".equals(node.getNodeName())) {
                Element element = (Element)node;
                UrlData.addTo(this.mySchemes, element.getAttributeNS("http://schemas.android.com/apk/res/android", "scheme"));
                UrlData.addTo(this.myHosts, element.getAttributeNS("http://schemas.android.com/apk/res/android", "host"));
                UrlData.addTo(this.myPaths, element.getAttributeNS("http://schemas.android.com/apk/res/android", "path"));
                UrlData.addTo(this.myPathPrefixes, element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPrefix"));
                UrlData.addTo(this.myPathPatterns, element.getAttributeNS("http://schemas.android.com/apk/res/android", "pathPattern"));
            }
        }

        private static void addTo(@NotNull Collection<String> collection, @Nullable String string) {
            if (collection == null) {
                UrlData.$$$reportNull$$$0(6);
            }
            if (StringUtil.isNotEmpty((String)string)) {
                collection.add(string);
            }
        }

        @NotNull
        static String convertPatternToExample(@NotNull String pattern) {
            if (pattern == null) {
                UrlData.$$$reportNull$$$0(7);
            }
            String string = pattern.replace(".*", "example");
            if (string == null) {
                UrlData.$$$reportNull$$$0(8);
            }
            return string;
        }

        boolean isValid() {
            return !this.mySchemes.isEmpty() && !this.myHosts.isEmpty() && this.getEffectivePath().startsWith("/");
        }

        @NotNull
        private String getEffectivePath() {
            String path;
            String string = path = this.myPaths.isEmpty() ? "" : this.myPaths.iterator().next();
            if (StringUtil.isEmpty((String)path)) {
                String string2 = path = this.myPathPrefixes.isEmpty() ? "" : this.myPathPrefixes.iterator().next() + "/.*";
            }
            if (StringUtil.isEmpty((String)path)) {
                path = this.myPathPatterns.isEmpty() ? "" : this.myPathPatterns.iterator().next();
            }
            String string3 = StringUtil.isNotEmpty((String)path) ? path : "/";
            if (string3 == null) {
                UrlData.$$$reportNull$$$0(9);
            }
            return string3;
        }

        @NotNull
        String getUrl() {
            if (!this.isValid()) {
                if ("" == null) {
                    UrlData.$$$reportNull$$$0(10);
                }
                return "";
            }
            String scheme = this.mySchemes.iterator().next();
            String host = this.myHosts.iterator().next();
            String string = String.format("%s://%s%s", scheme, host, UrlData.convertPatternToExample(this.getEffectivePath()));
            if (string == null) {
                UrlData.$$$reportNull$$$0(11);
            }
            return string;
        }

        boolean matchesUrl(@NotNull String url) {
            if (url == null) {
                UrlData.$$$reportNull$$$0(12);
            }
            if (!this.isValid()) {
                return false;
            }
            boolean schemeMatched = false;
            for (String scheme : this.mySchemes) {
                if (!url.startsWith(scheme + "://")) continue;
                url = url.replaceFirst(scheme + "://", "");
                schemeMatched = true;
                break;
            }
            if (!schemeMatched) {
                return false;
            }
            boolean hostMatched = false;
            for (String host : this.myHosts) {
                if (!url.startsWith(host)) continue;
                url = url.replaceFirst(host, "");
                hostMatched = true;
                break;
            }
            if (!hostMatched) {
                return false;
            }
            for (String path : this.myPaths) {
                if (!StringUtil.isNotEmpty((String)path) || !new AndroidPatternMatcher(path, 0).match(url)) continue;
                return true;
            }
            for (String pathPrefix : this.myPathPrefixes) {
                if (!StringUtil.isNotEmpty((String)pathPrefix) || !new AndroidPatternMatcher(pathPrefix, 1).match(url)) continue;
                return true;
            }
            for (String pathPattern : this.myPathPatterns) {
                if (!StringUtil.isNotEmpty((String)pathPattern) || !new AndroidPatternMatcher(pathPattern, 2).match(url)) continue;
                return true;
            }
            if (!(this.myPaths.isEmpty() && this.myPathPrefixes.isEmpty() && this.myPathPatterns.isEmpty())) {
                return false;
            }
            return url.isEmpty() || url.compareTo("/") == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathPrefix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathPattern";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$UrlData";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$UrlData";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertPatternToExample";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectivePath";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFromStrings";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addFromNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addTo";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "convertPatternToExample";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class InstantAppIntentFilterWrapper {
        @Nullable
        private final Element myElement;
        private final int myOrder;

        private InstantAppIntentFilterWrapper(@Nullable Element element, int order) {
            this.myElement = element;
            this.myOrder = order;
        }

        @NotNull
        static InstantAppIntentFilterWrapper of(@NotNull Node node) {
            int order;
            Element element;
            if (node == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(0);
            }
            try {
                element = InstantAppIntentFilterWrapper.getElement(node);
                order = InstantAppIntentFilterWrapper.getOrder(element);
            }
            catch (IllegalArgumentException unused) {
                element = null;
                order = -1;
            }
            InstantAppIntentFilterWrapper instantAppIntentFilterWrapper = new InstantAppIntentFilterWrapper(element, order);
            if (instantAppIntentFilterWrapper == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(1);
            }
            return instantAppIntentFilterWrapper;
        }

        @NotNull
        static Element getElement(@NotNull Node node) {
            if (node == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(2);
            }
            if (node.getNodeType() == 1 && "intent-filter".equals(node.getNodeName())) {
                Element element = (Element)node;
                if (element == null) {
                    InstantAppIntentFilterWrapper.$$$reportNull$$$0(3);
                }
                return element;
            }
            throw new IllegalArgumentException();
        }

        static int getOrder(@NotNull Element element) {
            String orderValue;
            if (element == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(4);
            }
            if (StringUtil.isNotEmpty((String)(orderValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "order")))) {
                try {
                    return Integer.parseUnsignedInt(orderValue);
                }
                catch (NumberFormatException unused) {
                    throw new IllegalArgumentException();
                }
            }
            return 0;
        }

        @NotNull
        UrlData getUrlData() {
            UrlData urlData = new UrlData();
            if (this.myElement != null) {
                for (Node node = this.myElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                    urlData.addFromNode(node);
                }
            }
            UrlData urlData2 = urlData;
            if (urlData2 == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(5);
            }
            return urlData2;
        }

        int getOrder() {
            return this.myOrder;
        }

        boolean matchesUrl(@NotNull String url) {
            if (url == null) {
                InstantAppIntentFilterWrapper.$$$reportNull$$$0(6);
            }
            return this.getUrlData().matchesUrl(url);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/instantapp/InstantAppUrlFinder$InstantAppIntentFilterWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrlData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrder";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matchesUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

