/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.lint.AndroidLintFontValidationErrorInspection;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.FontDetector;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeAppCompatV7Fix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(2);
        }
        Module module = AndroidPsiUtils.getModuleSafely(startElement);
        UpgradeAppCompatV7Fix.apply(module);
    }

    public static void apply(@Nullable Module module) {
        if (module != null) {
            GradleCoordinate gc;
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(AndroidLintFontValidationErrorInspection.class);
            RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)FontDetector.MIN_APPSUPPORT_VERSION, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)progress);
            if (p != null && (gc = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
                GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
                manager.updateLibrariesToVersion(module, Collections.singletonList(gc), null);
            }
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(4);
        }
        if (contextType == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(5);
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Upgrade appcompat-v7 to recommended version" == null) {
            UpgradeAppCompatV7Fix.$$$reportNull$$$0(6);
        }
        return "Upgrade appcompat-v7 to recommended version";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/UpgradeAppCompatV7Fix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/UpgradeAppCompatV7Fix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

