/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.memory;

import com.android.tools.adtui.TimelineComponent;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.GcAction;
import com.android.tools.idea.ddms.actions.ToggleAllocationTrackingAction;
import com.android.tools.idea.ddms.hprof.DumpHprofAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.memory.MemorySampler;
import com.android.tools.idea.monitor.memory.actions.ToggleDebugRender;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import java.awt.event.HierarchyListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitorView
extends BaseMonitorView<MemorySampler>
implements HierarchyListener {
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 5.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = Float.MAX_VALUE;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 2.0f;
    public static final int EVENT_HPROF = 1;
    public static final int EVENT_ALLOC = 2;

    public MemoryMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            MemoryMonitorView.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            MemoryMonitorView.$$$reportNull$$$0(1);
        }
        super(project, deviceContext, new MemorySampler(500), 0.75f, 5.0f, Float.MAX_VALUE, 2.0f);
        this.myTimelineComponent.configureUnits("MB");
        this.myTimelineComponent.configureStream(0, "Allocated", (Color)new JBColor(7908313, 7908313));
        this.myTimelineComponent.configureStream(1, "Free", (Color)new JBColor(12242140, 5331036));
        this.myTimelineComponent.configureEvent(1, 0, AndroidIcons.Ddms.DumpHprof, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), false);
        this.myTimelineComponent.configureEvent(2, 0, AndroidIcons.Ddms.AllocationTracker, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), true);
        this.myTimelineComponent.configureType(1, TimelineComponent.Style.SOLID);
        this.myTimelineComponent.configureType(2, TimelineComponent.Style.DASHED);
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.setViewComponent((JComponent)this.myTimelineComponent);
    }

    @Override
    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new GcAction(this.myDeviceContext));
        group.add((AnAction)new DumpHprofAction(this.myProject, this.myDeviceContext, this.myEvents));
        group.add((AnAction)new ToggleAllocationTrackingAction(this.myProject, this.myDeviceContext, this.myEvents));
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("Memory monitor", "http://developer.android.com/r/studio-ui/am-memory.html"));
        if (Boolean.getBoolean("studio.profiling.debug")) {
            group.addSeparator();
            group.add((AnAction)new ToggleDebugRender(this.myTimelineComponent));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MemoryMonitorView.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public String getTitleName() {
        if ("Memory" == null) {
            MemoryMonitorView.$$$reportNull$$$0(3);
        }
        return "Memory";
    }

    @Override
    @NotNull
    public Icon getTitleIcon() {
        Icon icon = AndroidIcons.MemoryMonitor;
        if (icon == null) {
            MemoryMonitorView.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    protected int getDefaultPosition() {
        return 0;
    }

    @Override
    @NotNull
    public String getMonitorName() {
        if ("MemoryMonitor" == null) {
            MemoryMonitorView.$$$reportNull$$$0(5);
        }
        return "MemoryMonitor";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("memory usage" == null) {
            MemoryMonitorView.$$$reportNull$$$0(6);
        }
        return "memory usage";
    }

    @Override
    public AndroidStudioEvent.MonitorType getMonitorType() {
        return AndroidStudioEvent.MonitorType.NETWORK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/memory/MemoryMonitorView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/memory/MemoryMonitorView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitorName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

