/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.editor;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.naveditor.editor.Destination;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.utils.Pair;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDestinationMenu
extends DropDownAction {
    private static final JLabel RENDERER_COMPONENT = new JLabel();
    private final NavDesignSurface mySurface;
    public ComboBox<Pair<String, PsiClass>> myKindPopup;
    JTextField myLabelField;
    JLabel myLabelLabel;
    JTextField myIdField;
    JLabel myIdLabel;
    JLabel mySourceLabel;
    JTextField mySourceField;
    JLabel myValidationLabel;
    private final NavigationSchema mySchema;
    private JPanel myMainPanel;
    public JButton myCreateButton;
    private String myDefaultId;
    private String myDefaultLabel;

    CreateDestinationMenu(@NotNull NavDesignSurface surface) {
        if (surface == null) {
            CreateDestinationMenu.$$$reportNull$$$0(0);
        }
        super("", "Add Destination", StudioIcons.NavEditor.Toolbar.ADD_DESTINATION);
        this.mySurface = surface;
        this.mySchema = this.mySurface.getSchema();
    }

    @Nullable
    protected JPanel createCustomComponentPopup() {
        if (this.myMainPanel == null) {
            this.myMainPanel = this.createNewPanel();
        }
        this.myDefaultLabel = null;
        this.myDefaultId = null;
        this.updateDefaultIdAndLabel();
        return this.myMainPanel;
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            CreateDestinationMenu.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createNewPanel() {
        JPanel newPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        JLabel destinationLabel = new JLabel("New Destination");
        newPanel.add(destinationLabel);
        newPanel.add(new JSeparator());
        JPanel selectionGrid = this.createAddControls();
        newPanel.add(selectionGrid);
        this.myValidationLabel = new JLabel("", AllIcons.General.Error, 2);
        this.myValidationLabel.setVisible(false);
        newPanel.add((Component)this.myValidationLabel, "BOTTOM");
        JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(2, 0));
        this.myCreateButton = new JButton("Create");
        this.myCreateButton.addActionListener(event -> {
            if (this.validate()) {
                this.createDestination();
            }
        });
        buttons.add(this.myCreateButton);
        JPanel bottomRow = new JPanel();
        bottomRow.add(buttons);
        newPanel.add((Component)bottomRow, "BOTTOM");
        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel = newPanel;
        if (jPanel == null) {
            CreateDestinationMenu.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    void createDestination() {
        Pair selected = (Pair)this.myKindPopup.getSelectedItem();
        if (selected == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)selected.getSecond();
        NlComponent parent = this.mySurface.getCurrentNavigation();
        Destination result = null;
        if (psiClass == null) {
            result = new Destination.IncludeDestination(this.mySourceField.getText(), parent);
        } else {
            NavigationSchema.DestinationType type = this.mySchema.getTypeForNavigatorClass(psiClass);
            result = new Destination.RegularDestination(parent, this.mySchema.getDefaultTag(type), this.myLabelField.getText(), null, null, this.myIdField.getText());
        }
        ((Destination)result).addToGraph();
        this.mySurface.getSceneManager().update();
        NlComponent component2 = result.getComponent();
        this.mySurface.getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)component2));
        this.mySurface.scrollToCenter((List<NlComponent>)ImmutableList.of((Object)component2));
        this.closePopup();
    }

    boolean validate() {
        String error = null;
        if (this.myLabelField.getText().isEmpty()) {
            error = "Label must be set";
        } else if (this.myIdField.getText().isEmpty()) {
            error = "ID must be set";
        }
        if (error != null) {
            this.myValidationLabel.setText(error);
            this.myValidationLabel.setVisible(true);
            return false;
        }
        this.myValidationLabel.setVisible(false);
        return true;
    }

    @NotNull
    private JPanel createAddControls() {
        TabularLayout layout = new TabularLayout("Fit,20px,*");
        layout.setVGap(3);
        JPanel selectionGrid = new JPanel((LayoutManager)layout);
        selectionGrid.add((Component)new JLabel("Kind"), new TabularLayout.Constraint(0, 0));
        this.myLabelLabel = new JLabel("Label");
        selectionGrid.add((Component)this.myLabelLabel, new TabularLayout.Constraint(1, 0));
        this.myIdField = new JTextField("", 40);
        selectionGrid.add((Component)this.myIdField, new TabularLayout.Constraint(2, 2));
        this.myLabelField = new JTextField("", 40);
        selectionGrid.add((Component)this.myLabelField, new TabularLayout.Constraint(1, 2));
        this.myIdLabel = new JLabel("ID");
        selectionGrid.add((Component)this.myIdLabel, new TabularLayout.Constraint(2, 0));
        this.mySourceLabel = new JLabel("Source");
        selectionGrid.add((Component)this.mySourceLabel, new TabularLayout.Constraint(3, 0));
        this.mySourceField = new JTextField("", 40);
        selectionGrid.add((Component)this.mySourceField, new TabularLayout.Constraint(3, 2));
        this.createKindPopup();
        selectionGrid.add((Component)this.myKindPopup, new TabularLayout.Constraint(0, 2));
        this.myKindPopup.setSelectedItem((Object)this.mySchema.getDefaultTag(NavigationSchema.DestinationType.FRAGMENT));
        this.updateDefaultIdAndLabel();
        JPanel jPanel = selectionGrid;
        if (jPanel == null) {
            CreateDestinationMenu.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void updateDefaultIdAndLabel() {
        Matcher m;
        String tag;
        Pair item = (Pair)this.myKindPopup.getSelectedItem();
        if (item == null) {
            return;
        }
        PsiClass navigatorClass = (PsiClass)item.getSecond();
        String string = tag = navigatorClass == null ? "include" : this.mySchema.getTag(navigatorClass);
        if (this.myDefaultId == null || this.myIdField.getText().equals(this.myDefaultId)) {
            NlModel model = this.mySurface.getModel();
            this.myDefaultId = NlComponent.generateId(tag, model.getIds(), ResourceFolderType.NAVIGATION, model.getModule());
            this.myIdField.setText(this.myDefaultId);
        }
        if ((this.myDefaultLabel == null || this.myLabelField.getText().equals(this.myDefaultLabel)) && (m = Pattern.compile("\\d*$").matcher(this.myDefaultId)).find()) {
            String n = m.group();
            this.myDefaultLabel = this.mySchema.getTagLabel(tag) + (n.isEmpty() ? "" : " " + n);
            this.myLabelField.setText(this.myDefaultLabel);
        }
    }

    private void createKindPopup() {
        this.myKindPopup = new ComboBox();
        this.myKindPopup.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            String text = (String)value.getFirst();
            RENDERER_COMPONENT.setText(text);
            return RENDERER_COMPONENT;
        });
        HashMultimap tagToClass = HashMultimap.create();
        this.mySchema.getNavigatorClassTagMap().forEach((arg_0, arg_1) -> CreateDestinationMenu.lambda$createKindPopup$2((Multimap)tagToClass, arg_0, arg_1));
        Pair defaultSelection = null;
        String defaultTag = this.mySchema.getDefaultTag(NavigationSchema.DestinationType.FRAGMENT);
        for (String tag : this.mySchema.getTagTypeMap().keySet()) {
            Collection classes = tagToClass.get((Object)tag);
            String label = this.mySchema.getTagLabel(tag);
            for (PsiClass psiClass : classes) {
                if (classes.size() > 1) {
                    label = label + " " + psiClass.getName();
                }
                Pair item = Pair.of((Object)label, (Object)psiClass);
                if (tag.equals(defaultTag)) {
                    defaultSelection = item;
                }
                this.myKindPopup.addItem((Object)item);
            }
        }
        ItemListener listener = itemEvent -> {
            if ("Include Graph".equals(((Pair)itemEvent.getItem()).getFirst())) {
                this.myIdField.setVisible(false);
                this.myLabelField.setVisible(false);
                this.myIdLabel.setVisible(false);
                this.myLabelLabel.setVisible(false);
                this.mySourceLabel.setVisible(true);
                this.mySourceField.setVisible(true);
            } else {
                this.mySourceLabel.setVisible(false);
                this.mySourceField.setVisible(false);
                this.myLabelLabel.setVisible(true);
                this.myLabelField.setVisible(true);
                this.myIdLabel.setVisible(true);
                this.myIdField.setVisible(true);
            }
            this.updateDefaultIdAndLabel();
        };
        this.myKindPopup.addItemListener(listener);
        this.myKindPopup.setSelectedItem(null);
        this.myKindPopup.setSelectedItem(defaultSelection);
    }

    protected boolean updateActions() {
        return true;
    }

    private static /* synthetic */ void lambda$createKindPopup$2(Multimap tagToClass, PsiClass psiClass, String tag) {
        tagToClass.put((Object)tag, (Object)psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/editor/CreateDestinationMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/editor/CreateDestinationMenu";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddControls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

