/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.decorator.NavSceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.NavScreenTargetProvider;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.naveditor.surface.NavView;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavSceneManager
extends SceneManager {
    private static final int SCREEN_LONG = 256;
    private static final int SUBNAV_WIDTH = 140;
    private static final int SUBNAV_HEIGHT = 38;
    private static final int PAN_LIMIT = 150;
    private static final int BOUNDING_BOX_PADDING = 100;
    public static final int ACTION_ARROW_PARALLEL = 10;
    public static final int ACTION_ARROW_PERPENDICULAR = 12;
    private static final int ACTION_HEIGHT = 12;
    private static final int ACTION_VERTICAL_PADDING = 6;
    private static final int GLOBAL_ACTION_LINE_LENGTH = 8;
    private static final int GLOBAL_ACTION_WIDTH = 18;
    private static final int GLOBAL_ACTION_HORIZONTAL_PADDING = 8;
    private static final int EXIT_ACTION_LINE_LENGTH = 14;
    private static final int EXIT_ACTION_WIDTH = 24;
    private static final int EXIT_ACTION_HORIZONTAL_PADDING = 2;
    private final NavScreenTargetProvider myScreenTargetProvider;
    private NavSceneLayoutAlgorithm myLayoutAlgorithm;
    private SceneDecoratorFactory myDecoratorFactory;

    public NavSceneManager(@NotNull NlModel model, @NotNull NavDesignSurface surface) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            NavSceneManager.$$$reportNull$$$0(1);
        }
        super(model, surface);
        NavigationSchema schema = surface.getSchema();
        this.myLayoutAlgorithm = new ManualLayoutAlgorithm(model.getModule());
        this.myScreenTargetProvider = new NavScreenTargetProvider(this.myLayoutAlgorithm, schema);
        NavSceneManager.updateHierarchy(this.getModel(), null);
        this.getModel().addListener(new ModelChangeListener());
        this.getDesignSurface().getSelectionModel().addListener((unused, selection) -> this.getScene().needsRebuildList());
        this.requestRender();
    }

    @Override
    @NotNull
    protected NavDesignSurface getDesignSurface() {
        NavDesignSurface navDesignSurface = (NavDesignSurface)super.getDesignSurface();
        if (navDesignSurface == null) {
            NavSceneManager.$$$reportNull$$$0(2);
        }
        return navDesignSurface;
    }

    @Override
    @NotNull
    protected SceneView doCreateSceneView() {
        NavDesignSurface surface = this.getDesignSurface();
        NavView navView = new NavView(surface, (SceneManager)this);
        surface.getLayeredPane().setPreferredSize(navView.getPreferredSize());
        surface.setShowIssuePanel(false);
        NavView navView2 = navView;
        if (navView2 == null) {
            NavSceneManager.$$$reportNull$$$0(3);
        }
        return navView2;
    }

    @Override
    protected void updateFromComponent(@NotNull SceneComponent sceneComponent) {
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(4);
        }
        super.updateFromComponent(sceneComponent);
        NlComponent nlComponent = sceneComponent.getNlComponent();
        switch (NavComponentHelperKt.getActionType(nlComponent)) {
            case GLOBAL: {
                sceneComponent.setSize(18, 12, false);
                return;
            }
            case EXIT: {
                sceneComponent.setSize(24, 12, false);
                return;
            }
        }
        NavigationSchema.DestinationType type = this.getDesignSurface().getSchema().getDestinationType(nlComponent.getTagName());
        if (type != null) {
            sceneComponent.setTargetProvider(this.myScreenTargetProvider);
            switch (type) {
                case NAVIGATION: {
                    if (sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
                        sceneComponent.setSize(-1, -1, false);
                        break;
                    }
                    sceneComponent.setSize(140, 38, false);
                    break;
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    State state = this.getModel().getConfiguration().getDeviceState();
                    assert (state != null);
                    Screen screen = state.getHardware().getScreen();
                    int x = 256;
                    int y = 256;
                    double ratio = (double)screen.getXDimension() / (double)screen.getYDimension();
                    if (ratio > 1.0) {
                        y = (int)((double)y / ratio);
                    } else {
                        x = (int)((double)x * ratio);
                    }
                    if (ratio < 1.1 && ratio > 0.9) {
                        x = (int)((double)x * 0.5);
                        y = (int)((double)y * 0.5);
                    }
                    sceneComponent.setSize(x, y, true);
                    break;
                }
            }
        }
    }

    @Override
    protected void postUpdateFromComponent(@NotNull SceneComponent sceneComponent) {
        NavigationSchema.DestinationType type;
        if (sceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(5);
        }
        if ((type = this.getDesignSurface().getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName())) == NavigationSchema.DestinationType.NAVIGATION && sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
            this.layoutAll(sceneComponent);
            this.updateRootBounds(sceneComponent);
        }
    }

    private void updateRootBounds(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(6);
        }
        NavDesignSurface surface = this.getDesignSurface();
        Dimension extentSize = surface.getExtentSize();
        int extentWidth = Coordinates.getAndroidDimension(surface, extentSize.width);
        int extentHeight = Coordinates.getAndroidDimension(surface, extentSize.height);
        int panLimit = Coordinates.getAndroidDimension(surface, 150);
        Rectangle rootBounds = NavSceneManager.getBoundingBox(root);
        rootBounds.grow(extentWidth - panLimit, extentHeight - panLimit);
        int drawX = root.getDrawX();
        int drawY = root.getDrawY();
        root.setPosition(rootBounds.x, rootBounds.y);
        root.setSize(rootBounds.width, rootBounds.height, false);
        SceneView view = surface.getCurrentSceneView();
        if (view != null) {
            int deltaX = Coordinates.getSwingDimension(view, root.getDrawX() - drawX);
            int deltaY = Coordinates.getSwingDimension(view, root.getDrawY() - drawY);
            Point point = surface.getScrollPosition();
            surface.setScrollPosition(point.x - deltaX, point.y - deltaY);
        }
    }

    @Override
    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = this.getDesignSurface().getCurrentNavigation();
        if (nlComponent == null) {
            NavSceneManager.$$$reportNull$$$0(7);
        }
        return nlComponent;
    }

    @Override
    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component2) {
        if (component2 == null) {
            NavSceneManager.$$$reportNull$$$0(8);
        }
        switch (NavComponentHelperKt.getActionType(component2)) {
            case GLOBAL: 
            case EXIT: {
                return super.createHierarchy(component2);
            }
        }
        NavigationSchema.DestinationType type = NavComponentHelperKt.getDestinationType(component2);
        if (type == null) {
            return null;
        }
        switch (type) {
            case NAVIGATION: {
                if (component2 == this.getRoot()) {
                    return this.buildRoot(component2);
                }
                SceneComponent sceneComponent = this.getScene().getSceneComponent(component2);
                if (sceneComponent == null) {
                    sceneComponent = new SceneComponent(this.getScene(), component2);
                }
                return sceneComponent;
            }
            case FRAGMENT: 
            case ACTIVITY: {
                return super.createHierarchy(component2);
            }
        }
        return null;
    }

    private SceneComponent buildRoot(@NotNull NlComponent rootNlComponent) {
        SceneComponent root;
        if (rootNlComponent == null) {
            NavSceneManager.$$$reportNull$$$0(9);
        }
        if ((root = super.createHierarchy(rootNlComponent)) == null) {
            return null;
        }
        HashMap<String, SceneComponent> destinationMap = new HashMap<String, SceneComponent>();
        for (SceneComponent component2 : root.getChildren()) {
            NlComponent child = component2.getNlComponent();
            if (!NavComponentHelperKt.isDestination(child)) continue;
            destinationMap.put(child.getId(), component2);
        }
        ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
        for (SceneComponent component3 : root.getChildren()) {
            NlComponent child = component3.getNlComponent();
            if (!NavComponentHelperKt.isAction(child)) continue;
            globalActions.add(component3);
        }
        for (SceneComponent globalAction : globalActions) {
            String destination = NavComponentHelperKt.getActionDestinationId(globalAction.getNlComponent());
            SceneComponent parent = (SceneComponent)destinationMap.get(destination);
            if (parent == null) {
                this.getScene().removeComponent(globalAction);
                continue;
            }
            parent.addChild(globalAction);
        }
        return root;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component2) {
        if (component2 == null) {
            NavSceneManager.$$$reportNull$$$0(10);
        }
        TemporarySceneComponent temporarySceneComponent = new TemporarySceneComponent(this.getScene(), component2);
        if (temporarySceneComponent == null) {
            NavSceneManager.$$$reportNull$$$0(11);
        }
        return temporarySceneComponent;
    }

    @Override
    public void requestRender() {
        this.update();
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            root.updateTargets();
            this.layoutAll(root);
        }
    }

    private void layoutAll(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(12);
        }
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(component2 -> component2.setPosition(0, 0));
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(this.myLayoutAlgorithm::layout);
        HashSet<String> regularActionSources = new HashSet<String>();
        HashSet<String> regularActionDestinations = new HashSet<String>();
        NavSceneManager.getRegularActions(root, regularActionSources, regularActionDestinations);
        for (SceneComponent component3 : root.getChildren()) {
            NlComponent nlComponent = component3.getNlComponent();
            if (!NavComponentHelperKt.isDestination(nlComponent)) continue;
            ArrayList<SceneComponent> globalActions = new ArrayList<SceneComponent>();
            ArrayList<SceneComponent> exitActions = new ArrayList<SceneComponent>();
            for (SceneComponent child : component3.getChildren()) {
                switch (NavComponentHelperKt.getActionType(child.getNlComponent())) {
                    case GLOBAL: {
                        globalActions.add(child);
                        break;
                    }
                    case EXIT: {
                        exitActions.add(child);
                        break;
                    }
                }
            }
            String id = nlComponent.getId();
            NavSceneManager.layoutGlobalActions(component3, globalActions, regularActionDestinations.contains(id));
            NavSceneManager.layoutExitActions(component3, exitActions, regularActionSources.contains(id));
        }
    }

    private static void getRegularActions(@NotNull SceneComponent root, @NotNull HashSet<String> sources, @NotNull HashSet<String> destinations) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(13);
        }
        if (sources == null) {
            NavSceneManager.$$$reportNull$$$0(14);
        }
        if (destinations == null) {
            NavSceneManager.$$$reportNull$$$0(15);
        }
        for (SceneComponent component2 : root.getChildren()) {
            NlComponent nlComponent = component2.getNlComponent();
            if (!NavComponentHelperKt.isDestination(nlComponent)) continue;
            nlComponent.flatten().filter(NavComponentHelperKt::isRegularAction).forEach(action -> {
                if (sources == null) {
                    NavSceneManager.$$$reportNull$$$0(26);
                }
                if (destinations == null) {
                    NavSceneManager.$$$reportNull$$$0(27);
                }
                NlComponent parent = action.getParent();
                sources.add(parent.getId());
                destinations.add(NavComponentHelperKt.getEffectiveDestinationId(action));
            });
        }
    }

    private static void layoutGlobalActions(@NotNull SceneComponent destination, @NotNull ArrayList<SceneComponent> globalActions, Boolean skip) {
        if (destination == null) {
            NavSceneManager.$$$reportNull$$$0(16);
        }
        if (globalActions == null) {
            NavSceneManager.$$$reportNull$$$0(17);
        }
        NavSceneManager.layoutActions(destination, globalActions, skip, destination.getDrawX() - 18 - 8);
    }

    private static void layoutExitActions(@NotNull SceneComponent source, @NotNull ArrayList<SceneComponent> exitActions, Boolean skip) {
        if (source == null) {
            NavSceneManager.$$$reportNull$$$0(18);
        }
        if (exitActions == null) {
            NavSceneManager.$$$reportNull$$$0(19);
        }
        NavSceneManager.layoutActions(source, exitActions, skip, source.getDrawX() + source.getDrawWidth() + 2);
    }

    private static void layoutActions(SceneComponent component2, ArrayList<SceneComponent> actions2, Boolean skip, int x) {
        int count = actions2.size();
        if (count == 0) {
            return;
        }
        if (skip.booleanValue()) {
            actions2.add((count + 1) / 2, null);
            ++count;
        }
        int y = component2.getDrawY() + component2.getDrawHeight() / 2 - 6 - count / 2 * 18;
        for (SceneComponent action : actions2) {
            if (action != null) {
                action.setPosition(x, y);
            }
            y += 18;
        }
    }

    @Override
    public void layout(boolean animate) {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            this.updateRootBounds(root);
        }
        this.getDesignSurface().updateScrolledAreaSize();
        this.getScene().needsRebuildList();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        if (this.myDecoratorFactory == null) {
            this.myDecoratorFactory = new NavSceneDecoratorFactory(this.getDesignSurface().getSchema());
        }
        SceneDecoratorFactory sceneDecoratorFactory = this.myDecoratorFactory;
        if (sceneDecoratorFactory == null) {
            NavSceneManager.$$$reportNull$$$0(20);
        }
        return sceneDecoratorFactory;
    }

    @Override
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return ImmutableMap.of();
    }

    public static void updateHierarchy(@NotNull NlModel model, @Nullable NlModel newModel) {
        if (model == null) {
            NavSceneManager.$$$reportNull$$$0(21);
        }
        Object roots = ImmutableList.of();
        XmlTag newRoot = AndroidPsiUtils.getRootTagSafely(model.getFile());
        if (newModel != null) {
            newRoot = AndroidPsiUtils.getRootTagSafely(newModel.getFile());
            roots = NavSceneManager.buildTree((XmlTag[])newModel.getComponents().stream().map(NlComponent::getTag).toArray(XmlTag[]::new));
        }
        if (newRoot != null) {
            model.syncWithPsi(newRoot, (List<NlModel.TagSnapshotTreeNode>)roots);
        }
    }

    private static List<NlModel.TagSnapshotTreeNode> buildTree(XmlTag[] roots) {
        ArrayList<NlModel.TagSnapshotTreeNode> result = new ArrayList<NlModel.TagSnapshotTreeNode>();
        for (final XmlTag root : roots) {
            NlModel.TagSnapshotTreeNode node = new NlModel.TagSnapshotTreeNode(){

                @Override
                public TagSnapshot getTagSnapshot() {
                    return TagSnapshot.createTagSnapshot(root, null);
                }

                @Override
                @NotNull
                public List<NlModel.TagSnapshotTreeNode> getChildren() {
                    List list = NavSceneManager.buildTree(root.getSubTags());
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/naveditor/scene/NavSceneManager$1", "getChildren"));
                }
            };
            result.add(node);
        }
        return result;
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull SceneComponent root) {
        if (root == null) {
            NavSceneManager.$$$reportNull$$$0(22);
        }
        Rectangle rectangle = NavSceneManager.getBoundingBox(root.getChildren());
        if (rectangle == null) {
            NavSceneManager.$$$reportNull$$$0(23);
        }
        return rectangle;
    }

    @NotNull
    public static Rectangle getBoundingBox(@NotNull List<SceneComponent> components) {
        if (components == null) {
            NavSceneManager.$$$reportNull$$$0(24);
        }
        Rectangle boundingBox = new Rectangle(0, 0, -1, -1);
        Rectangle childRect = new Rectangle();
        for (SceneComponent child : components) {
            child.fillDrawRect(0L, childRect);
            if (boundingBox.width < 0) {
                boundingBox.setBounds(childRect);
                continue;
            }
            boundingBox.add(childRect);
        }
        boundingBox.grow(100, 100);
        Rectangle rectangle = boundingBox;
        if (rectangle == null) {
            NavSceneManager.$$$reportNull$$$0(25);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneComponent";
                break;
            }
            case 6: 
            case 12: 
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNlComponent";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinations";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalActions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitActions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateSceneView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemporaryComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneDecoratorFactory";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundingBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postUpdateFromComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateRootBounds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTemporaryComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "layoutAll";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRegularActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "layoutGlobalActions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "layoutExitActions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getBoundingBox";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRegularActions$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 20: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(1);
            }
            NavSceneManager.updateHierarchy(model, model);
            NavSceneManager.this.requestRender();
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(2);
            }
            boolean previous = NavSceneManager.this.getScene().isAnimated();
            UIUtil.invokeLaterIfNeeded(() -> {
                NavSceneManager.this.getScene().setAnimated(animate);
                NavSceneManager.this.update();
                NavSceneManager.this.getScene().setAnimated(previous);
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(3);
            }
            NavSceneManager.updateHierarchy(model, model);
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model) {
            if (model == null) {
                ModelChangeListener.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "model";
            objectArray2[1] = "com/android/tools/idea/naveditor/scene/NavSceneManager$ModelChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDerivedDataChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelChangedOnLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelActivated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "modelDeactivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

