/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ThumbnailManager
extends AndroidFacetScopedService {
    private static final Key<ThumbnailManager> KEY = Key.create((String)ThumbnailManager.class.getName());
    private final Table<XmlFile, Configuration, ImagePool.Image> myImages;
    private final Table<XmlFile, Configuration, Long> myRenderVersions;
    private final Table<XmlFile, Configuration, Long> myRenderModStamps;
    private final AppResourceRepository myResourceRepository;

    @NotNull
    public static ThumbnailManager getInstance(@NotNull AndroidFacet facet) {
        ThumbnailManager manager;
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(0);
        }
        if ((manager = (ThumbnailManager)facet.getUserData(KEY)) == null) {
            manager = new ThumbnailManager(facet);
            ThumbnailManager.setInstance(facet, manager);
        }
        ThumbnailManager thumbnailManager = manager;
        if (thumbnailManager == null) {
            ThumbnailManager.$$$reportNull$$$0(1);
        }
        return thumbnailManager;
    }

    public static void setInstance(@NotNull AndroidFacet facet, @Nullable ThumbnailManager manager) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(2);
        }
        facet.putUserData(KEY, manager);
    }

    protected ThumbnailManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(3);
        }
        super(facet);
        this.myImages = HashBasedTable.create();
        this.myRenderVersions = HashBasedTable.create();
        this.myRenderModStamps = HashBasedTable.create();
        this.myResourceRepository = AppResourceRepository.getOrCreateInstance(facet);
    }

    @Nullable
    public CompletableFuture<ImagePool.Image> getThumbnail(@NotNull XmlFile file, @NotNull DesignSurface surface, @NotNull Configuration configuration) {
        if (file == null) {
            ThumbnailManager.$$$reportNull$$$0(4);
        }
        if (surface == null) {
            ThumbnailManager.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            ThumbnailManager.$$$reportNull$$$0(6);
        }
        ImagePool.Image cached = (ImagePool.Image)this.myImages.get((Object)file, (Object)configuration);
        long version = this.myResourceRepository.getModificationCount();
        long modStamp = file.getModificationStamp();
        if (cached != null && (Long)this.myRenderVersions.get((Object)file, (Object)configuration) == version && ((Long)this.myRenderModStamps.get((Object)file, (Object)configuration)).longValue() == file.getModificationStamp()) {
            return CompletableFuture.completedFuture(cached);
        }
        RenderService renderService = RenderService.getInstance(this.getFacet());
        RenderLogger logger = renderService.createLogger();
        RenderTask task = this.createTask(file, surface, configuration, renderService, logger);
        CompletableFuture<ImagePool.Image> result = new CompletableFuture<ImagePool.Image>();
        if (task != null) {
            ListenableFuture<RenderResult> renderResult = task.render();
            renderResult.addListener(() -> {
                void result;
                if (file == null) {
                    ThumbnailManager.$$$reportNull$$$0(11);
                }
                if (configuration == null) {
                    ThumbnailManager.$$$reportNull$$$0(12);
                }
                try {
                    ImagePool.Image image = ((RenderResult)renderResult.get()).getRenderedImage();
                    this.myImages.put((Object)file, (Object)configuration, (Object)image);
                    this.myRenderVersions.put((Object)file, (Object)configuration, (Object)version);
                    this.myRenderModStamps.put((Object)file, (Object)configuration, (Object)modStamp);
                    result.complete(image);
                }
                catch (InterruptedException | ExecutionException e) {
                    result.completeExceptionally(e);
                }
            }, (Executor)PooledThreadExecutor.INSTANCE);
        } else {
            result.complete(null);
        }
        return result;
    }

    @Nullable
    protected RenderTask createTask(@NotNull XmlFile file, @NotNull DesignSurface surface, @NotNull Configuration configuration, RenderService renderService, RenderLogger logger) {
        RenderTask task;
        if (file == null) {
            ThumbnailManager.$$$reportNull$$$0(7);
        }
        if (surface == null) {
            ThumbnailManager.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            ThumbnailManager.$$$reportNull$$$0(9);
        }
        if ((task = renderService.createTask((PsiFile)file, configuration, logger, surface)) != null) {
            task.setDecorations(false);
        }
        return task;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ThumbnailManager.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/ThumbnailManager";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/ThumbnailManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInstance";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getThumbnail";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getThumbnail$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

