/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommandSerializationHelperKt;
import com.android.tools.idea.naveditor.scene.NavColorSet;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.decorator.ActionDecoratorKt;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import com.android.tools.idea.naveditor.scene.targets.ActionTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends NavBaseDrawCommand {
    private static final GeneralPath PATH = new GeneralPath();
    private final ActionTarget.ConnectionType myConnectionType;
    private final Rectangle mySource;
    private final Rectangle myDest;
    private static final int ARCH_LEN = 10;
    private final DrawMode myMode;

    public DrawAction(@NotNull String s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(0);
        }
        this(DrawCommandSerializationHelperKt.parse(s, 4));
    }

    @Override
    public int getLevel() {
        return 2;
    }

    @Override
    public String serialize() {
        return DrawCommandSerializationHelperKt.buildString(this.getClass().getSimpleName(), new Object[]{this.myConnectionType, DrawCommandSerializationHelperKt.rectToString(this.mySource), DrawCommandSerializationHelperKt.rectToString(this.myDest), this.myMode});
    }

    @Override
    protected void onPaint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(1);
        }
        if (sceneContext == null) {
            DrawAction.$$$reportNull$$$0(2);
        }
        NavDrawHelperKt.setRenderingHints(g);
        NavColorSet color = (NavColorSet)sceneContext.getColorSet();
        DrawAction.draw(g, color, this.myConnectionType, this.mySource, this.myDest, this.myMode, sceneContext);
    }

    public DrawAction(@NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(3);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(4);
        }
        this.mySource = new Rectangle();
        this.myDest = new Rectangle();
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.myMode = mode;
    }

    private DrawAction(@NotNull String[] s) {
        if (s == null) {
            DrawAction.$$$reportNull$$$0(5);
        }
        this(ActionTarget.ConnectionType.valueOf(s[0]), DrawCommandSerializationHelperKt.stringToRect(s[1]), DrawCommandSerializationHelperKt.stringToRect(s[2]), DrawMode.valueOf(s[3]));
    }

    public static void buildDisplayList(@NotNull DisplayList list, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        if (list == null) {
            DrawAction.$$$reportNull$$$0(6);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(7);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(8);
        }
        list.add(new DrawAction(connectionType, source, dest, mode));
    }

    private static void draw(@NotNull Graphics2D g, @NotNull NavColorSet color, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode, @NotNull SceneContext sceneContext) {
        if (g == null) {
            DrawAction.$$$reportNull$$$0(9);
        }
        if (color == null) {
            DrawAction.$$$reportNull$$$0(10);
        }
        if (connectionType == null) {
            DrawAction.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            DrawAction.$$$reportNull$$$0(12);
        }
        if (sceneContext == null) {
            DrawAction.$$$reportNull$$$0(13);
        }
        Color actionColor = mode == DrawMode.SELECTED ? color.getSelectedActions() : (mode == DrawMode.HOVER ? color.getHighlightedActions() : color.getActions());
        PATH.reset();
        switch (connectionType) {
            case SELF: {
                ActionTarget.SelfActionPoints selfActionPoints = ActionTarget.getSelfActionPoints(source, sceneContext);
                PATH.moveTo(selfActionPoints.x[0], selfActionPoints.y[0]);
                DrawConnectionUtils.drawRound(PATH, selfActionPoints.x, selfActionPoints.y, selfActionPoints.x.length, sceneContext.getSwingDimension(10));
                break;
            }
            case NORMAL: 
            case EXIT: {
                ActionTarget.CurvePoints points = ActionTarget.getCurvePoints(source, dest, sceneContext);
                PATH.moveTo(points.p1.x, points.p1.y);
                PATH.curveTo(points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
                break;
            }
            default: {
                return;
            }
        }
        BasicStroke actionStroke = connectionType == ActionTarget.ConnectionType.EXIT ? ActionDecoratorKt.DASHED_ACTION_STROKE : ActionDecoratorKt.ACTION_STROKE;
        g.setStroke(actionStroke);
        g.setColor(actionColor);
        g.draw(PATH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionType";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/scene/draw/DrawAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onPaint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDisplayList";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "draw";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum DrawMode {
        NORMAL,
        SELECTED,
        HOVER;

    }
}

