/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk.java;

import com.android.tools.idea.apk.debugging.ApkPackage;
import com.android.tools.idea.apk.debugging.DexSourceFiles;
import com.android.tools.idea.navigator.nodes.apk.java.DexFileStructure;
import com.android.tools.idea.navigator.nodes.apk.java.PackageNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexGroupNode
extends ProjectViewNode<VirtualFile> {
    @NotNull
    private final DexSourceFiles myDexSourceFiles;
    @Nullable
    private final DexFileStructure myDexFileStructure;
    private Collection<ApkPackage> myPackages;
    private static final VirtualFile NULL_DEX = new StubVirtualFile();

    public DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @Nullable VirtualFile dexFile) {
        if (project == null) {
            DexGroupNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DexGroupNode.$$$reportNull$$$0(1);
        }
        this(project, settings, DexSourceFiles.getInstance(project), dexFile);
    }

    DexGroupNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull DexSourceFiles dexSourceFiles, @Nullable VirtualFile dexFile) {
        if (project == null) {
            DexGroupNode.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            DexGroupNode.$$$reportNull$$$0(3);
        }
        if (dexSourceFiles == null) {
            DexGroupNode.$$$reportNull$$$0(4);
        }
        super(project, ObjectUtils.notNull((Object)dexFile, (Object)NULL_DEX), settings);
        this.myPackages = Collections.emptyList();
        this.myDexSourceFiles = dexSourceFiles;
        this.myDexFileStructure = dexFile != null ? new DexFileStructure(dexFile) : null;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        if (this.myDexFileStructure != null) {
            Collection<? extends AbstractTreeNode> collection;
            try {
                this.myPackages = this.myDexFileStructure.getPackages();
                collection = this.getChildren(this.myPackages);
            }
            catch (Throwable e) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn("Failed to parse dex file", e);
            }
            if (collection == null) {
                DexGroupNode.$$$reportNull$$$0(5);
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            DexGroupNode.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private Collection<? extends AbstractTreeNode> getChildren(@NotNull Collection<ApkPackage> packages) {
        if (packages == null) {
            DexGroupNode.$$$reportNull$$$0(7);
        }
        assert (this.myProject != null);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ViewSettings settings = this.getSettings();
        if (settings.isFlattenPackages()) {
            this.addPackagesAsFlatList(packages, children);
        } else {
            this.addPackagesAsTree(packages, children);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            DexGroupNode.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void addPackagesAsFlatList(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode> children) {
        if (packages == null) {
            DexGroupNode.$$$reportNull$$$0(9);
        }
        if (children == null) {
            DexGroupNode.$$$reportNull$$$0(10);
        }
        for (ApkPackage apkPackage : packages) {
            boolean hideEmptyMiddlePackages = this.getSettings().isHideEmptyMiddlePackages();
            if (!hideEmptyMiddlePackages || !apkPackage.getClasses().isEmpty()) {
                children.add((AbstractTreeNode)this.createNode(apkPackage));
            }
            this.addPackagesAsFlatList(apkPackage.getSubpackages(), children);
        }
    }

    private void addPackagesAsTree(@NotNull Collection<ApkPackage> packages, @NotNull List<AbstractTreeNode> children) {
        if (packages == null) {
            DexGroupNode.$$$reportNull$$$0(11);
        }
        if (children == null) {
            DexGroupNode.$$$reportNull$$$0(12);
        }
        if (this.getSettings().isHideEmptyMiddlePackages()) {
            for (ApkPackage apkPackage : packages) {
                if (!apkPackage.getClasses().isEmpty() || apkPackage.doSubpackagesHaveClasses()) {
                    children.add((AbstractTreeNode)this.createNode(apkPackage));
                    continue;
                }
                this.addPackagesAsTree(apkPackage.getSubpackages(), children);
            }
        } else {
            for (ApkPackage apkPackage : packages) {
                children.add((AbstractTreeNode)this.createNode(apkPackage));
            }
        }
    }

    @NotNull
    private PackageNode createNode(ApkPackage apkPackage) {
        assert (this.myProject != null);
        PackageNode packageNode = new PackageNode(this.myProject, apkPackage, this.getSettings(), this.myDexSourceFiles);
        if (packageNode == null) {
            DexGroupNode.$$$reportNull$$$0(13);
        }
        return packageNode;
    }

    public boolean contains(@NotNull VirtualFile file) {
        block4: {
            block5: {
                if (file == null) {
                    DexGroupNode.$$$reportNull$$$0(14);
                }
                if (this.myDexFileStructure == null) break block4;
                if (!this.myDexSourceFiles.isJavaFile(file)) break block5;
                assert (this.myProject != null);
                String foundPackage = this.myDexSourceFiles.findJavaPackageNameIn(file);
                for (ApkPackage apkPackage : this.myPackages) {
                    if (foundPackage == null || !foundPackage.contains(apkPackage.getFqn())) continue;
                    return true;
                }
                break block4;
            }
            if (!this.myDexSourceFiles.isSmaliFile(file)) break block4;
            File filePath = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            for (ApkPackage apkPackage : this.myPackages) {
                File packageFilePath = this.myDexSourceFiles.findSmaliFilePathForPackage(apkPackage.getFqn());
                if (!FileUtil.isAncestor((File)packageFilePath, (File)filePath, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            DexGroupNode.$$$reportNull$$$0(15);
        }
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        presentation.addText(DexGroupNode.getSourceType().getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        VirtualFile dexFile = (VirtualFile)this.getValue();
        if (dexFile != NULL_DEX) {
            presentation.addText(" (" + dexFile.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getTypeSortKey();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return DexGroupNode.getSourceType();
    }

    @NotNull
    private static AndroidSourceType getSourceType() {
        AndroidSourceType androidSourceType = AndroidSourceType.JAVA;
        if (androidSourceType == null) {
            DexGroupNode.$$$reportNull$$$0(16);
        }
        return androidSourceType;
    }

    public boolean isAlwaysExpand() {
        return true;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        String text = DexGroupNode.getSourceType().getName();
        VirtualFile dexFile = (VirtualFile)this.getValue();
        if (dexFile != NULL_DEX) {
            text = text + " (" + dexFile.getName() + ")";
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexSourceFiles";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/apk/java/DexGroupNode";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/apk/java/DexGroupNode";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesAsFlatList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPackagesAsTree";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

