/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeHelper {
    private static final String DEFAULT_THEME_NAME = "AppTheme";
    private static final String ALTERNATE_THEME_NAME = "Theme.App";
    private static final String APP_COMPAT = "Theme.AppCompat.";
    private final Module myModule;
    private final ProjectResourceRepository myProjectRepository;

    public ThemeHelper(@NotNull Module module) {
        if (module == null) {
            ThemeHelper.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myProjectRepository = ProjectResourceRepository.getOrCreateInstance(module);
    }

    @Nullable
    public String getAppThemeName() {
        String manifestTheme = MergedManifest.get(this.myModule).getManifestTheme();
        if (manifestTheme != null) {
            manifestTheme = StringUtil.trimStart((String)manifestTheme, (String)"@style/");
            return manifestTheme;
        }
        if (this.getProjectStyleResource(DEFAULT_THEME_NAME) != null) {
            return DEFAULT_THEME_NAME;
        }
        if (this.getProjectStyleResource(ALTERNATE_THEME_NAME) != null) {
            return ALTERNATE_THEME_NAME;
        }
        return null;
    }

    public boolean isAppCompatTheme(@NotNull String themeName) {
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(1);
        }
        StyleResourceValue theme = this.getProjectStyleResource(themeName);
        return this.isAppCompatTheme(themeName, theme);
    }

    public static boolean themeExists(@NotNull Configuration configuration, @NotNull String themeName) {
        if (configuration == null) {
            ThemeHelper.$$$reportNull$$$0(2);
        }
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(3);
        }
        return ThemeHelper.getStyleResource(configuration, themeName) != null;
    }

    public boolean isLocalTheme(@NotNull String themeName) {
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(4);
        }
        return this.getProjectStyleResource(themeName) != null;
    }

    public static Boolean hasActionBar(@NotNull Configuration configuration, @NotNull String themeName) {
        StyleResourceValue theme;
        if (configuration == null) {
            ThemeHelper.$$$reportNull$$$0(5);
        }
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(6);
        }
        if ((theme = ThemeHelper.getStyleResource(configuration, themeName)) == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        ItemResourceValue value = resolver.findItemInStyle(theme, "windowActionBar", theme.isFramework());
        if (value == null || value.getValue() == null) {
            return true;
        }
        return "true".equals(value.getValue());
    }

    @Nullable
    private static StyleResourceValue getStyleResource(@NotNull Configuration configuration, @NotNull String themeName) {
        if (configuration == null) {
            ThemeHelper.$$$reportNull$$$0(7);
        }
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(8);
        }
        configuration.setTheme(themeName);
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        boolean isFramework = themeName.startsWith("android:");
        if (isFramework) {
            themeName = themeName.substring("android:".length());
        }
        return resolver.getStyle(themeName, isFramework);
    }

    @Nullable
    private StyleResourceValue getProjectStyleResource(@Nullable String theme) {
        if (theme == null) {
            return null;
        }
        List items = this.myProjectRepository.getResourceItem(ResourceType.STYLE, theme);
        if (items == null || items.isEmpty()) {
            return null;
        }
        return (StyleResourceValue)((ResourceItem)items.get(0)).getResourceValue(false);
    }

    private boolean isAppCompatTheme(@NotNull String themeName, @Nullable StyleResourceValue localTheme) {
        if (themeName == null) {
            ThemeHelper.$$$reportNull$$$0(9);
        }
        while (localTheme != null) {
            String parentThemeName = localTheme.getParentStyle();
            if (parentThemeName == null) {
                if (themeName.lastIndexOf(46) > 0) {
                    parentThemeName = themeName.substring(0, themeName.lastIndexOf(46));
                } else {
                    return false;
                }
            }
            themeName = parentThemeName;
            localTheme = this.getProjectStyleResource(themeName);
        }
        return themeName.startsWith(APP_COMPAT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeName";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/npw/ThemeHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAppCompatTheme";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "themeExists";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalTheme";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasActionBar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getStyleResource";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

