/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.tools.idea.npw.FormFactor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class FormFactorUtils {
    @Nullable
    public static Icon getFormFactorsImage(JComponent component2, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        for (FormFactor formFactor : FormFactor.values()) {
            if (formFactor == FormFactor.GLASS || requireEmulator && !formFactor.hasEmulator()) continue;
            Icon icon = formFactor.getLargeIcon();
            height = Math.max(height, icon.getIconHeight());
            width += formFactor.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (FormFactor formFactor : FormFactor.values()) {
            if (requireEmulator && !formFactor.hasEmulator() || formFactor == FormFactor.GLASS) continue;
            Icon icon = formFactor.getLargeIcon();
            icon.paintIcon(component2, graphics, x, 0);
            x += icon.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }
}

