/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable;

import com.google.common.collect.Queues;
import java.util.Queue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatchInvoker {
    public static final Strategy SWING_INVOKE_LATER_STRATEGY = SwingUtilities::invokeLater;
    public static final Strategy INVOKE_IMMEDIATELY_STRATEGY = Runnable::run;
    private static final int MAX_CYCLE_COUNT = 10;
    private static Strategy ourOverrideStrategy = null;
    private final Strategy myStrategy;
    private final Queue<Runnable> myRunnables;
    private final Queue<Runnable> myDeferredRunnables;
    private boolean myUpdateInProgress;

    public BatchInvoker() {
        this(ourOverrideStrategy != null ? ourOverrideStrategy : SWING_INVOKE_LATER_STRATEGY);
    }

    public BatchInvoker(@NotNull Strategy strategy) {
        if (strategy == null) {
            BatchInvoker.$$$reportNull$$$0(0);
        }
        this.myRunnables = Queues.newArrayDeque();
        this.myDeferredRunnables = Queues.newArrayDeque();
        this.myStrategy = strategy;
    }

    public void enqueue(@NotNull Runnable runnable) {
        if (runnable == null) {
            BatchInvoker.$$$reportNull$$$0(1);
        }
        if (this.myUpdateInProgress) {
            if (!this.myDeferredRunnables.contains(runnable)) {
                this.myDeferredRunnables.add(runnable);
            }
            return;
        }
        boolean shouldInvoke = this.myRunnables.isEmpty();
        if (!this.myRunnables.contains(runnable)) {
            this.myRunnables.add(runnable);
        }
        if (shouldInvoke) {
            this.enqueueInvoke();
        }
    }

    private void enqueueInvoke() {
        this.myStrategy.invoke(() -> {
            int cycleCount = 0;
            RuntimeException runnableExceptionChain = null;
            while (true) {
                this.myUpdateInProgress = true;
                for (Runnable runnable : this.myRunnables) {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException ex) {
                        runnableExceptionChain = BatchInvoker.addExceptionCause(ex, runnableExceptionChain);
                    }
                }
                this.myRunnables.clear();
                this.myUpdateInProgress = false;
                if (this.myDeferredRunnables.isEmpty()) break;
                if (++cycleCount > 10) {
                    this.myDeferredRunnables.clear();
                    throw new InfiniteCycleException(runnableExceptionChain);
                }
                this.myRunnables.addAll(this.myDeferredRunnables);
                this.myDeferredRunnables.clear();
            }
            if (runnableExceptionChain != null) {
                throw runnableExceptionChain;
            }
        });
    }

    public static void setOverrideStrategy(Strategy overrideStrategy) {
        ourOverrideStrategy = overrideStrategy;
    }

    public static void clearOverrideStrategy() {
        ourOverrideStrategy = null;
    }

    private static RuntimeException addExceptionCause(@NotNull RuntimeException ex, @Nullable RuntimeException cause) {
        if (ex == null) {
            BatchInvoker.$$$reportNull$$$0(2);
        }
        if (cause != null) {
            Throwable tail = ex;
            while (tail.getCause() != null) {
                tail = ex.getCause();
            }
            tail.initCause(cause);
        }
        return ex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/observable/BatchInvoker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "enqueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addExceptionCause";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class InfiniteCycleException
    extends RuntimeException {
        public InfiniteCycleException(@Nullable Throwable cause) {
            super("Endless invocation cycle detected.", cause);
        }
    }

    public static interface Strategy {
        public void invoke(@NotNull Runnable var1);
    }
}

