/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Sets;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImagePool {
    public static final Image NULL_POOLED_IMAGE = new Image(){

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (g == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void paint(Consumer<Graphics2D> command) {
        }

        @Override
        @Nullable
        public BufferedImage getCopy(int x, int y, int w, int h) {
            return null;
        }

        @Override
        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/rendering/ImagePool$1", "drawImageTo"));
        }
    };
    private static final boolean DEBUG = false;
    private static final Bucket NULL_BUCKET = new Bucket(0, 0, 0);
    private final int[] myBucketSizes;
    private final HashMap<String, Bucket> myPool;
    private final BiFunction<Integer, Integer, Function<Integer, Integer>> myBucketSizingPolicy;
    private final FinalizableReferenceQueue myFinalizableReferenceQueue;
    private final Set<Reference<?>> myReferences;
    private boolean isDisposed;

    public ImagePool(@NotNull int[] bucketSizes, @NotNull BiFunction<Integer, Integer, Function<Integer, Integer>> bucketSizingPolicy) {
        if (bucketSizes == null) {
            ImagePool.$$$reportNull$$$0(0);
        }
        if (bucketSizingPolicy == null) {
            ImagePool.$$$reportNull$$$0(1);
        }
        this.myPool = new HashMap();
        this.myFinalizableReferenceQueue = new FinalizableReferenceQueue();
        this.myReferences = Sets.newConcurrentHashSet();
        this.isDisposed = false;
        this.myBucketSizes = bucketSizes;
        Arrays.sort(this.myBucketSizes);
        this.myBucketSizingPolicy = bucketSizingPolicy;
    }

    @NotNull
    private static String getPoolKey(int w, int h, int type) {
        String string = "" + w + 'x' + h + '-' + type;
        if (string == null) {
            ImagePool.$$$reportNull$$$0(2);
        }
        return string;
    }

    public ImagePool() {
        this(new int[]{50, 500, 1000, 1500, 2000, 5000}, (w, h) -> type -> {
            if (w * h < 1000) {
                return 0;
            }
            return 50000000 / (w * h);
        });
    }

    @NotNull
    private Bucket getTypeBucket(int w, int h, int type) {
        if (this.myBucketSizingPolicy.apply(w, h).apply(type) == 0) {
            Bucket bucket = NULL_BUCKET;
            if (bucket == null) {
                ImagePool.$$$reportNull$$$0(3);
            }
            return bucket;
        }
        int widthBucket = -1;
        int heightBucket = -1;
        for (int bucketMinSize : this.myBucketSizes) {
            if (widthBucket == -1 && w < bucketMinSize) {
                widthBucket = bucketMinSize;
                if (heightBucket != -1) break;
            }
            if (heightBucket != -1 || h >= bucketMinSize) continue;
            heightBucket = bucketMinSize;
            if (widthBucket != -1) break;
        }
        if (widthBucket == -1 || heightBucket == -1) {
            Bucket bucket = NULL_BUCKET;
            if (bucket == null) {
                ImagePool.$$$reportNull$$$0(4);
            }
            return bucket;
        }
        String poolKey = ImagePool.getPoolKey(widthBucket, heightBucket, type);
        int finalWidthBucket = widthBucket;
        int finalHeightBucket = heightBucket;
        Bucket bucket = this.myPool.computeIfAbsent(poolKey, k -> {
            int size = this.myBucketSizingPolicy.apply(finalWidthBucket, finalHeightBucket).apply(type);
            if (size == 0) {
                return NULL_BUCKET;
            }
            return new Bucket(finalWidthBucket, finalHeightBucket, size);
        });
        if (bucket == null) {
            ImagePool.$$$reportNull$$$0(5);
        }
        return bucket;
    }

    @NotNull
    ImageImpl create(final int w, final int h, final int type, final @Nullable Consumer<BufferedImage> freedCallback) {
        BufferedImage image;
        assert (!this.isDisposed) : "ImagePool already disposed";
        final Bucket bucket = this.getTypeBucket(w, h, type);
        try {
            SoftReference imageRef = (SoftReference)bucket.remove();
            while ((image = (BufferedImage)imageRef.get()) == null) {
                imageRef = (SoftReference)bucket.remove();
            }
            Graphics2D g = image.createGraphics();
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, w, h);
            g.dispose();
        }
        catch (NoSuchElementException e) {
            image = new BufferedImage(Math.max(bucket.myMinWidth, w), Math.max(bucket.myMinHeight, h), type);
        }
        ImageImpl pooledImage = new ImageImpl(w, h, image);
        final BufferedImage imagePointer = image;
        FinalizablePhantomReference<Image> reference = new FinalizablePhantomReference<Image>((Image)pooledImage, this.myFinalizableReferenceQueue){

            public void finalizeReferent() {
                if (ImagePool.this.myReferences.remove((Object)this)) {
                    boolean accepted = bucket.offer(new SoftReference<BufferedImage>(imagePointer));
                    if (freedCallback != null) {
                        freedCallback.accept(imagePointer);
                    }
                }
            }
        };
        pooledImage.myOwnReference = (FinalizablePhantomReference)reference;
        this.myReferences.add((Reference<?>)reference);
        ImageImpl imageImpl = pooledImage;
        if (imageImpl == null) {
            ImagePool.$$$reportNull$$$0(6);
        }
        return imageImpl;
    }

    @NotNull
    public Image create(int w, int h, int type) {
        ImageImpl imageImpl = this.create(w, h, type, null);
        if (imageImpl == null) {
            ImagePool.$$$reportNull$$$0(7);
        }
        return imageImpl;
    }

    @NotNull
    public Image copyOf(@Nullable BufferedImage origin) {
        if (origin == null) {
            Image image = NULL_POOLED_IMAGE;
            if (image == null) {
                ImagePool.$$$reportNull$$$0(8);
            }
            return image;
        }
        int w = origin.getWidth();
        int h = origin.getHeight();
        int type = origin.getType();
        ImageImpl image = this.create(w, h, type, null);
        image.drawFrom(origin);
        ImageImpl imageImpl = image;
        if (imageImpl == null) {
            ImagePool.$$$reportNull$$$0(9);
        }
        return imageImpl;
    }

    public void dispose() {
        this.isDisposed = true;
        this.myFinalizableReferenceQueue.close();
        this.myReferences.clear();
        this.myPool.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bucketSizes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bucketSizingPolicy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/ImagePool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/ImagePool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoolKey";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBucket";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImageImpl
    implements Image {
        private FinalizablePhantomReference<Image> myOwnReference;
        @Nullable
        BufferedImage myBuffer;
        final int myWidth;
        final int myHeight;

        private ImageImpl(int w, int h, @NotNull BufferedImage image) {
            if (image == null) {
                ImageImpl.$$$reportNull$$$0(0);
            }
            this.myOwnReference = null;
            assert (w <= image.getWidth() && h <= image.getHeight());
            this.myWidth = w;
            this.myHeight = h;
            this.myBuffer = image;
        }

        @Override
        public int getWidth() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myWidth;
        }

        @Override
        public int getHeight() {
            assert (this.myBuffer != null) : "Image was already disposed";
            return this.myHeight;
        }

        @Override
        public void drawImageTo(@NotNull Graphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
            if (g == null) {
                ImageImpl.$$$reportNull$$$0(1);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            g.drawImage(this.myBuffer, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        }

        @Override
        public void paint(@NotNull Consumer<Graphics2D> command) {
            if (command == null) {
                ImageImpl.$$$reportNull$$$0(2);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            Graphics2D g = this.myBuffer.createGraphics();
            try {
                command.accept(g);
            }
            finally {
                g.dispose();
            }
        }

        @Override
        @NotNull
        public BufferedImage getCopy(int x, int y, int w, int h) {
            assert (this.myBuffer != null) : "Image was already disposed";
            if (x + w > this.myWidth) {
                throw new IndexOutOfBoundsException(String.format("x + y is out bounds (image width is = %d)", h));
            }
            if (y + h > this.myHeight) {
                throw new IndexOutOfBoundsException(String.format("y + h is out bounds (image height is = %d)", h));
            }
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster(x, y, w, h));
            BufferedImage bufferedImage = new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
            if (bufferedImage == null) {
                ImageImpl.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }

        @Override
        @NotNull
        public BufferedImage getCopy() {
            assert (this.myBuffer != null) : "Image was already disposed";
            WritableRaster raster = this.myBuffer.copyData(this.myBuffer.getRaster().createCompatibleWritableRaster(0, 0, this.myWidth, this.myHeight));
            BufferedImage bufferedImage = new BufferedImage(this.myBuffer.getColorModel(), raster, this.myBuffer.isAlphaPremultiplied(), null);
            if (bufferedImage == null) {
                ImageImpl.$$$reportNull$$$0(4);
            }
            return bufferedImage;
        }

        @Override
        public void dispose() {
            assert (this.myBuffer != null) : "Image was already disposed";
            this.myBuffer = null;
            if (this.myOwnReference != null) {
                this.myOwnReference.finalizeReferent();
            }
        }

        void drawFrom(@NotNull BufferedImage origin) {
            if (origin == null) {
                ImageImpl.$$$reportNull$$$0(5);
            }
            assert (this.myBuffer != null) : "Image was already disposed";
            Graphics g = this.myBuffer.getGraphics();
            try {
                g.drawImage(origin, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/ImagePool$ImageImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/ImagePool$ImageImpl";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "drawImageTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "drawFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Image {
        public int getWidth();

        public int getHeight();

        public void drawImageTo(@NotNull Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void paint(Consumer<Graphics2D> var1);

        default public void drawImageTo(@NotNull Graphics g, int x, int y, int w, int h) {
            if (g == null) {
                Image.$$$reportNull$$$0(0);
            }
            this.drawImageTo(g, x, y, x + w, y + h, 0, 0, this.getWidth(), this.getHeight());
        }

        default public void drawImageTo(@NotNull BufferedImage destination) {
            if (destination == null) {
                Image.$$$reportNull$$$0(1);
            }
            Graphics g = destination.getGraphics();
            try {
                this.drawImageTo(g, 0, 0, destination.getWidth(), destination.getHeight());
            }
            finally {
                g.dispose();
            }
        }

        @Nullable
        public BufferedImage getCopy(int var1, int var2, int var3, int var4);

        @Nullable
        default public BufferedImage getCopy() {
            return this.getCopy(0, 0, this.getWidth(), this.getHeight());
        }

        public void dispose();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destination";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/rendering/ImagePool$Image";
            objectArray[2] = "drawImageTo";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Bucket
    extends ForwardingQueue<SoftReference<BufferedImage>> {
        private final Queue<SoftReference<BufferedImage>> myDelegate;
        private final AtomicLong myLastAccess = new AtomicLong(System.currentTimeMillis());
        private final int myMinWidth;
        private final int myMinHeight;

        public Bucket(int minWidth, int minHeight, int maxSize) {
            this.myMinWidth = minWidth;
            this.myMinHeight = minHeight;
            this.myDelegate = maxSize == 0 ? EvictingQueue.create((int)0) : new ArrayBlockingQueue(maxSize);
        }

        protected Queue<SoftReference<BufferedImage>> delegate() {
            this.myLastAccess.set(System.currentTimeMillis());
            return this.myDelegate;
        }
    }
}

