/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.rendering.ClassConverter;
import com.android.tools.idea.rendering.InconvertibleClassError;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderClassLoader
extends ClassLoader {
    protected static final Logger LOG = Logger.getInstance(RenderClassLoader.class);
    private static boolean USE_PRELOAD = Boolean.getBoolean("render.class.loader.preload");
    private static boolean USE_CACHE = Boolean.getBoolean("render.class.loader.cache");
    protected UrlClassLoader myJarClassLoader;
    protected boolean myInsideJarClassLoader;
    protected final int myLayoutlibApiLevel;

    public RenderClassLoader(@Nullable ClassLoader parent, int layoutlibApiLevel) {
        super(parent);
        this.myLayoutlibApiLevel = layoutlibApiLevel;
    }

    protected abstract List<URL> getExternalJars();

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.load(name);
    }

    @NotNull
    protected Class<?> load(String name) throws ClassNotFoundException {
        Class<?> clz = this.loadClassFromJar(name);
        if (clz != null) {
            Class<?> clazz = clz;
            if (clazz == null) {
                RenderClassLoader.$$$reportNull$$$0(0);
            }
            return clazz;
        }
        throw new ClassNotFoundException(name);
    }

    @Nullable
    protected Class<?> loadClassFromJar(@NotNull String name) {
        if (name == null) {
            RenderClassLoader.$$$reportNull$$$0(1);
        }
        if (this.myJarClassLoader == null) {
            List<URL> externalJars = this.getExternalJars();
            this.myJarClassLoader = this.createClassLoader(externalJars);
        }
        try {
            this.myInsideJarClassLoader = true;
            String relative = name.replace('.', '/').concat(".class");
            InputStream is = this.myJarClassLoader.getResourceAsStream(relative);
            if (is != null) {
                byte[] data = ByteStreams.toByteArray((InputStream)is);
                is.close();
                if (!ClassConverter.isValidClassFile(data)) {
                    throw new ClassFormatError(name);
                }
                byte[] rewritten = this.convertClass(data);
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Defining class '%s' from .jar file", LogAnonymizerUtil.anonymizeClassName((String)name)));
                    }
                    Class<?> clazz = this.defineClassAndPackage(name, rewritten, 0, rewritten.length);
                    return clazz;
                }
                catch (UnsupportedClassVersionError inner) {
                    LOG.debug((Throwable)inner);
                    throw InconvertibleClassError.wrap(inner, name, data);
                }
            }
            Class<?> clazz = null;
            return clazz;
        }
        catch (IOException ex) {
            LOG.debug((Throwable)ex);
            throw new Error("Failed to load class " + name, ex);
        }
        finally {
            this.myInsideJarClassLoader = false;
        }
    }

    protected UrlClassLoader createClassLoader(List<URL> externalJars) {
        UrlClassLoader.Builder builder = UrlClassLoader.build().parent((ClassLoader)this).urls(externalJars);
        if (LOG.isDebugEnabled()) {
            LOG.debug("usePreload = " + USE_PRELOAD);
            LOG.debug("useCache = " + USE_CACHE);
        }
        if (!USE_PRELOAD) {
            builder.noPreload();
        }
        if (USE_CACHE) {
            builder.useCache();
        }
        try {
            Method setLogErrorOnMissingJar = UrlClassLoader.Builder.class.getMethod("setLogErrorOnMissingJar", Boolean.TYPE);
            setLogErrorOnMissingJar.invoke((Object)builder, false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return builder.get();
    }

    @Nullable
    protected Class<?> loadClassFile(String fqcn, @NotNull VirtualFile classFile) {
        if (classFile == null) {
            RenderClassLoader.$$$reportNull$$$0(2);
        }
        try {
            byte[] data = classFile.contentsToByteArray();
            return this.loadClass(fqcn, data);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Class<?> loadClass(@NotNull String fqcn, @Nullable byte[] data) {
        if (fqcn == null) {
            RenderClassLoader.$$$reportNull$$$0(3);
        }
        if (data == null) {
            return null;
        }
        if (!ClassConverter.isValidClassFile(data)) {
            throw new ClassFormatError(fqcn);
        }
        byte[] rewritten = this.convertClass(data);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Defining class '%s' from disk file", LogAnonymizerUtil.anonymizeClassName((String)fqcn)));
            }
            return this.defineClassAndPackage(fqcn, rewritten, 0, rewritten.length);
        }
        catch (UnsupportedClassVersionError inner) {
            LOG.debug((Throwable)inner);
            throw InconvertibleClassError.wrap(inner, fqcn, data);
        }
    }

    @NotNull
    protected byte[] convertClass(@NotNull byte[] data) {
        if (data == null) {
            RenderClassLoader.$$$reportNull$$$0(4);
        }
        byte[] byArray = ClassConverter.rewriteClass(data);
        if (byArray == null) {
            RenderClassLoader.$$$reportNull$$$0(5);
        }
        return byArray;
    }

    @NotNull
    protected Class<?> defineClassAndPackage(@NotNull String name, @NotNull byte[] b, int offset, int len) {
        String packageName;
        Package pkg;
        int i;
        if (name == null) {
            RenderClassLoader.$$$reportNull$$$0(6);
        }
        if (b == null) {
            RenderClassLoader.$$$reportNull$$$0(7);
        }
        if ((i = name.lastIndexOf(46)) > 0 && (pkg = this.getPackage(packageName = name.substring(0, i))) == null) {
            this.definePackage(packageName, null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(name, b, offset, len);
        if (clazz == null) {
            RenderClassLoader.$$$reportNull$$$0(8);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderClassLoader";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqcn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderClassLoader";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "defineClassAndPackage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFromJar";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadClassFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "defineClassAndPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

