/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.IntArrayWrapper;
import com.android.resources.ResourceType;
import com.android.tools.idea.LogAnonymizerUtil;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.FileResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.android.tools.idea.res.RDotTxtParser;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceRepositories;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.util.Pair;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.uipreview.ModuleClassLoader;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppResourceRepository
extends MultiResourceRepository {
    private static final Logger LOG = Logger.getInstance(AppResourceRepository.class);
    private static final Key<Boolean> TEMPORARY_RESOURCE_CACHE = Key.create((String)"TemporaryResourceCache");
    private final AndroidFacet myFacet;
    private List<FileResourceRepository> myLibraries;
    private long myIdsModificationCount;
    private final LinkedList<FileResourceRepository> myAarLibraries;
    private Set<String> myIds;
    private final Object RESOURCE_MAP_LOCK;
    @Nullable
    private Multimap<String, VirtualFile> myResourceDirMap;
    private ResourceVisibilityLookup myResourceVisibility;
    private ResourceVisibilityLookup.Provider myResourceVisibilityProvider;
    private static final int DYNAMIC_ID_SEED_START = 0x7FFF0000;
    private Map<ResourceType, TObjectIntHashMap<String>> myResourceValueMap;
    private TIntObjectHashMap<Pair<ResourceType, String>> myResIdValueToNameMap;
    private Map<IntArrayWrapper, String> myStyleableValueToNameMap;
    private final TObjectIntHashMap<TypedResourceName> myName2DynamicIdMap;
    private final TIntObjectHashMap<TypedResourceName> myDynamicId2ResourceMap;
    private int myDynamicSeed;
    private final IntArrayWrapper myWrapper;

    @Nullable
    public static AppResourceRepository getOrCreateInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AppResourceRepository.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? AppResourceRepository.getOrCreateInstance(facet) : null;
    }

    @NotNull
    public static AppResourceRepository getOrCreateInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(1);
        }
        AppResourceRepository appResourceRepository = AppResourceRepository.findAppResources(facet, true);
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(2);
        }
        return appResourceRepository;
    }

    @Nullable
    public static AppResourceRepository findExistingInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AppResourceRepository.$$$reportNull$$$0(3);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? AppResourceRepository.findExistingInstance(facet) : null;
    }

    @Nullable
    public static AppResourceRepository findExistingInstance(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(4);
        }
        return AppResourceRepository.findAppResources(facet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static AppResourceRepository findAppResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(5);
        }
        ResourceRepositories repositories = ResourceRepositories.getOrCreateInstance(facet);
        return repositories.getAppResources(createIfNecessary);
    }

    @NotNull
    static AppResourceRepository create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(6);
        }
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(facet);
        AppResourceRepository repository = new AppResourceRepository(facet, AppResourceRepository.computeRepositories(facet, libraries), libraries);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        AppResourceRepository appResourceRepository = repository;
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(7);
        }
        return appResourceRepository;
    }

    public static boolean testAndClearTempResourceCached(@NotNull Project project) {
        if (project == null) {
            AppResourceRepository.$$$reportNull$$$0(8);
        }
        if (project.getUserData(TEMPORARY_RESOURCE_CACHE) != Boolean.TRUE) {
            return false;
        }
        project.putUserData(TEMPORARY_RESOURCE_CACHE, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Object object = this.RESOURCE_MAP_LOCK;
        synchronized (object) {
            if (this.myResourceDirMap == null) {
                this.myResourceDirMap = HashMultimap.create();
                for (LocalResourceRepository localResourceRepository : this.getChildren()) {
                    this.myResourceDirMap.putAll((Object)localResourceRepository.getLibraryName(), localResourceRepository.getResourceDirs());
                }
            }
            return this.myResourceDirMap;
        }
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet, List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(9);
        }
        ArrayList repositories = Lists.newArrayListWithExpectedSize((int)10);
        ProjectResourceRepository resources = ProjectResourceRepository.getOrCreateInstance(facet);
        repositories.addAll(libraries);
        repositories.add(resources);
        if (((Boolean)StudioFlags.NELE_SAMPLE_DATA.get()).booleanValue()) {
            repositories.add(new SampleDataResourceRepository(facet));
        }
        return repositories;
    }

    private static List<FileResourceRepository> computeLibraries(@NotNull AndroidFacet facet) {
        List<AndroidFacet> dependentFacets;
        Map<File, String> aarDirs;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(10);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("computeLibraries");
        }
        if ((aarDirs = AppResourceRepository.findAarLibraries(facet, dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true))).isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  No AARs");
            }
            return Collections.emptyList();
        }
        ArrayList dirs = Lists.newArrayList(aarDirs.keySet());
        Collections.sort(dirs);
        if (LOG.isDebugEnabled()) {
            for (File root : dirs) {
                LOG.debug("  Dependency: " + LogAnonymizerUtil.anonymizeClassName((String)aarDirs.get(root)));
            }
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)aarDirs.size());
        for (File root : dirs) {
            resources.add(FileResourceRepository.get(root, aarDirs.get(root)));
        }
        return resources;
    }

    @NotNull
    private static Map<File, String> findAarLibraries(@NotNull AndroidFacet facet, @NotNull List<AndroidFacet> dependentFacets) {
        AndroidModuleModel androidModuleModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(11);
        }
        if (dependentFacets == null) {
            AppResourceRepository.$$$reportNull$$$0(12);
        }
        if ((androidModuleModel = AndroidModuleModel.get(facet)) != null) {
            ArrayList libraries = Lists.newArrayList();
            AppResourceRepository.addGradleLibraries(libraries, androidModuleModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
            GradleVersion modelVersion = androidModuleModel.getModelVersion();
            assert (modelVersion != null);
            Map<File, String> map = AppResourceRepository.findAarLibrariesFromGradle(modelVersion, dependentFacets, libraries);
            if (map == null) {
                AppResourceRepository.$$$reportNull$$$0(13);
            }
            return map;
        }
        Project project = facet.getModule().getProject();
        if (GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            project.putUserData(TEMPORARY_RESOURCE_CACHE, (Object)true);
        }
        Map<File, String> map = AppResourceRepository.findAarLibrariesFromIntelliJ(facet, dependentFacets);
        if (map == null) {
            AppResourceRepository.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    public static Collection<Library> findAarLibraries(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(15);
        }
        ArrayList libraries = Lists.newArrayList();
        if (facet.requiresAndroidModel() && (androidModel = AndroidModuleModel.get(facet)) != null) {
            List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AppResourceRepository.addGradleLibraries(libraries, androidModel);
            for (AndroidFacet dependentFacet : dependentFacets) {
                AndroidModuleModel dependentGradleModel = AndroidModuleModel.get(dependentFacet);
                if (dependentGradleModel == null) continue;
                AppResourceRepository.addGradleLibraries(libraries, dependentGradleModel);
            }
        }
        ArrayList arrayList = libraries;
        if (arrayList == null) {
            AppResourceRepository.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static Map<File, String> findAarLibrariesFromIntelliJ(AndroidFacet facet, List<AndroidFacet> dependentFacets) {
        HashMap<File, String> dirs = new HashMap<File, String>();
        ResourceFolderManager.addAarsFromModuleLibraries(facet, dirs);
        for (AndroidFacet f : dependentFacets) {
            ResourceFolderManager.addAarsFromModuleLibraries(f, dirs);
        }
        return dirs;
    }

    @NotNull
    private static Map<File, String> findAarLibrariesFromGradle(@NotNull GradleVersion modelVersion, List<AndroidFacet> dependentFacets, List<Library> libraries) {
        if (modelVersion == null) {
            AppResourceRepository.$$$reportNull$$$0(17);
        }
        HashMap<File, String> files = new HashMap<File, String>(libraries.size());
        HashSet moduleNames = Sets.newHashSet();
        for (AndroidFacet f : dependentFacets) {
            moduleNames.add(f.getModule().getName());
        }
        try {
            for (Library library : libraries) {
                File resFolder;
                String libraryName = library.getArtifactAddress();
                if (moduleNames.contains(libraryName) || !(resFolder = new File(library.getResFolder())).exists()) continue;
                files.put(resFolder, libraryName);
                moduleNames.add(libraryName);
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Incompatibility found between the IDE's builder-model and the cached Gradle model", (Throwable)e);
        }
        HashMap<File, String> hashMap = files;
        if (hashMap == null) {
            AppResourceRepository.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    private static void addGradleLibraries(List<Library> list, AndroidModuleModel androidModuleModel) {
        list.addAll(androidModuleModel.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries());
    }

    protected AppResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates, @NotNull List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(19);
        }
        if (delegates == null) {
            AppResourceRepository.$$$reportNull$$$0(20);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(21);
        }
        super(facet.getModule().getName() + " with modules and libraries", delegates);
        this.myAarLibraries = Lists.newLinkedList();
        this.RESOURCE_MAP_LOCK = new Object();
        this.myName2DynamicIdMap = new TObjectIntHashMap();
        this.myDynamicId2ResourceMap = new TIntObjectHashMap();
        this.myDynamicSeed = 0x7FFF0000;
        this.myWrapper = new IntArrayWrapper(null);
        this.myFacet = facet;
        this.myLibraries = libraries;
        for (FileResourceRepository library : libraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @NotNull
    public List<FileResourceRepository> getLibraries() {
        List<FileResourceRepository> list = this.myLibraries;
        if (list == null) {
            AppResourceRepository.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private Set<String> getAllIds() {
        long currentModCount = this.getModificationCount();
        if (this.myIdsModificationCount < currentModCount) {
            this.myIdsModificationCount = currentModCount;
            if (this.myIds == null) {
                int size = 0;
                for (FileResourceRepository library : this.myLibraries) {
                    if (library.getAllDeclaredIds() == null) continue;
                    size += library.getAllDeclaredIds().size();
                }
                this.myIds = Sets.newHashSetWithExpectedSize((int)size);
            } else {
                this.myIds.clear();
            }
            for (FileResourceRepository library : this.myLibraries) {
                if (library.getAllDeclaredIds() == null) continue;
                this.myIds.addAll(library.getAllDeclaredIds().keySet());
            }
            this.myIds.addAll(super.getItemsOfType(ResourceType.ID));
        }
        Set<String> set = this.myIds;
        if (set == null) {
            AppResourceRepository.$$$reportNull$$$0(23);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<String> getItemsOfType(@NotNull ResourceType type) {
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(24);
        }
        Object object = ITEM_MAP_LOCK;
        // MONITORENTER : object
        Collection<String> collection = type == ResourceType.ID ? this.getAllIds() : super.getItemsOfType(type);
        // MONITOREXIT : object
        if (collection != null) return collection;
        AppResourceRepository.$$$reportNull$$$0(25);
        return collection;
    }

    void updateRoots() {
        List<FileResourceRepository> libraries = AppResourceRepository.computeLibraries(this.myFacet);
        List<LocalResourceRepository> repositories = AppResourceRepository.computeRepositories(this.myFacet, libraries);
        this.updateRoots(repositories, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRoots(List<LocalResourceRepository> resources, List<FileResourceRepository> libraries) {
        this.myResourceVisibility = null;
        this.myResourceVisibilityProvider = null;
        Iterator<FileResourceRepository> iterator = this.RESOURCE_MAP_LOCK;
        synchronized (iterator) {
            this.myResourceDirMap = null;
        }
        this.invalidateResourceDirs();
        if (resources.equals(this.getChildren())) {
            return;
        }
        this.myResourceVisibility = null;
        this.myLibraries = libraries;
        this.myAarLibraries.clear();
        for (FileResourceRepository library : this.myLibraries) {
            if (library.getResourceTextFile() == null) continue;
            this.myAarLibraries.add(library);
        }
        this.setChildren(resources);
        this.resetDynamicIds(true);
        ModuleClassLoader.clearCache(this.myFacet.getModule());
    }

    @NotNull
    static AppResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull List<LocalResourceRepository> modules, @NotNull List<FileResourceRepository> libraries) {
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(26);
        }
        if (modules == null) {
            AppResourceRepository.$$$reportNull$$$0(27);
        }
        if (libraries == null) {
            AppResourceRepository.$$$reportNull$$$0(28);
        }
        assert (modules.containsAll(libraries));
        assert (modules.size() == libraries.size() + 1);
        AppResourceRepository appResourceRepository = new AppResourceRepository(facet, modules, libraries);
        if (appResourceRepository == null) {
            AppResourceRepository.$$$reportNull$$$0(29);
        }
        return appResourceRepository;
    }

    @Nullable
    public FileResourceRepository findRepositoryFor(@NotNull File aarDirectory) {
        if (aarDirectory == null) {
            AppResourceRepository.$$$reportNull$$$0(30);
        }
        String aarPath = aarDirectory.getPath();
        for (LocalResourceRepository localResourceRepository : this.myLibraries) {
            if (localResourceRepository instanceof FileResourceRepository) {
                FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                if (!repository.getResourceDirectory().getPath().startsWith(aarPath)) continue;
                return repository;
            }
            assert (false) : ((Object)((Object)localResourceRepository)).getClass();
        }
        int exploded = aarPath.indexOf("exploded-aar");
        if (exploded != -1) {
            String string = aarPath.substring(exploded) + File.separator + "res";
            for (LocalResourceRepository localResourceRepository : this.myLibraries) {
                if (localResourceRepository instanceof FileResourceRepository) {
                    FileResourceRepository repository = (FileResourceRepository)localResourceRepository;
                    String path = repository.getResourceDirectory().getPath();
                    if (!path.endsWith(string)) continue;
                    return repository;
                }
                assert (false) : ((Object)((Object)localResourceRepository)).getClass();
            }
        }
        return null;
    }

    @Nullable
    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.myResourceVisibilityProvider == null) {
            if (!this.myFacet.requiresAndroidModel() || this.myFacet.getAndroidModel() == null) {
                return null;
            }
            this.myResourceVisibilityProvider = new ResourceVisibilityLookup.Provider();
        }
        return this.myResourceVisibilityProvider;
    }

    @NotNull
    public ResourceVisibilityLookup getResourceVisibility(@NotNull AndroidFacet facet) {
        ResourceVisibilityLookup.Provider provider;
        AndroidModuleModel androidModel;
        if (facet == null) {
            AppResourceRepository.$$$reportNull$$$0(31);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) != null && (provider = this.getResourceVisibilityProvider()) != null) {
            IdeAndroidProject androidProject = androidModel.getAndroidProject();
            IdeVariant variant = androidModel.getSelectedVariant();
            ResourceVisibilityLookup resourceVisibilityLookup = provider.get((AndroidProject)androidProject, (Variant)variant);
            if (resourceVisibilityLookup == null) {
                AppResourceRepository.$$$reportNull$$$0(32);
            }
            return resourceVisibilityLookup;
        }
        ResourceVisibilityLookup resourceVisibilityLookup = ResourceVisibilityLookup.NONE;
        if (resourceVisibilityLookup == null) {
            AppResourceRepository.$$$reportNull$$$0(33);
        }
        return resourceVisibilityLookup;
    }

    public boolean isPrivate(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            AppResourceRepository.$$$reportNull$$$0(34);
        }
        if (name == null) {
            AppResourceRepository.$$$reportNull$$$0(35);
        }
        if (this.myResourceVisibility == null) {
            ResourceVisibilityLookup.Provider provider = this.getResourceVisibilityProvider();
            if (provider == null) {
                return false;
            }
            AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
            if (androidModel == null) {
                return false;
            }
            this.myResourceVisibility = provider.get((AndroidProject)androidModel.getAndroidProject(), (Variant)androidModel.getSelectedVariant());
        }
        return this.myResourceVisibility.isPrivate(type, name);
    }

    @Nullable
    public Pair<ResourceType, String> resolveResourceId(int id) {
        TypedResourceName pair;
        Pair<ResourceType, String> result = null;
        if (this.myResIdValueToNameMap != null) {
            result = (Pair<ResourceType, String>)this.myResIdValueToNameMap.get(id);
        }
        if (result == null && (pair = (TypedResourceName)this.myDynamicId2ResourceMap.get(id)) != null) {
            result = pair.toPair();
        }
        return result;
    }

    @Nullable
    public String resolveStyleable(int[] id) {
        if (this.myStyleableValueToNameMap != null) {
            this.myWrapper.set(id);
            return this.myStyleableValueToNameMap.get(this.myWrapper);
        }
        return null;
    }

    @NotNull
    public Integer getResourceId(ResourceType type, String name) {
        TObjectIntHashMap<String> map;
        TObjectIntHashMap<String> tObjectIntHashMap = map = this.myResourceValueMap != null ? this.myResourceValueMap.get(type) : null;
        if (map == null || !map.containsKey((Object)name)) {
            Integer n = this.getDynamicId(type, name);
            if (n == null) {
                AppResourceRepository.$$$reportNull$$$0(36);
            }
            return n;
        }
        Integer n = map.get((Object)name);
        if (n == null) {
            AppResourceRepository.$$$reportNull$$$0(37);
        }
        return n;
    }

    @Nullable
    Integer[] getDeclaredArrayValues(List<AttrResourceValue> attrs, String styleableName) {
        ListIterator iter = this.myAarLibraries.listIterator();
        while (iter.hasNext()) {
            FileResourceRepository repo = (FileResourceRepository)((Object)iter.next());
            File resourceTextFile = repo.getResourceTextFile();
            if (resourceTextFile == null) continue;
            Integer[] in = null;
            try {
                in = RDotTxtParser.getDeclareStyleableArray(resourceTextFile, attrs, styleableName);
            }
            catch (Throwable e) {
                assert (false) : e.getLocalizedMessage();
                LOG.warn("Error while parsing R.txt", e);
            }
            if (in == null) continue;
            iter.remove();
            this.myAarLibraries.addFirst(repo);
            return in;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDynamicId(ResourceType type, String name) {
        TypedResourceName key = new TypedResourceName(type, name);
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            if (this.myName2DynamicIdMap.containsKey((Object)key)) {
                return this.myName2DynamicIdMap.get((Object)key);
            }
            int value = ++this.myDynamicSeed;
            this.myName2DynamicIdMap.put((Object)key, value);
            this.myDynamicId2ResourceMap.put(value, (Object)key);
            return value;
        }
    }

    public void setCompiledResources(TIntObjectHashMap<Pair<ResourceType, String>> id2res, Map<IntArrayWrapper, String> styleableId2name, Map<ResourceType, TObjectIntHashMap<String>> res2id) {
        this.myResourceValueMap = res2id;
        this.myResIdValueToNameMap = id2res;
        this.myStyleableValueToNameMap = styleableId2name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDynamicIds(boolean clearResourceRegistry) {
        if (clearResourceRegistry) {
            ResourceClassRegistry.get(this.myFacet.getModule().getProject()).clearCache(this);
        }
        TObjectIntHashMap<TypedResourceName> tObjectIntHashMap = this.myName2DynamicIdMap;
        synchronized (tObjectIntHashMap) {
            this.myDynamicSeed = 0x7FFF0000;
            this.myName2DynamicIdMap.clear();
            this.myDynamicId2ResourceMap.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentFacets";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelVersion";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aarDirectory";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/AppResourceRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibraries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findAarLibrariesFromGradle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsOfType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceVisibility";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstance";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAppResources";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "testAndClearTempResourceCached";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeLibraries";
                break;
            }
            case 11: 
            case 12: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibraries";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findAarLibrariesFromGradle";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getItemsOfType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findRepositoryFor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getResourceVisibility";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TypedResourceName {
        @Nullable
        final ResourceType myType;
        @NotNull
        final String myName;
        Pair<ResourceType, String> myPair;

        TypedResourceName(@Nullable ResourceType type, @NotNull String name) {
            if (name == null) {
                TypedResourceName.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myName = name;
        }

        public Pair<ResourceType, String> toPair() {
            if (this.myPair == null) {
                this.myPair = Pair.of((Object)this.myType, (Object)this.myName);
            }
            return this.myPair;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedResourceName that = (TypedResourceName)o;
            if (this.myType != that.myType) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myType != null ? this.myType.hashCode() : 0;
            result = 31 * result + this.myName.hashCode();
            return result;
        }

        public String toString() {
            return String.format("Type=%1$s, value=%2$s", this.myType, this.myName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/res/AppResourceRepository$TypedResourceName", "<init>"));
        }
    }
}

