/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.resources.ResourceNameKeyedMap;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RDotTxtParser {
    private static Logger ourLog;
    private static final Splitter COMMA_SPLITTER;

    RDotTxtParser() {
    }

    @NotNull
    static Map<String, Integer> getIds(@NotNull File rFile) {
        Map<String, Integer> map;
        if (rFile == null) {
            RDotTxtParser.$$$reportNull$$$0(0);
        }
        try {
            SymbolTable symbolTable = SymbolIo.readFromAapt((File)rFile, null);
            map = symbolTable.getSymbols().row((Object)ResourceType.ID).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Integer.decode(((Symbol)e.getValue()).getValue())));
        }
        catch (IOException e2) {
            RDotTxtParser.getLog().warn("Unable to read file: " + rFile.getPath(), (Throwable)e2);
            Map<String, Integer> map2 = Collections.emptyMap();
            if (map2 == null) {
                RDotTxtParser.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (map == null) {
            RDotTxtParser.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    static Integer[] getDeclareStyleableArray(@NotNull File rFile, List<AttrResourceValue> attrs, String styleableName) {
        if (rFile == null) {
            RDotTxtParser.$$$reportNull$$$0(3);
        }
        try {
            SymbolTable symbolTable = SymbolIo.readFromAapt((File)rFile, null);
            Symbol styleable = (Symbol)symbolTable.getSymbols().row((Object)ResourceType.STYLEABLE).get((Object)styleableName);
            if (styleable == null) {
                RDotTxtParser.getLog().debug("Unable to find styleable: " + styleableName);
                return null;
            }
            ImmutableList values = styleable.getChildren();
            if (values.size() != attrs.size()) {
                RDotTxtParser.getLog().warn(String.format("Styleable does not match attributes size (%d styleable != %d attributes)", values.size(), attrs.size()));
                return null;
            }
            String arrayValues = styleable.getValue().trim();
            if (arrayValues.length() < 2) {
                RDotTxtParser.getLog().warn("Incorrect styleable array definition for: " + styleableName);
                return null;
            }
            arrayValues = arrayValues.substring(1, arrayValues.length() - 1);
            HashMap<String, ResourceNameKeyedMap> namespacesMap = new HashMap<String, ResourceNameKeyedMap>();
            int idx = 0;
            for (String intValue : COMMA_SPLITTER.split((CharSequence)arrayValues)) {
                String attributeKey;
                int nsSeparatorIdx;
                String namespace = (nsSeparatorIdx = (attributeKey = (String)values.get(idx++)).indexOf(58)) != -1 ? attributeKey.substring(0, nsSeparatorIdx) : null;
                String name = nsSeparatorIdx != -1 ? attributeKey.substring(nsSeparatorIdx + 1) : attributeKey;
                ResourceNameKeyedMap styleableValuesMap = (ResourceNameKeyedMap)namespacesMap.get(namespace);
                if (styleableValuesMap == null) {
                    styleableValuesMap = new ResourceNameKeyedMap();
                    namespacesMap.put(namespace, styleableValuesMap);
                }
                styleableValuesMap.put(name, (Object)Integer.decode(intValue));
            }
            Integer[] results = new Integer[values.size()];
            idx = 0;
            for (AttrResourceValue attr : attrs) {
                ResourceNameKeyedMap styleableValuesMap = (ResourceNameKeyedMap)namespacesMap.get(attr.isFramework() ? "android" : null);
                results[idx++] = styleableValuesMap != null ? (Integer)styleableValuesMap.get((Object)attr.getName()) : null;
            }
            return results;
        }
        catch (IOException e) {
            RDotTxtParser.getLog().warn("Unable to read file: " + rFile.getPath(), (Throwable)e);
            return null;
        }
    }

    private static Logger getLog() {
        if (ourLog == null) {
            ourLog = Logger.getInstance(RDotTxtParser.class);
        }
        return ourLog;
    }

    static {
        COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/RDotTxtParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/RDotTxtParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIds";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDeclareStyleableArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

