/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFolderRegistry {
    private static final Object DIR_MAP_LOCK = new Object();
    @GuardedBy(value="DIR_MAP_LOCK")
    private static final Map<VirtualFile, ResourceFolderRepository> ourDirMap = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry<VirtualFile, ResourceFolderRepository> entry : ourDirMap.entrySet()) {
                VirtualFile dir = entry.getKey();
                ResourceFolderRepository repository = entry.getValue();
                Project project = repository.getFacet().getModule().getProject();
                PsiProjectListener.removeRoot(project, dir, repository);
            }
            ourDirMap.clear();
        }
    }

    @NotNull
    public static ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
        if (facet == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(1);
        }
        ResourceFolderRepository resourceFolderRepository = ResourceFolderRegistry.get(facet, dir, null);
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(2);
        }
        return resourceFolderRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @Nullable String namespace) {
        if (facet == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(3);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(4);
        }
        Object object = DIR_MAP_LOCK;
        // MONITORENTER : object
        ResourceFolderRepository repository = ourDirMap.get(dir);
        if (repository == null) {
            Project project = facet.getModule().getProject();
            repository = ResourceFolderRepository.create(facet, dir, namespace);
            ResourceFolderRegistry.putRepositoryInCache(project, dir, repository);
        }
        ResourceFolderRepository resourceFolderRepository = repository;
        // MONITOREXIT : object
        if (resourceFolderRepository != null) return resourceFolderRepository;
        ResourceFolderRegistry.$$$reportNull$$$0(5);
        return resourceFolderRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putRepositoryInCache(@NotNull Project project, @NotNull VirtualFile dir, @NotNull ResourceFolderRepository repository) {
        if (project == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(8);
        }
        PsiProjectListener.addRoot(project, dir, repository);
        Disposer.register((Disposable)project, () -> {
            ResourceFolderRepository repositoryFromMap;
            if (dir == null) {
                ResourceFolderRegistry.$$$reportNull$$$0(11);
            }
            Object object = DIR_MAP_LOCK;
            synchronized (object) {
                repositoryFromMap = ourDirMap.remove(dir);
            }
            if (repositoryFromMap != null) {
                Disposer.dispose((Disposable)repositoryFromMap);
            }
        });
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            ourDirMap.put(dir, repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterOutCached(Map<VirtualFile, AndroidFacet> resDirectories) {
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            resDirectories.keySet().removeAll(ourDirMap.keySet());
        }
    }

    @NotNull
    static Map<VirtualFile, AndroidFacet> getResourceDirectoriesForFacets(@NotNull List<AndroidFacet> facets) {
        if (facets == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(9);
        }
        HashMap resDirectories = Maps.newHashMap();
        for (AndroidFacet facet : facets) {
            for (VirtualFile resourceDir : facet.getAllResourceDirectories()) {
                if (resDirectories.containsKey(resourceDir)) continue;
                resDirectories.put(resourceDir, facet);
            }
        }
        HashMap hashMap = resDirectories;
        if (hashMap == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirectoriesForFacets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putRepositoryInCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirectoriesForFacets";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$putRepositoryInCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            if (project == null) {
                PopulateCachesTask.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets;
            if (indicator == null) {
                PopulateCachesTask.$$$reportNull$$$0(1);
            }
            if ((facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)).isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = ResourceFolderRegistry.getResourceDirectoriesForFacets(facets);
            ResourceFolderRegistry.filterOutCached(resDirectories);
            if (resDirectories.isEmpty()) {
                return;
            }
            Path projectCacheRoot = ResourceFolderRepositoryFileCacheService.get().getProjectDir(this.myProject);
            if (projectCacheRoot == null) {
                return;
            }
            try {
                FileUtil.ensureExists((File)projectCacheRoot.toFile());
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            assert (!application.isWriteAccessAllowed());
            List<ResourceFolderRepository> repositories = PopulateCachesTask.executeParallel(indicator, resDirectories);
            for (ResourceFolderRepository repository : repositories) {
                ResourceFolderRegistry.putRepositoryInCache(this.myProject, repository.getResourceDir(), repository);
            }
        }

        private static List<ResourceFolderRepository> executeParallel(@NotNull ProgressIndicator indicator, @NotNull Map<VirtualFile, AndroidFacet> resDirectories) {
            if (indicator == null) {
                PopulateCachesTask.$$$reportNull$$$0(2);
            }
            if (resDirectories == null) {
                PopulateCachesTask.$$$reportNull$$$0(3);
            }
            int numDone = 0;
            ArrayList repositories = Lists.newArrayList();
            int maxThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
            ExecutorService parallelExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ResourceFolderRegistry", (int)maxThreads);
            ArrayList repositoryJobs = Lists.newArrayList();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                repositoryJobs.add(PopulateCachesTask.queueRepositoryFuture(parallelExecutor, entry.getValue(), entry.getKey()));
            }
            for (Future job : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    repositories.add(job.get());
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
            return repositories;
        }

        private static Future<ResourceFolderRepository> queueRepositoryFuture(@NotNull ExecutorService myParallelBuildExecutor, @NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
            if (myParallelBuildExecutor == null) {
                PopulateCachesTask.$$$reportNull$$$0(4);
            }
            if (facet == null) {
                PopulateCachesTask.$$$reportNull$$$0(5);
            }
            if (dir == null) {
                PopulateCachesTask.$$$reportNull$$$0(6);
            }
            return myParallelBuildExecutor.submit(() -> {
                if (facet == null) {
                    PopulateCachesTask.$$$reportNull$$$0(7);
                }
                if (dir == null) {
                    PopulateCachesTask.$$$reportNull$$$0(8);
                }
                return ResourceFolderRepository.create(facet, dir, null);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resDirectories";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myParallelBuildExecutor";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry$PopulateCachesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeParallel";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "queueRepositoryFuture";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$queueRepositoryFuture$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

