/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonGradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @Nullable
    private final String myArtifactName;

    public NonGradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @Nullable String artifactName) {
        if (facet == null) {
            NonGradleApkProvider.$$$reportNull$$$0(0);
        }
        if (applicationIdProvider == null) {
            NonGradleApkProvider.$$$reportNull$$$0(1);
        }
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myArtifactName = artifactName;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        if (device == null) {
            NonGradleApkProvider.$$$reportNull$$$0(2);
        }
        String packageName = this.myApplicationIdProvider.getPackageName();
        HashMap depFacet2PackageName = new HashMap();
        NonGradleApkProvider.fillRuntimeAndTestDependencies(this.myFacet.getModule(), (Map<AndroidFacet, String>)depFacet2PackageName);
        NonGradleApkProvider.checkPackageNames((Map<AndroidFacet, String>)depFacet2PackageName, this.myFacet, packageName);
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        this.addApk(apkList, packageName, this.myFacet);
        for (AndroidFacet depFacet : depFacet2PackageName.keySet()) {
            this.addApk(apkList, (String)depFacet2PackageName.get((Object)depFacet), depFacet);
        }
        ArrayList<ApkInfo> arrayList = apkList;
        if (arrayList == null) {
            NonGradleApkProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private void addApk(@NotNull List<ApkInfo> apkList, @NotNull String packageName, @NotNull AndroidFacet facet) throws ApkProvisionException {
        String localPath;
        if (apkList == null) {
            NonGradleApkProvider.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            NonGradleApkProvider.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            NonGradleApkProvider.$$$reportNull$$$0(6);
        }
        Module module = facet.getModule();
        if (this.myArtifactName != null && !this.myArtifactName.isEmpty()) {
            Artifact artifact = ArtifactManager.getInstance((Project)facet.getModule().getProject()).findArtifact(this.myArtifactName);
            if (artifact == null) {
                throw new ApkProvisionException("ERROR: cannot find artifact \"" + this.myArtifactName + '\"');
            }
            if (!AndroidArtifactUtil.isRelatedArtifact(artifact, facet.getModule())) {
                throw new ApkProvisionException("ERROR: artifact \"" + this.myArtifactName + "\" doesn't contain packaged module \"" + facet.getModule().getName() + '\"');
            }
            String artifactOutPath = artifact.getOutputFilePath();
            if (artifactOutPath == null || artifactOutPath.isEmpty()) {
                throw new ApkProvisionException("ERROR: output path is not specified for artifact \"" + this.myArtifactName + '\"');
            }
            localPath = FileUtil.toSystemDependentName((String)artifactOutPath);
        } else {
            localPath = AndroidRootUtil.getApkPath(facet);
        }
        if (localPath == null) {
            throw new ApkProvisionException("ERROR: APK path is not specified for module \"" + module.getName() + '\"');
        }
        apkList.add(new ApkInfo(new File(localPath), packageName));
    }

    private static void fillRuntimeAndTestDependencies(@NotNull Module module, @NotNull Map<AndroidFacet, String> module2PackageName) throws ApkProvisionException {
        if (module == null) {
            NonGradleApkProvider.$$$reportNull$$$0(7);
        }
        if (module2PackageName == null) {
            NonGradleApkProvider.$$$reportNull$$$0(8);
        }
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            AndroidFacet depFacet;
            ModuleOrderEntry moduleOrderEntry;
            Module depModule;
            if (!(entry instanceof ModuleOrderEntry) || (depModule = (moduleOrderEntry = (ModuleOrderEntry)entry).getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || module2PackageName.containsKey((Object)depFacet) || !depFacet.isAppProject()) continue;
            String packageName = ApkProviderUtil.computePackageName(depFacet);
            module2PackageName.put(depFacet, packageName);
            NonGradleApkProvider.fillRuntimeAndTestDependencies(depModule, module2PackageName);
        }
    }

    private static void checkPackageNames(@NotNull Map<AndroidFacet, String> additionalFacet2PackageName, @NotNull AndroidFacet facet, @NotNull String mainPackageName) throws ApkProvisionException {
        if (additionalFacet2PackageName == null) {
            NonGradleApkProvider.$$$reportNull$$$0(9);
        }
        if (facet == null) {
            NonGradleApkProvider.$$$reportNull$$$0(10);
        }
        if (mainPackageName == null) {
            NonGradleApkProvider.$$$reportNull$$$0(11);
        }
        HashMap packageName2ModuleNames = new HashMap();
        packageName2ModuleNames.put(mainPackageName, new ArrayList<String>(Arrays.asList(facet.getModule().getName())));
        for (Map.Entry<AndroidFacet, String> entry : additionalFacet2PackageName.entrySet()) {
            String moduleName = entry.getKey().getModule().getName();
            String packageName = entry.getValue();
            ArrayList<String> list = (ArrayList<String>)packageName2ModuleNames.get(packageName);
            if (list == null) {
                list = new ArrayList<String>();
                packageName2ModuleNames.put(packageName, list);
            }
            list.add(moduleName);
        }
        StringBuilder messageBuilder = new StringBuilder("Applications have the same package name ");
        boolean fail = false;
        for (Map.Entry entry : packageName2ModuleNames.entrySet()) {
            String packageName = (String)entry.getKey();
            List moduleNames = (List)entry.getValue();
            if (moduleNames.size() <= 1) continue;
            fail = true;
            messageBuilder.append(packageName).append(":\n    ");
            Iterator it = moduleNames.iterator();
            while (it.hasNext()) {
                String moduleName = (String)it.next();
                messageBuilder.append(moduleName);
                if (!it.hasNext()) continue;
                messageBuilder.append(", ");
            }
            messageBuilder.append("\n");
        }
        if (fail) {
            throw new ApkProvisionException(messageBuilder.toString());
        }
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            NonGradleApkProvider.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/NonGradleApkProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module2PackageName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFacet2PackageName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/NonGradleApkProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getApks";
                break;
            }
            case 3: 
            case 12: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addApk";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillRuntimeAndTestDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

