/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class KeystoreUtils {
    @NotNull
    public static File getDebugKeystore(@NotNull AndroidFacet facet) throws Exception {
        File gradleDebugKeystore;
        if (facet == null) {
            KeystoreUtils.$$$reportNull$$$0(0);
        }
        if ((gradleDebugKeystore = KeystoreUtils.getGradleDebugKeystore(facet)) != null) {
            File file = gradleDebugKeystore;
            if (file == null) {
                KeystoreUtils.$$$reportNull$$$0(1);
            }
            return file;
        }
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
        if (state != null && !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH)) {
            File file = new File(state.CUSTOM_DEBUG_KEYSTORE_PATH);
            if (file == null) {
                KeystoreUtils.$$$reportNull$$$0(2);
            }
            return file;
        }
        File file = KeystoreUtils.getOrCreateDefaultDebugKeystore();
        if (file == null) {
            KeystoreUtils.$$$reportNull$$$0(3);
        }
        return file;
    }

    public static File getOrCreateDefaultDebugKeystore() throws Exception {
        try {
            File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
            if (!debugLocation.exists()) {
                File keystoreDirectory = new File(AndroidLocation.getFolder());
                if (!keystoreDirectory.canWrite()) {
                    throw new AndroidLocation.AndroidLocationException("Could not create debug keystore because \"" + keystoreDirectory + "\" is not writable");
                }
                StdLogger logger = new StdLogger(StdLogger.Level.ERROR);
                KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)logger);
            }
            if (!debugLocation.exists()) {
                throw new AndroidLocation.AndroidLocationException("Could not create debug keystore");
            }
            return debugLocation;
        }
        catch (AndroidLocation.AndroidLocationException exception) {
            throw new Exception("Failed to get debug keystore path", exception);
        }
    }

    @Nullable
    private static File getGradleDebugKeystore(@NotNull AndroidFacet facet) {
        GradleSettingsFile gradleSettingsFile;
        if (facet == null) {
            KeystoreUtils.$$$reportNull$$$0(4);
        }
        if ((gradleSettingsFile = GradleSettingsFile.get(facet.getModule().getProject())) == null) {
            return null;
        }
        String modulePath = GradleSettingsFile.getModuleGradlePath(facet.getModule());
        if (modulePath == null) {
            return null;
        }
        final GradleBuildFile moduleBuildFile = gradleSettingsFile.getModuleBuildFile(modulePath);
        if (moduleBuildFile == null) {
            return null;
        }
        Iterable signingConfigs = (Iterable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Iterable<NamedObject>>(){

            public Iterable<NamedObject> compute() {
                return (Iterable)moduleBuildFile.getValue(BuildFileKey.SIGNING_CONFIGS);
            }
        });
        if (signingConfigs == null) {
            return null;
        }
        for (NamedObject namedObject : signingConfigs) {
            File debugKey;
            if (!"debug".equals(namedObject.getName()) || (debugKey = (File)namedObject.getValue(BuildFileKey.STORE_FILE)) == null) continue;
            return new File(ModuleUtilCore.getModuleDirPath((Module)facet.getModule()), debugKey.getPath());
        }
        return null;
    }

    @NotNull
    public static String sha1(@NotNull File keyStoreFile) throws Exception {
        if (keyStoreFile == null) {
            KeystoreUtils.$$$reportNull$$$0(5);
        }
        String string = KeystoreUtils.sha1(keyStoreFile, null, null);
        if (string == null) {
            KeystoreUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2, @Nullable String keyStorePassword) throws Exception {
        String string;
        if (keyStoreFile == null) {
            KeystoreUtils.$$$reportNull$$$0(7);
        }
        Certificate signingCert = KeystoreUtils.getCertificate(keyStoreFile, keyAlias2, keyStorePassword);
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            string = BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
        }
        catch (Exception e) {
            throw new Exception("Could not compute SHA1 hash from certificate", e);
        }
        if (string == null) {
            KeystoreUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static Certificate getCertificate(@NotNull File keyStoreFile, @Nullable String certificateAlias, @Nullable String keyStorePassword) throws Exception {
        Certificate certificate;
        if (keyStoreFile == null) {
            KeystoreUtils.$$$reportNull$$$0(9);
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            if (keyStorePassword == null) {
                keyStorePassword = "android";
            }
            keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());
            if (certificateAlias == null) {
                certificateAlias = keyStore.aliases().nextElement();
            }
            certificate = keyStore.getCertificate(certificateAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new Exception("Could not extract certificate from file.", exception);
        }
        if (certificate == null) {
            KeystoreUtils.$$$reportNull$$$0(10);
        }
        return certificate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/KeystoreUtils";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStoreFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/KeystoreUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugKeystore";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sha1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCertificate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDebugKeystore";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGradleDebugKeystore";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sha1";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCertificate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

