/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.adtui.util.GraphicsUtil;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.MaterialColorUtils;
import com.android.tools.idea.ui.resourcechooser.ColorListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LinearGradientPaint;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorPicker
extends JPanel
implements ColorListener,
DocumentListener {
    private static final String HSB_PROPERTY = "color.picker.is.hsb";
    private Color myColor;
    private ColorPreviewComponent myPreviewComponent;
    private JLabel myPreviewColorName;
    private ClickableLabel myColorSuggestionPreview;
    private Color myClosestColor;
    private final ColorSelectionPanel myColorSelectionPanel;
    private final JTextField myAlpha;
    private final JTextField myRed;
    private final JTextField myGreen;
    private final JTextField myBlue;
    private final JTextField myHex;
    private final Alarm myUpdateQueue;
    private final ColorPickerListener[] myExternalListeners;
    private RecommendedColorsComponent myRecommendedColorsComponent;
    private final ColorPipette myPicker;
    private final JLabel myA;
    private final JLabel myR;
    private final JLabel myG;
    private final JLabel myB;
    private final JLabel myR_after;
    private final JLabel myG_after;
    private final JLabel myB_after;
    private final JLabel myHexLabel;
    private float[] myHSB;
    private final JComboBox myFormat;

    public ColorPicker(@NotNull Disposable parent, @Nullable Color color, boolean enableOpacity, ColorPickerListener ... listeners) {
        if (parent == null) {
            ColorPicker.$$$reportNull$$$0(0);
        }
        this(parent, color, enableOpacity, listeners, false);
    }

    private ColorPicker(Disposable parent, @Nullable Color color, boolean enableOpacity, ColorPickerListener[] listeners, boolean opacityInPercent) {
        this.myA = new JLabel("A:");
        this.myR = new JLabel("R:");
        this.myG = new JLabel("G:");
        this.myB = new JLabel("B:");
        this.myR_after = new JLabel("");
        this.myG_after = new JLabel("");
        this.myB_after = new JLabel("");
        this.myHexLabel = new JLabel("#");
        this.myFormat = new JComboBox(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                UIManager.LookAndFeelInfo info = LafManager.getInstance().getCurrentLookAndFeel();
                if (info != null && info.getName().contains("Windows")) {
                    size.width += 10;
                }
                return size;
            }
        };
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
        this.myAlpha = this.createColorField(false);
        this.myRed = this.createColorField(false);
        this.myGreen = this.createColorField(false);
        this.myBlue = this.createColorField(false);
        this.myHex = this.createColorField(true);
        this.myA.setLabelFor(this.myAlpha);
        this.myR.setLabelFor(this.myRed);
        this.myG.setLabelFor(this.myGreen);
        this.myB.setLabelFor(this.myBlue);
        this.myHexLabel.setLabelFor(this.myHex);
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"RGB", "HSB"});
        if (enableOpacity) {
            model.addElement("ARGB");
        }
        this.myFormat.setModel(model);
        this.myColorSelectionPanel = new ColorSelectionPanel(this, enableOpacity, opacityInPercent);
        this.myExternalListeners = listeners;
        this.myFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue(ColorPicker.HSB_PROPERTY, !ColorPicker.this.isRGBMode());
                ColorPicker.this.myColorSelectionPanel.myOpacityComponent.setVisible(ColorPicker.this.isARGBMode());
                ColorPicker.this.myA.setVisible(ColorPicker.this.isARGBMode());
                ColorPicker.this.myAlpha.setVisible(ColorPicker.this.isARGBMode());
                ColorPicker.this.myR.setText(ColorPicker.this.isRGBMode() ? "R:" : "H:");
                ColorPicker.this.myG.setText(ColorPicker.this.isRGBMode() ? "G:" : "S:");
                ColorPicker.this.myR_after.setText(ColorPicker.this.isRGBMode() ? "" : "\u00b0");
                ColorPicker.this.myR_after.setVisible(!ColorPicker.this.isRGBMode());
                ColorPicker.this.myG.setText(ColorPicker.this.isRGBMode() ? "G:" : "S:");
                ColorPicker.this.myG_after.setText(ColorPicker.this.isRGBMode() ? "" : "%");
                ColorPicker.this.myG_after.setVisible(!ColorPicker.this.isRGBMode());
                ColorPicker.this.myB_after.setText(ColorPicker.this.isRGBMode() ? "" : "%");
                ColorPicker.this.myB_after.setVisible(!ColorPicker.this.isRGBMode());
                if (!ColorPicker.this.isARGBMode() && ColorPicker.this.myColor.getAlpha() != 255) {
                    ColorPicker.this.updatePreview(ColorUtil.toAlpha((Color)ColorPicker.this.myColor, (int)255), false);
                }
                ColorPicker.this.applyColor(ColorPicker.this.myColor);
                ColorPicker.this.applyColorToHEX(ColorPicker.this.myColor);
            }
        });
        this.myPicker = new ColorPipette(this, this.getColor());
        this.myPicker.setListener(new ColorListener(){

            @Override
            public void colorChanged(Color color, Object source) {
                ColorPicker.this.setColor(color, source);
            }
        });
        try {
            this.myRecommendedColorsComponent = new RecommendedColorsComponent(new ColorListener(){

                @Override
                public void colorChanged(Color color, Object source) {
                    ColorPicker.this.setColor(color, source);
                }
            });
            JComponent topPanel = this.buildTopPanel(true);
            this.add(topPanel);
            this.add(this.myColorSelectionPanel);
            this.add(this.myRecommendedColorsComponent);
        }
        catch (ParseException topPanel) {
            // empty catch block
        }
        this.setColor(color == null ? Color.WHITE : color, this);
        this.setSize((Dimension)JBUI.size((int)300, (int)350));
        boolean hsb = PropertiesComponent.getInstance().getBoolean(HSB_PROPERTY);
        if (hsb) {
            this.myFormat.setSelectedIndex(1);
        }
    }

    private boolean isRGBMode() {
        return this.myFormat.getSelectedIndex() == 0 || this.isARGBMode();
    }

    private boolean isARGBMode() {
        return this.myFormat.getSelectedIndex() == 2;
    }

    public void pickRGB() {
        this.myFormat.setSelectedIndex(0);
    }

    public void pickHSB() {
        this.myFormat.setSelectedIndex(1);
    }

    public void pickARGB() {
        this.myFormat.setSelectedIndex(2);
    }

    private int getLargestDigitWidth(boolean hex) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int largestWidth = metrics.charWidth('0');
        int maxDigit = hex ? 16 : 10;
        for (int i = 1; i < maxDigit; ++i) {
            largestWidth = Math.max(largestWidth, metrics.charWidth(Character.toUpperCase(Character.forDigit(i, maxDigit))));
        }
        return largestWidth;
    }

    private JTextField createColorField(final boolean hex) {
        NumberDocument doc = new NumberDocument(hex);
        final JTextField field = new JTextField(doc, "", hex ? 8 : 3){

            @Override
            protected int getColumnWidth() {
                return ColorPicker.this.getLargestDigitWidth(hex);
            }
        };
        doc.setSource(field);
        field.getDocument().addDocumentListener(this);
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                field.selectAll();
            }
        });
        return field;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHex;
    }

    public void setColor(@NotNull Color color) {
        if (color == null) {
            ColorPicker.$$$reportNull$$$0(1);
        }
        this.setColor(color, null);
    }

    private void setColor(Color color, Object src) {
        this.colorChanged(color, src);
        this.myColorSelectionPanel.setColor(color, src);
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackground, boolean displayWarning) {
        if (contrastColorsWithDescription == null) {
            ColorPicker.$$$reportNull$$$0(2);
        }
        this.myPreviewComponent.setContrastParameters(contrastColorsWithDescription, isBackground, displayWarning);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    private void update(final JTextField src) {
        this.myUpdateQueue.cancelAllRequests();
        this.myUpdateQueue.addRequest(new Runnable(){

            @Override
            public void run() {
                ColorPicker.this.validateAndUpdatePreview(src);
            }
        }, 300);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void validateAndUpdatePreview(JTextField src) {
        Color color;
        if (this.myHex.hasFocus()) {
            if (this.isARGBMode()) {
                String text = this.myHex.getText();
                int rgbIndex = Math.max(0, text.length() - 6);
                String rgb = text.substring(rgbIndex);
                String alphaText = text.substring(0, rgbIndex);
                int alpha = alphaText.isEmpty() ? 255 : Integer.parseInt(alphaText, 16);
                Color c = ColorUtil.fromHex((String)rgb, null);
                color = c != null ? ColorUtil.toAlpha((Color)c, (int)alpha) : null;
            } else {
                Color c = ColorUtil.fromHex((String)this.myHex.getText(), null);
                color = c != null ? ColorUtil.toAlpha((Color)c, (int)this.myColorSelectionPanel.mySaturationBrightnessComponent.myOpacity) : null;
            }
        } else {
            color = this.gatherRGB(this.myRed.hasFocus() || this.myGreen.hasFocus() || this.myBlue.hasFocus());
        }
        if (color != null) {
            this.myColorSelectionPanel.myOpacityComponent.setColor(color);
            if (this.myAlpha.hasFocus() || this.isARGBMode() && this.myHex.hasFocus()) {
                this.myColorSelectionPanel.myOpacityComponent.setValue(color.getAlpha());
            }
            this.myColorSelectionPanel.myOpacityComponent.repaint();
            this.updatePreview(color, src == this.myHex);
        }
    }

    private void updatePreview(Color color, boolean fromHex) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.myPreviewComponent.setColor(color);
            this.myColorSelectionPanel.setColor(color, fromHex ? this.myHex : null);
            this.setNameTag(color);
            if (fromHex) {
                this.applyColor(color);
            } else {
                this.applyColorToHEX(color);
            }
            this.fireColorChanged(color);
        }
    }

    @Override
    public void colorChanged(Color color, Object source) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.applyColor(color);
            if (source != this.myHex) {
                this.applyColorToHEX(color);
            }
            this.myPreviewComponent.setColor(color);
            this.myColorSelectionPanel.setOpacityComponentColor(color);
            this.setNameTag(color);
            this.fireColorChanged(color);
        }
    }

    private void setNameTag(@NotNull Color color) {
        String name;
        if (color == null) {
            ColorPicker.$$$reportNull$$$0(3);
        }
        if ((name = MaterialColorUtils.getMaterialName(color)) == null) {
            name = "Custom color";
            this.myClosestColor = MaterialColorUtils.getClosestMaterialColor(color);
            this.myColorSuggestionPreview.setVisible(true);
            String toolTip = "<html>Change to <b>" + MaterialColorUtils.getMaterialName(this.myClosestColor);
            this.myColorSuggestionPreview.setToolTipText(toolTip);
            this.myColorSuggestionPreview.setIcon((Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(12, this.myClosestColor)));
        } else {
            this.myColorSuggestionPreview.setVisible(false);
        }
        this.myPreviewColorName.setText(name);
    }

    private void fireColorChanged(Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener listener : this.myExternalListeners) {
            listener.colorChanged(color);
        }
    }

    private void fireClosed(@Nullable Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener listener : this.myExternalListeners) {
            listener.closed(color);
        }
    }

    public void setRecommendedColors(@NotNull List<Color> colorList) {
        if (colorList == null) {
            ColorPicker.$$$reportNull$$$0(4);
        }
        this.myRecommendedColorsComponent.setColors(colorList);
    }

    @Nullable
    private Color gatherRGB(boolean fromTextFields) {
        try {
            int r = Integer.parseInt(this.myRed.getText());
            int g = Integer.parseInt(this.myGreen.getText());
            int b = Integer.parseInt(this.myBlue.getText());
            int a = Integer.parseInt(this.myAlpha.getText());
            if (this.isARGBMode()) {
                return new Color(r, g, b, a);
            }
            if (this.isRGBMode()) {
                return new Color(r, g, b);
            }
            if (fromTextFields) {
                return Color.getHSBColor((float)r / 360.0f, (float)g / 100.0f, (float)b / 100.0f);
            }
            return Color.getHSBColor(this.myHSB[0], this.myHSB[1], this.myHSB[2]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void applyColorToHEX(Color c) {
        if (this.isARGBMode()) {
            this.myHex.setText(String.format("%08X", c.getRGB()));
        } else {
            this.myHex.setText(String.format("%06X", 0xFFFFFF & c.getRGB()));
        }
    }

    private void applyColorToRGB(Color color) {
        this.myAlpha.setText(String.valueOf(color.getAlpha()));
        this.myRed.setText(String.valueOf(color.getRed()));
        this.myGreen.setText(String.valueOf(color.getGreen()));
        this.myBlue.setText(String.valueOf(color.getBlue()));
    }

    private void applyColorToHSB(Color c) {
        this.myAlpha.setText(String.valueOf(c.getAlpha()));
        this.myHSB = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.myRed.setText(String.valueOf(Math.round(360.0f * this.myHSB[0])));
        this.myGreen.setText(String.valueOf(Math.round(100.0f * this.myHSB[1])));
        this.myBlue.setText(String.valueOf(Math.round(100.0f * this.myHSB[2])));
    }

    private void applyColor(Color color) {
        if (this.isRGBMode()) {
            this.applyColorToRGB(color);
        } else {
            this.applyColorToHSB(color);
        }
    }

    @Nullable
    public static Color showDialog(Component parent, String caption, @Nullable Color preselectedColor, boolean enableOpacity, @Nullable ColorPickerListener[] listeners, boolean opacityInPercent) {
        ColorPickerDialog dialog = new ColorPickerDialog(parent, caption, preselectedColor, enableOpacity, listeners, opacityInPercent);
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return dialog.getColor();
        }
        return null;
    }

    @NotNull
    private JComponent buildTopPanel(boolean enablePipette) throws ParseException {
        Box result = new Box(3);
        Box namePanel = new Box(2);
        this.myPreviewColorName = new JLabel("");
        Font f = this.myPreviewColorName.getFont();
        this.myPreviewColorName.setFont(f.deriveFont(f.getStyle() | 1));
        this.myColorSuggestionPreview = new ClickableLabel("CLOSEST MATERIAL COLOR");
        this.myColorSuggestionPreview.setFont(f.deriveFont(JBUI.scale((float)8.0f)));
        this.myColorSuggestionPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPicker.this.myColorSelectionPanel.setColor(ColorPicker.this.myClosestColor, this);
            }
        });
        namePanel.add(this.myPreviewColorName);
        namePanel.add(Box.createRigidArea(new Dimension(JBUI.scale((int)5), 0)));
        namePanel.add((Component)this.myColorSuggestionPreview);
        namePanel.add(Box.createHorizontalGlue());
        result.add(namePanel);
        Box previewPanel = new Box(2);
        if (enablePipette && ColorPipette.isAvailable()) {
            JButton pipette = new JButton();
            pipette.setUI(new BasicButtonUI());
            pipette.setRolloverEnabled(true);
            pipette.setIcon(AllIcons.Ide.Pipette);
            pipette.setBorder((Border)JBUI.Borders.empty());
            pipette.setRolloverIcon(AllIcons.Ide.Pipette_rollover);
            pipette.setFocusable(false);
            pipette.addActionListener(e -> {
                this.myPicker.myOldColor = this.getColor();
                this.myPicker.pick();
            });
            previewPanel.add(pipette);
        }
        this.myPreviewComponent = new ColorPreviewComponent();
        previewPanel.add(this.myPreviewComponent);
        result.add(previewPanel);
        Box rgbPanel = new Box(2);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            this.myR_after.setPreferredSize((Dimension)JBUI.size((int)14, (int)-1));
            this.myG_after.setPreferredSize((Dimension)JBUI.size((int)14, (int)-1));
            this.myB_after.setPreferredSize((Dimension)JBUI.size((int)14, (int)-1));
        }
        rgbPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        rgbPanel.add(this.myA);
        rgbPanel.add(this.myAlpha);
        this.myA.setVisible(this.isARGBMode());
        this.myAlpha.setVisible(this.isARGBMode());
        rgbPanel.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        rgbPanel.add(this.myR);
        rgbPanel.add(this.myRed);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myR_after);
        }
        this.myR_after.setVisible(false);
        rgbPanel.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        rgbPanel.add(this.myG);
        rgbPanel.add(this.myGreen);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myG_after);
        }
        this.myG_after.setVisible(false);
        rgbPanel.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        rgbPanel.add(this.myB);
        rgbPanel.add(this.myBlue);
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            rgbPanel.add(this.myB_after);
        }
        this.myB_after.setVisible(false);
        rgbPanel.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        rgbPanel.add(this.myFormat);
        Box valuesPanel = new Box(2);
        rgbPanel.setMaximumSize((Dimension)JBUI.size((int)-1, (int)35));
        valuesPanel.add(rgbPanel);
        Box hexPanel = new Box(0);
        hexPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        hexPanel.add(this.myHexLabel);
        hexPanel.add(this.myHex);
        this.myHex.setMaximumSize((Dimension)JBUI.size((int)120, (int)25));
        valuesPanel.add(Box.createHorizontalGlue());
        valuesPanel.add(hexPanel);
        result.add(valuesPanel);
        Box box = result;
        if (box == null) {
            ColorPicker.$$$reportNull$$$0(5);
        }
        return box;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contrastColorsWithDescription";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/ColorPicker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ColorPicker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTopPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setColor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setContrastParameters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setNameTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRecommendedColors";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HueSlideComponent
    extends SlideComponent {
        private final Color[] myColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.CYAN, Color.BLUE, Color.MAGENTA, Color.RED};
        private final float[] myPoints = new float[this.myColors.length];
        private float myHue;

        HueSlideComponent(String title) {
            super(title);
            int i = 0;
            for (Color color : this.myColors) {
                this.myPoints[i++] = color.equals(Color.RED) && i != 0 ? 1.0f : Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0];
            }
        }

        @Override
        protected int pointerValueToValue(int pointerValue) {
            float proportion = (float)(this.getWidth() - 2 * MARGIN) / 360.0f;
            return (int)((float)(pointerValue -= MARGIN) / proportion);
        }

        @Override
        protected int valueToPointerValue(int value) {
            float proportion = (float)(this.getWidth() - 2 * MARGIN) / 360.0f;
            return MARGIN + (int)((float)value * proportion);
        }

        public void setHueValue(float hue) {
            if ((double)Math.abs(hue - this.myHue) > 0.01) {
                this.myHue = hue;
                super.setValue(Math.round(360.0f * hue));
            }
        }

        @Override
        public void setValue(int value) {
            super.setValue(value);
            this.setHueValue((float)value / 360.0f);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new LinearGradientPaint(new Point2D.Double(0.0, 0.0), new Point2D.Double(this.getWidth() - 2 * MARGIN, 0.0), this.myPoints, this.myColors));
            g.fillRect(MARGIN, JBUI.scale((int)7), this.getWidth() - 2 * MARGIN, JBUI.scale((int)12));
            HueSlideComponent.drawKnob(g2d, this.valueToPointerValue(Math.round(this.myHue * 360.0f)), JBUI.scale((int)7));
        }
    }

    public static class SlideComponent
    extends JComponent {
        protected static final int MARGIN = JBUI.scale((int)5);
        private static final Color SHADOW_COLOR = new Color(0, 0, 0, 70);
        private static final Color HEAD_COLOR = new Color(153, 51, 0);
        protected int myPointerValue = 0;
        private int myValue = 0;
        private final String myTitle;
        private final List<Consumer<Integer>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private LightweightHint myTooltipHint;
        private final JLabel myLabel = new JLabel();
        private Unit myUnit = Unit.LEVEL;
        private Color myColor;

        void setUnits(Unit unit) {
            this.myUnit = unit;
        }

        SlideComponent(String title) {
            this.myTitle = title;
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.processMouse(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.processMouse(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.updateBalloonText();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.updateBalloonText();
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateBalloonText();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (myTooltipHint != null) {
                        myTooltipHint.hide();
                        myTooltipHint = null;
                    }
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    int amount = e.getScrollType() == 0 ? e.getUnitsToScroll() * e.getScrollAmount() : (e.getWheelRotation() < 0 ? -e.getScrollAmount() : e.getScrollAmount());
                    int pointerValue = myPointerValue + amount;
                    pointerValue = pointerValue < MARGIN ? MARGIN : pointerValue;
                    int size = this.getWidth();
                    myPointerValue = pointerValue = pointerValue > size - MARGIN ? size - MARGIN : pointerValue;
                    myValue = this.pointerValueToValue(myPointerValue);
                    this.repaint();
                    this.fireValueChanged();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.setValue(this.getValue());
                    this.fireValueChanged();
                    this.repaint();
                }
            });
        }

        public void setColor(Color color) {
            this.myColor = color;
        }

        public void setHue(float hue) {
            float[] hsv = Color.RGBtoHSB(this.myColor.getRed(), this.myColor.getGreen(), this.myColor.getBlue(), null);
            if ((double)Math.abs(hue - hsv[0]) > 0.01) {
                this.setColor(Color.getHSBColor(hue, hsv[1], hsv[2]));
            }
        }

        private void updateBalloonText() {
            Point point = new Point(this.myPointerValue, 0);
            this.myLabel.setText(this.myTitle + ": " + Unit.formatValue(this.myValue, this.myUnit));
            if (this.myTooltipHint == null) {
                this.myTooltipHint = new LightweightHint((JComponent)this.myLabel);
                this.myTooltipHint.setCancelOnClickOutside(false);
                this.myTooltipHint.setCancelOnOtherWindowOpen(false);
                HintHint hint = new HintHint((Component)this, point).setPreferredPosition(Balloon.Position.above).setBorderColor(Color.BLACK).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
                Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.myTooltipHint.show((JComponent)this, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hint);
            } else {
                this.myTooltipHint.setLocation(new RelativePoint((Component)this, point));
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            this.updateBalloonText();
        }

        private void processMouse(MouseEvent e) {
            int pointerValue = e.getX();
            pointerValue = pointerValue < MARGIN ? MARGIN : pointerValue;
            int size = this.getWidth();
            pointerValue = pointerValue > size - MARGIN ? size - MARGIN : pointerValue;
            this.setValue(this.pointerValueToValue(pointerValue));
            this.repaint();
            this.fireValueChanged();
        }

        public void addListener(Consumer<Integer> listener) {
            this.myListeners.add(listener);
        }

        private void fireValueChanged() {
            for (Consumer<Integer> listener : this.myListeners) {
                listener.consume((Object)this.myValue);
            }
        }

        public void setValue(int value) {
            this.myPointerValue = this.valueToPointerValue(value);
            this.myValue = value;
        }

        public int getValue() {
            return this.myValue;
        }

        protected int pointerValueToValue(int pointerValue) {
            float proportion = (float)(this.getWidth() - 2 * MARGIN) / 255.0f;
            return (int)((float)(pointerValue -= MARGIN) / proportion);
        }

        protected int valueToPointerValue(int value) {
            float proportion = (float)(this.getWidth() - 2 * MARGIN) / 255.0f;
            return MARGIN + (int)((float)value * proportion);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)100, (int)22);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)50, (int)22);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, JBUI.scale((int)this.getPreferredSize().height));
        }

        @Override
        public final void setToolTipText(String text) {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Color color = new Color(this.myColor.getRGB());
            Color transparent = ColorUtil.toAlpha((Color)Color.WHITE, (int)0);
            Rectangle clip = new Rectangle(MARGIN, JBUI.scale((int)7), this.getWidth() - 2 * MARGIN, JBUI.scale((int)12));
            GraphicsUtil.paintCheckeredBackground((Graphics)g2d, (Shape)clip);
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)transparent, (float)this.getWidth(), (float)0.0f, (Color)color));
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            SlideComponent.drawKnob(g2d, this.myPointerValue, JBUI.scale((int)7));
        }

        protected static void drawKnob(Graphics2D g2d, int x, int y) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Polygon polygon = new Polygon();
            polygon.addPoint((x -= JBUI.scale((int)6)) + JBUI.scale((int)1), y - JBUI.scale((int)5));
            polygon.addPoint(x + JBUI.scale((int)13), y - JBUI.scale((int)5));
            polygon.addPoint(x + JBUI.scale((int)7), y + JBUI.scale((int)7));
            g2d.setColor(SHADOW_COLOR);
            g2d.fill(polygon);
            polygon.reset();
            polygon.addPoint(x, y - JBUI.scale((int)6));
            polygon.addPoint(x + JBUI.scale((int)12), y - JBUI.scale((int)6));
            polygon.addPoint(x + JBUI.scale((int)6), y + JBUI.scale((int)6));
            g2d.setColor(HEAD_COLOR);
            g2d.fill(polygon);
        }

        static enum Unit {
            PERCENT,
            LEVEL;

            private static final float PERCENT_MAX_VALUE = 100.0f;
            private static final float LEVEL_MAX_VALUE = 255.0f;

            private static float getMaxValue(Unit unit) {
                return LEVEL.equals((Object)unit) ? 255.0f : 100.0f;
            }

            private static String formatValue(int value, Unit unit) {
                return String.format("%d%s", (int)(Unit.getMaxValue(unit) / 255.0f * (float)value), unit.equals((Object)PERCENT) ? "%" : "");
            }
        }
    }

    private static class ColorPipette
    implements ImageObserver {
        private Dialog myPickerFrame;
        private final JComponent myParent;
        private Color myOldColor;
        private Timer myTimer;
        private Point myPoint = new Point();
        private Point myPickOffset;
        private Robot myRobot = null;
        private Color myPreviousColor;
        private Point myPreviousLocation;
        private Rectangle myCaptureRect;
        private Graphics2D myGraphics;
        private BufferedImage myImage;
        private Point myHotspot;
        private BufferedImage myMagnifierImage;
        private Color myTransparentColor = new Color(0, true);
        private Rectangle myZoomRect;
        private ColorListener myColorListener;
        private BufferedImage myMaskImage;
        private Alarm myColorListenersNotifier = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

        private ColorPipette(JComponent parent, Color oldColor) {
            this.myParent = parent;
            this.myOldColor = oldColor;
            try {
                this.myRobot = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }

        public void setListener(ColorListener colorListener) {
            this.myColorListener = colorListener;
        }

        public void pick() {
            Dialog picker = this.getPicker();
            picker.setVisible(true);
            this.myTimer.start();
            WindowManager.getInstance().setAlphaModeRatio((Window)picker, SystemInfo.isMac ? 0.95f : 0.99f);
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            return false;
        }

        private Dialog getPicker() {
            if (this.myPickerFrame == null) {
                Window owner = SwingUtilities.getWindowAncestor(this.myParent);
                this.myPickerFrame = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
                this.myPickerFrame.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        e.consume();
                        this.pickDone();
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        e.consume();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        this.updatePipette();
                    }
                });
                this.myPickerFrame.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        this.updatePipette();
                    }
                });
                this.myPickerFrame.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        this.cancelPipette();
                    }
                });
                this.myPickerFrame.setSize(50, 50);
                this.myPickerFrame.setUndecorated(true);
                this.myPickerFrame.setAlwaysOnTop(true);
                JRootPane rootPane = ((JDialog)this.myPickerFrame).getRootPane();
                rootPane.putClientProperty("Window.shadow", Boolean.FALSE);
                this.myPickOffset = new Point(0, 0);
                this.myCaptureRect = new Rectangle(-4, -4, 8, 8);
                this.myHotspot = new Point(14, 16);
                this.myZoomRect = new Rectangle(0, 0, 32, 32);
                this.myMaskImage = UIUtil.createImage((int)32, (int)32, (int)2);
                Graphics2D maskG = this.myMaskImage.createGraphics();
                maskG.setColor(Color.BLUE);
                maskG.fillRect(0, 0, 32, 32);
                maskG.setColor(Color.RED);
                maskG.setComposite(AlphaComposite.SrcOut);
                maskG.fillRect(0, 0, 32, 32);
                maskG.dispose();
                this.myMagnifierImage = UIUtil.createImage((int)32, (int)32, (int)2);
                Graphics2D graphics = this.myMagnifierImage.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics.setColor(Color.BLACK);
                AllIcons.Ide.Pipette.paintIcon(null, graphics, 14, 0);
                graphics.dispose();
                this.myImage = this.myParent.getGraphicsConfiguration().createCompatibleImage(this.myMagnifierImage.getWidth(), this.myMagnifierImage.getHeight(), 3);
                this.myGraphics = (Graphics2D)this.myImage.getGraphics();
                this.myGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                this.myPickerFrame.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                            case 27: {
                                this.cancelPipette();
                                break;
                            }
                            case 10: {
                                this.pickDone();
                            }
                        }
                    }
                });
                this.myTimer = new Timer(5, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.updatePipette();
                    }
                });
            }
            return this.myPickerFrame;
        }

        private void cancelPipette() {
            this.myTimer.stop();
            this.myPickerFrame.setVisible(false);
            if (this.myColorListener != null && this.myOldColor != null) {
                this.myColorListener.colorChanged(this.myOldColor, this);
            }
        }

        public void pickDone() {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point location = pointerInfo.getLocation();
            Color pixelColor = this.myRobot.getPixelColor(location.x + this.myPickOffset.x, location.y + this.myPickOffset.y);
            this.cancelPipette();
            if (this.myColorListener != null) {
                this.myColorListener.colorChanged(pixelColor, this);
                this.myOldColor = pixelColor;
            }
        }

        private void updatePipette() {
            if (this.myPickerFrame != null && this.myPickerFrame.isShowing()) {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point mouseLoc = pointerInfo.getLocation();
                this.myPickerFrame.setLocation(mouseLoc.x - this.myPickerFrame.getWidth() / 2, mouseLoc.y - this.myPickerFrame.getHeight() / 2);
                this.myPoint.x = mouseLoc.x + this.myPickOffset.x;
                this.myPoint.y = mouseLoc.y + this.myPickOffset.y;
                final Color c = this.myRobot.getPixelColor(this.myPoint.x, this.myPoint.y);
                if (!c.equals(this.myPreviousColor) || !mouseLoc.equals(this.myPreviousLocation)) {
                    this.myPreviousColor = c;
                    this.myPreviousLocation = mouseLoc;
                    this.myCaptureRect.setLocation(mouseLoc.x - 2, mouseLoc.y - 2);
                    this.myCaptureRect.setBounds(mouseLoc.x - 2, mouseLoc.y - 2, 5, 5);
                    BufferedImage capture = this.myRobot.createScreenCapture(this.myCaptureRect);
                    this.myGraphics.setComposite(AlphaComposite.Src);
                    this.myGraphics.setColor(this.myTransparentColor);
                    this.myGraphics.fillRect(0, 0, this.myImage.getWidth(), this.myImage.getHeight());
                    this.myGraphics.drawImage(capture, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.getInstance(8));
                    this.myGraphics.drawImage(this.myMaskImage, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.SrcOver);
                    this.myGraphics.drawImage((Image)this.myMagnifierImage, 0, 0, this);
                    this.myPickerFrame.setCursor(this.myParent.getToolkit().createCustomCursor(this.myImage, this.myHotspot, "ColorPicker"));
                    if (this.myColorListener != null) {
                        this.myColorListenersNotifier.cancelAllRequests();
                        this.myColorListenersNotifier.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                myColorListener.colorChanged(c, this);
                            }
                        }, 300);
                    }
                }
            }
        }

        public static boolean isAvailable() {
            return !SystemInfo.isWayland && WindowManager.getInstance().isAlphaModeSupported();
        }
    }

    public static class SaturationBrightnessImageProducer
    extends MemoryImageSource {
        private int[] myPixels;
        private int myWidth;
        private int myHeight;
        private float[] mySat;
        private float[] myBrightness;
        private float myHue;

        public SaturationBrightnessImageProducer(int w, int h, float hue) {
            super(w, h, null, 0, w);
            this.myPixels = new int[w * h];
            this.myWidth = w;
            this.myHeight = h;
            this.myHue = hue;
            this.generateLookupTables();
            this.newPixels(this.myPixels, ColorModel.getRGBdefault(), 0, w);
            this.setAnimated(true);
            this.generateComponent();
        }

        public int getRadius() {
            return Math.min(this.myWidth, this.myHeight) / 2 - 2;
        }

        private void generateLookupTables() {
            this.mySat = new float[this.myWidth * this.myHeight];
            this.myBrightness = new float[this.myWidth * this.myHeight];
            for (int x = 0; x < this.myWidth; ++x) {
                for (int y = 0; y < this.myHeight; ++y) {
                    int index = x + y * this.myWidth;
                    this.mySat[index] = (float)x / (float)this.myWidth;
                    this.myBrightness[index] = 1.0f - (float)y / (float)this.myHeight;
                }
            }
        }

        public void generateComponent() {
            for (int index = 0; index < this.myPixels.length; ++index) {
                this.myPixels[index] = Color.HSBtoRGB(this.myHue, this.mySat[index], this.myBrightness[index]);
            }
            this.newPixels();
        }
    }

    static class ColorPickerDialog
    extends DialogWrapper {
        private final Color myPreselectedColor;
        private final ColorPickerListener[] myListeners;
        private ColorPicker myColorPicker;
        private final boolean myEnableOpacity;
        private ColorPipette myPicker;
        private final boolean myOpacityInPercent;

        ColorPickerDialog(Component parent, String caption, @Nullable Color preselectedColor, boolean enableOpacity, @Nullable ColorPickerListener[] listeners, boolean opacityInPercent) {
            super(parent, true);
            this.myListeners = listeners;
            this.setTitle(caption);
            this.myPreselectedColor = preselectedColor;
            this.myEnableOpacity = enableOpacity;
            this.myOpacityInPercent = opacityInPercent;
            this.setResizable(false);
            this.setOKButtonText("Choose");
            this.init();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    myPicker.cancelPipette();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    myPicker.pick();
                }
            });
        }

        protected JComponent createCenterPanel() {
            if (this.myColorPicker == null) {
                this.myColorPicker = new ColorPicker(this.myDisposable, this.myPreselectedColor, this.myEnableOpacity, this.myListeners, this.myOpacityInPercent);
                this.myColorPicker.pickARGB();
            }
            return this.myColorPicker;
        }

        public Color getColor() {
            return this.myColorPicker.getColor();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myColorPicker.getPreferredFocusedComponent();
        }

        public void show() {
            super.show();
            this.myColorPicker.fireClosed(this.getExitCode() == 0 ? this.getColor() : null);
        }
    }

    private static class RecommendedColorsComponent
    extends JComponent {
        private static final int SPACE = JBUI.scale((int)3);
        private static final int CELL_SIZE = JBUI.scale((int)40);
        private static final int COLUMN_COUNT = 10;
        private List<Color> myRecommendedColors = new ArrayList<Color>();

        private RecommendedColorsComponent(final ColorListener listener) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Color color = this.getColor(e);
                    if (color != null) {
                        listener.colorChanged(color, this);
                    }
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Color color = this.getColor(event);
            if (color != null) {
                String name = MaterialColorUtils.getMaterialName(color);
                if (name != null) {
                    return name;
                }
                return String.format("R: %d G: %d B: %d", color.getRed(), color.getGreen(), color.getBlue());
            }
            return super.getToolTipText(event);
        }

        @Nullable
        private Color getColor(MouseEvent event) {
            int ndx = this.pointToColorPosition(event.getPoint());
            if (ndx >= 0 && ndx < this.myRecommendedColors.size()) {
                return this.myRecommendedColors.get(ndx);
            }
            return null;
        }

        public void setColors(@NotNull List<Color> colorList) {
            if (colorList == null) {
                RecommendedColorsComponent.$$$reportNull$$$0(0);
            }
            this.myRecommendedColors.clear();
            this.myRecommendedColors.addAll(colorList);
        }

        private int pointToColorPosition(Point p) {
            int x = p.x;
            int y = p.y;
            int leftPadding = this.getLeftPadding();
            int topPadding = this.getTopPadding();
            int col = x - leftPadding >= 0 ? (x - leftPadding) / CELL_SIZE : -1;
            int row = y - topPadding >= 0 ? (y - topPadding) / CELL_SIZE : -1;
            return row >= 0 && col >= 0 && row < this.getRowCount() && col < 10 ? col + row * 10 : -1;
        }

        private int getLeftPadding() {
            return (this.getSize().width - (10 * CELL_SIZE - SPACE)) / 2;
        }

        private int getTopPadding() {
            return (this.getSize().height - (this.getRowCount() * CELL_SIZE - SPACE)) / 2;
        }

        private int getRowCount() {
            return this.myRecommendedColors.isEmpty() ? 0 : (int)Math.ceil((double)this.myRecommendedColors.size() / new Double(10.0));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Insets i = this.getInsets();
            return new Dimension(10 * CELL_SIZE - SPACE + i.left + i.right, this.getRowCount() * CELL_SIZE - SPACE + i.top + i.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, -1);
        }

        @Override
        protected void paintComponent(Graphics g) {
            int leftPadding = this.getLeftPadding();
            int topPadding = this.getTopPadding();
            for (int r = 0; r < this.myRecommendedColors.size(); ++r) {
                int row = r / 10;
                int col = r % 10;
                Color color = this.myRecommendedColors.get(r);
                g.setColor(color);
                g.fillRect(leftPadding + col * CELL_SIZE, topPadding + row * CELL_SIZE, CELL_SIZE - SPACE, CELL_SIZE - SPACE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorList", "com/android/tools/idea/ui/resourcechooser/ColorPicker$RecommendedColorsComponent", "setColors"));
        }
    }

    public class NumberDocument
    extends PlainDocument {
        private final boolean myHex;
        private JTextField mySrc;

        public NumberDocument(boolean hex) {
            this.myHex = hex;
        }

        void setSource(JTextField field) {
            this.mySrc = field;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            boolean rgb = ColorPicker.this.isRGBMode();
            char[] source = str.toCharArray();
            if (this.mySrc != null) {
                int selected = this.mySrc.getSelectionEnd() - this.mySrc.getSelectionStart();
                int newLen = this.mySrc.getText().length() - selected + str.length();
                if (newLen > (this.myHex ? (ColorPicker.this.isARGBMode() ? 8 : 6) : 3)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (this.myHex ? "0123456789abcdefABCDEF".indexOf(source[i]) >= 0 : Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            String toInsert = StringUtil.toUpperCase((String)new String(result, 0, j));
            String res = new StringBuilder(this.mySrc.getText()).insert(offs, toInsert).toString();
            try {
                if (!this.myHex) {
                    int num = Integer.parseInt(res);
                    if (rgb) {
                        if (num > 255) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    } else if (this.mySrc == ColorPicker.this.myRed && num > 359 || (this.mySrc == ColorPicker.this.myGreen || this.mySrc == ColorPicker.this.myBlue) && num > 100) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.insertString(offs, toInsert, a);
        }
    }

    public static class ColorPreviewComponent
    extends JComponent {
        private static final Icon WARNING_ICON = AllIcons.General.BalloonWarning;
        private static final String TEXT = "Text";
        private static final int PADDING = JBUI.scale((int)18);
        private static final float FONT_SIZE_RATIO = 1.5f;
        private Color myColor;
        private boolean myIsContrastPreview = false;
        private ImmutableSet<Color> myContrastColorSet;
        private boolean myIsBackgroundColor;
        private String myErrorString;
        private ImmutableMap<String, Color> myContrastColorsWithDescription;
        private boolean myDisplayWarning;

        private ColorPreviewComponent() {
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, JBUI.scale((int)32));
        }

        public void setContrastParameters(@NotNull ImmutableMap<String, Color> contrastColorsWithDescription, boolean isBackgroundColor, boolean displayWarning) {
            if (contrastColorsWithDescription == null) {
                ColorPreviewComponent.$$$reportNull$$$0(0);
            }
            this.myIsContrastPreview = true;
            this.myContrastColorsWithDescription = contrastColorsWithDescription;
            this.myContrastColorSet = ImmutableSet.copyOf((Collection)contrastColorsWithDescription.values());
            this.myIsBackgroundColor = isBackgroundColor;
            this.myDisplayWarning = displayWarning;
            this.setErrorString(displayWarning ? ColorUtils.getContrastWarningMessage(contrastColorsWithDescription, this.myColor, isBackgroundColor) : "");
        }

        private void setErrorString(@NotNull String error) {
            if (error == null) {
                ColorPreviewComponent.$$$reportNull$$$0(1);
            }
            this.myErrorString = error;
            this.setToolTipText(this.myErrorString);
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)100, (int)32);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setColor(Color c) {
            this.myColor = c;
            if (this.myIsContrastPreview && this.myDisplayWarning) {
                this.setErrorString(ColorUtils.getContrastWarningMessage(this.myContrastColorsWithDescription, c, this.myIsBackgroundColor));
            }
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            Insets i = this.getInsets();
            Rectangle r = this.getBounds();
            int width = r.width - i.left - i.right;
            int height = r.height - i.top - i.bottom;
            com.intellij.util.ui.GraphicsUtil.setupAntialiasing((Graphics)g);
            Rectangle clipRectangle = new Rectangle(i.left, i.top, width, height);
            GraphicsUtil.paintCheckeredBackground((Graphics)g, (Shape)clipRectangle);
            if (!this.myIsContrastPreview) {
                g.setColor(this.myColor);
                g.fillRect(clipRectangle.x, clipRectangle.y, clipRectangle.width, clipRectangle.height);
                return;
            }
            int colorCellWidth = width / this.myContrastColorSet.size() + 1;
            Rectangle drawingRectangle = new Rectangle(clipRectangle.x, clipRectangle.y, colorCellWidth, clipRectangle.height);
            Font defaultFont = UIUtil.getLabelFont();
            Font textFont = defaultFont.deriveFont((float)defaultFont.getSize() * 1.5f);
            for (Color color : this.myContrastColorSet) {
                Color textColor = this.myIsBackgroundColor ? color : this.myColor;
                Color backgroundColor = this.myIsBackgroundColor ? this.myColor : color;
                g.setColor(backgroundColor);
                g.fillRect(drawingRectangle.x, drawingRectangle.y, drawingRectangle.width, drawingRectangle.height);
                g.setColor(textColor);
                g.setFont(textFont);
                GraphicsUtil.drawCenteredString((Graphics2D)g, (Rectangle)drawingRectangle, (String)TEXT);
                drawingRectangle.x += colorCellWidth;
            }
            if (!this.myErrorString.isEmpty()) {
                WARNING_ICON.paintIcon(this, g, width - PADDING, height - PADDING);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contrastColorsWithDescription";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/ColorPicker$ColorPreviewComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setContrastParameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class SaturationBrightnessComponent
    extends JComponent {
        private static final int BORDER_SIZE = JBUI.scale((int)5);
        private float myBrightness = 1.0f;
        private float myHue = 1.0f;
        private float mySaturation = 0.0f;
        private Image myImage;
        private Rectangle myComponent;
        private Color myColor;
        private final List<ColorListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOpacity;

        protected SaturationBrightnessComponent() {
            this.setOpaque(true);
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Dimension size = this.getSize();
                    int x = Math.max(Math.min(e.getX(), size.width - BORDER_SIZE), BORDER_SIZE) - BORDER_SIZE;
                    int y = Math.max(Math.min(e.getY(), size.height - BORDER_SIZE), BORDER_SIZE) - BORDER_SIZE;
                    float saturation = (float)x / (float)(size.width - 2 * BORDER_SIZE);
                    float brightness = 1.0f - (float)y / (float)(size.height - 2 * BORDER_SIZE);
                    this.setHSBValue(myHue, saturation, brightness, myOpacity);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Dimension size = this.getSize();
                    int x = Math.max(Math.min(e.getX(), size.width - BORDER_SIZE), BORDER_SIZE) - BORDER_SIZE;
                    int y = Math.max(Math.min(e.getY(), size.height - BORDER_SIZE), BORDER_SIZE) - BORDER_SIZE;
                    float saturation = (float)x / (float)(size.width - 2 * BORDER_SIZE);
                    float brightness = 1.0f - (float)y / (float)(size.height - 2 * BORDER_SIZE);
                    this.setHSBValue(myHue, saturation, brightness, myOpacity);
                }
            });
        }

        private void setHSBValue(float h, float s, float b, int opacity) {
            this.myHue = h;
            this.mySaturation = s;
            this.myBrightness = b;
            this.myOpacity = opacity;
            this.myColor = ColorUtil.toAlpha((Color)Color.getHSBColor(h, s, b), (int)opacity);
            this.fireColorChanged(this);
            this.repaint();
        }

        private void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myColor = color;
            this.myHue = hsb[0];
            this.mySaturation = hsb[1];
            this.myBrightness = hsb[2];
            this.myOpacity = color.getAlpha();
            this.fireColorChanged(source);
            this.repaint();
        }

        public void addListener(ColorListener listener) {
            this.myListeners.add(listener);
        }

        private void fireColorChanged(Object source) {
            for (ColorListener listener : this.myListeners) {
                listener.colorChanged(this.myColor, source);
            }
        }

        public void setOpacity(int opacity) {
            if (opacity != this.myOpacity) {
                this.setHSBValue(this.myHue, this.mySaturation, this.myBrightness, opacity);
            }
        }

        public void setHue(float hue) {
            if ((double)Math.abs(hue - this.myHue) > 0.01) {
                this.setHSBValue(hue, this.mySaturation, this.myBrightness, this.myOpacity);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)250, (int)170);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)150, (int)170);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            this.myComponent = new Rectangle(BORDER_SIZE, BORDER_SIZE, size.width, size.height);
            this.myImage = this.createImage(new SaturationBrightnessImageProducer(size.width - BORDER_SIZE * 2, size.height - BORDER_SIZE * 2, this.myHue));
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.myImage, this.myComponent.x, this.myComponent.y, null);
            int x = Math.round(this.mySaturation * (float)(this.myComponent.width - 2 * BORDER_SIZE));
            int y = Math.round((float)(this.myComponent.height - 2 * BORDER_SIZE) * (1.0f - this.myBrightness));
            int knobX = BORDER_SIZE + x;
            int knobY = BORDER_SIZE + y;
            g.setColor(Color.WHITE);
            g.drawOval(knobX - JBUI.scale((int)4), knobY - JBUI.scale((int)4), JBUI.scale((int)8), JBUI.scale((int)8));
            g.drawOval(knobX - JBUI.scale((int)3), knobY - JBUI.scale((int)3), JBUI.scale((int)6), JBUI.scale((int)6));
        }

        public void dropImage() {
            this.myImage = null;
        }

        @VisibleForTesting
        protected Color getColor() {
            return this.myColor;
        }
    }

    private static class ColorSelectionPanel
    extends JPanel {
        private SaturationBrightnessComponent mySaturationBrightnessComponent;
        private HueSlideComponent myHueComponent;
        private SlideComponent myOpacityComponent = null;

        private ColorSelectionPanel(ColorListener listener, boolean enableOpacity, boolean opacityInPercent) {
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.mySaturationBrightnessComponent = new SaturationBrightnessComponent();
            this.add(this.mySaturationBrightnessComponent);
            this.mySaturationBrightnessComponent.addListener(listener);
            this.myHueComponent = new HueSlideComponent("Hue");
            this.myHueComponent.setToolTipText("Hue");
            this.myHueComponent.addListener((Consumer<Integer>)((Consumer)value -> {
                this.mySaturationBrightnessComponent.setHue((float)value.intValue() / 360.0f);
                this.myOpacityComponent.setHue((float)value.intValue() / 360.0f);
                this.mySaturationBrightnessComponent.repaint();
            }));
            this.add(this.myHueComponent);
            if (enableOpacity) {
                this.myOpacityComponent = new SlideComponent("Opacity");
                this.myOpacityComponent.setUnits(opacityInPercent ? SlideComponent.Unit.PERCENT : SlideComponent.Unit.LEVEL);
                this.myOpacityComponent.setToolTipText("Opacity");
                this.myOpacityComponent.addListener((Consumer<Integer>)((Consumer)integer -> {
                    this.mySaturationBrightnessComponent.setOpacity((int)integer);
                    this.mySaturationBrightnessComponent.repaint();
                }));
                this.add(this.myOpacityComponent);
            }
        }

        public void setOpacityComponentColor(Color color) {
            this.myOpacityComponent.setColor(color);
            this.myOpacityComponent.repaint();
        }

        public void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myHueComponent.setHueValue(hsb[0]);
            this.myHueComponent.repaint();
            this.mySaturationBrightnessComponent.dropImage();
            if (this.myOpacityComponent != null) {
                this.setOpacityComponentColor(color);
                this.myOpacityComponent.setValue(color.getAlpha());
                this.myOpacityComponent.repaint();
            }
            this.mySaturationBrightnessComponent.setColor(color, source);
        }
    }
}

