/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.model.MarginType;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultResizeHandler
extends ResizeHandler {
    public Rectangle bounds;
    public Dimension wrapBounds;
    public boolean wrapWidth;
    public boolean wrapHeight;
    public boolean fillWidth;
    public boolean fillHeight;
    public Segment horizontalFillSegment;
    public Segment verticalFillSegment;

    public DefaultResizeHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        if (editor == null) {
            DefaultResizeHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            DefaultResizeHandler.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            DefaultResizeHandler.$$$reportNull$$$0(2);
        }
        super(editor, handler, component2, horizontalEdgeType, verticalEdgeType);
        Map<NlComponent, Dimension> sizes = editor.measureChildren(this.layout, new RenderTask.AttributeFilter(){

            @Override
            public String getAttribute(@NotNull XmlTag n, @Nullable String namespace, @NotNull String localName) {
                if (n == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (localName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "wrap_content";
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "n";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "localName";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/api/DefaultResizeHandler$1";
                objectArray[2] = "getAttribute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (sizes != null) {
            this.wrapBounds = sizes.get(component2);
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
        if (newBounds == null) {
            DefaultResizeHandler.$$$reportNull$$$0(3);
        }
        super.update(x, y, modifiers, newBounds);
        this.bounds = newBounds;
        this.wrapHeight = false;
        this.wrapWidth = false;
        if (this.wrapBounds != null) {
            Dimension b = this.wrapBounds;
            int maxMatchDistance = 20;
            if (this.horizontalEdgeType != null && Math.abs(newBounds.height - b.height) < maxMatchDistance) {
                this.wrapHeight = true;
                if (this.horizontalEdgeType == SegmentType.TOP) {
                    newBounds.y += newBounds.height - b.height;
                }
                newBounds.height = b.height;
            }
            if (this.verticalEdgeType != null && Math.abs(newBounds.width - b.width) < maxMatchDistance) {
                this.wrapWidth = true;
                if (this.verticalEdgeType == SegmentType.LEFT) {
                    newBounds.x += newBounds.width - b.width;
                }
                newBounds.width = b.width;
            }
        }
        this.horizontalFillSegment = null;
        this.fillHeight = false;
        Rectangle parentBounds = new Rectangle(NlComponentHelperKt.getX(this.layout), NlComponentHelperKt.getY(this.layout), NlComponentHelperKt.getW(this.layout), NlComponentHelperKt.getH(this.layout));
        if (this.horizontalEdgeType == SegmentType.BOTTOM && !this.wrapHeight) {
            this.horizontalFillSegment = new Segment(parentBounds.y + parentBounds.height, newBounds.x, newBounds.x + newBounds.width, null, null, SegmentType.BOTTOM, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.y + newBounds.height - (parentBounds.y + parentBounds.height)) < 20) {
                this.fillHeight = true;
                newBounds.height = parentBounds.y + parentBounds.height - newBounds.y;
            }
        }
        this.verticalFillSegment = null;
        this.fillWidth = false;
        if (this.verticalEdgeType == SegmentType.RIGHT && !this.wrapWidth) {
            this.verticalFillSegment = new Segment(parentBounds.x + parentBounds.width, newBounds.y, newBounds.y + newBounds.height, null, null, SegmentType.RIGHT, MarginType.NO_MARGIN);
            if (Math.abs(newBounds.x + newBounds.width - (parentBounds.x + parentBounds.width)) < 20) {
                this.fillWidth = true;
                newBounds.width = parentBounds.x + parentBounds.width - newBounds.x;
            }
        }
        return null;
    }

    @Override
    public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
        NlComponent parent;
        if (newBounds == null) {
            DefaultResizeHandler.$$$reportNull$$$0(4);
        }
        if ((parent = this.component.getParent()) == null) {
            return;
        }
        this.setNewSizeBounds(this.component, parent, new Rectangle(NlComponentHelperKt.getX(this.component), NlComponentHelperKt.getY(this.component), NlComponentHelperKt.getW(this.component), NlComponentHelperKt.getH(this.component)), newBounds, this.horizontalEdgeType, this.verticalEdgeType);
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        block24: {
            int x;
            Rectangle b;
            block27: {
                int wrapHeight1;
                int wrapWidth1;
                block25: {
                    int y;
                    block26: {
                        Segment s;
                        if (graphics == null) {
                            DefaultResizeHandler.$$$reportNull$$$0(5);
                        }
                        graphics.useStyle(NlDrawingStyle.RESIZE_PREVIEW);
                        if (this.bounds == null) {
                            return;
                        }
                        b = this.bounds;
                        graphics.drawRect(b.x, b.y, b.width, b.height);
                        if (this.horizontalFillSegment != null) {
                            graphics.useStyle(NlDrawingStyle.GUIDELINE);
                            s = this.horizontalFillSegment;
                            graphics.drawLine(s.from, s.at, s.to, s.at);
                        }
                        if (this.verticalFillSegment != null) {
                            graphics.useStyle(NlDrawingStyle.GUIDELINE);
                            s = this.verticalFillSegment;
                            graphics.drawLine(s.at, s.from, s.at, s.to);
                        }
                        if (this.wrapBounds == null) break block24;
                        graphics.useStyle(NlDrawingStyle.GUIDELINE);
                        wrapWidth1 = this.wrapBounds.width;
                        wrapHeight1 = this.wrapBounds.height;
                        if (this.horizontalEdgeType == null) break block25;
                        y = -1;
                        switch (this.horizontalEdgeType) {
                            case TOP: {
                                y = b.y + b.height - wrapHeight1;
                                break;
                            }
                            case BOTTOM: {
                                y = b.y + wrapHeight1;
                                break;
                            }
                            default: {
                                assert (false) : this.horizontalEdgeType;
                                break;
                            }
                        }
                        if (this.verticalEdgeType == null) break block26;
                        switch (this.verticalEdgeType) {
                            case LEFT: {
                                graphics.drawLine(b.x + b.width - wrapWidth1, y, b.x + b.width, y);
                                break block25;
                            }
                            case RIGHT: {
                                graphics.drawLine(b.x, y, b.x + wrapWidth1, y);
                                break block25;
                            }
                            default: {
                                assert (false) : this.verticalEdgeType;
                                break block25;
                            }
                        }
                    }
                    graphics.drawLine(b.x, y, b.x + b.width, y);
                }
                if (this.verticalEdgeType == null) break block24;
                x = -1;
                switch (this.verticalEdgeType) {
                    case LEFT: {
                        x = b.x + b.width - wrapWidth1;
                        break;
                    }
                    case RIGHT: {
                        x = b.x + wrapWidth1;
                        break;
                    }
                    default: {
                        assert (false) : this.verticalEdgeType;
                        break;
                    }
                }
                if (this.horizontalEdgeType == null) break block27;
                switch (this.horizontalEdgeType) {
                    case TOP: {
                        graphics.drawLine(x, b.y + b.height - wrapHeight1, x, b.y + b.height);
                        break block24;
                    }
                    case BOTTOM: {
                        graphics.drawLine(x, b.y, x, b.y + wrapHeight1);
                        break block24;
                    }
                    default: {
                        assert (false) : this.horizontalEdgeType;
                        break block24;
                    }
                }
            }
            graphics.drawLine(x, b.y, x, b.y + b.height);
        }
    }

    @NotNull
    public String getWidthAttribute() {
        if (this.wrapWidth) {
            if ("wrap_content" == null) {
                DefaultResizeHandler.$$$reportNull$$$0(6);
            }
            return "wrap_content";
        }
        if (this.fillWidth) {
            if ("match_parent" == null) {
                DefaultResizeHandler.$$$reportNull$$$0(7);
            }
            return "match_parent";
        }
        String string = String.format("%ddp", this.editor.pxToDp(this.bounds.width));
        if (string == null) {
            DefaultResizeHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getHeightAttribute() {
        if (this.wrapHeight) {
            if ("wrap_content" == null) {
                DefaultResizeHandler.$$$reportNull$$$0(9);
            }
            return "wrap_content";
        }
        if (this.fillHeight) {
            if ("match_parent" == null) {
                DefaultResizeHandler.$$$reportNull$$$0(10);
            }
            return "match_parent";
        }
        String string = String.format("%ddp", this.editor.pxToDp(this.bounds.height));
        if (string == null) {
            DefaultResizeHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    protected String getResizeUpdateMessage(@NotNull NlComponent child, @NotNull NlComponent parent, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        if (child == null) {
            DefaultResizeHandler.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            DefaultResizeHandler.$$$reportNull$$$0(13);
        }
        if (newBounds == null) {
            DefaultResizeHandler.$$$reportNull$$$0(14);
        }
        String width = this.getWidthAttribute();
        String height = this.getHeightAttribute();
        if (horizontalEdge == null) {
            return width;
        }
        if (verticalEdge == null) {
            return height;
        }
        return String.format("%s \u00d7 %s", width, height);
    }

    protected void setNewSizeBounds(@NotNull NlComponent component2, @NotNull NlComponent layout, @NotNull Rectangle oldBounds, @NotNull Rectangle newBounds, @Nullable SegmentType horizontalEdge, @Nullable SegmentType verticalEdge) {
        if (component2 == null) {
            DefaultResizeHandler.$$$reportNull$$$0(15);
        }
        if (layout == null) {
            DefaultResizeHandler.$$$reportNull$$$0(16);
        }
        if (oldBounds == null) {
            DefaultResizeHandler.$$$reportNull$$$0(17);
        }
        if (newBounds == null) {
            DefaultResizeHandler.$$$reportNull$$$0(18);
        }
        if (verticalEdge != null && (newBounds.width != oldBounds.width || this.wrapWidth || this.fillWidth)) {
            component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", this.getWidthAttribute());
        }
        if (horizontalEdge != null && (newBounds.height != oldBounds.height || this.wrapHeight || this.fillHeight)) {
            component2.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", this.getHeightAttribute());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBounds";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphics";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/api/DefaultResizeHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/api/DefaultResizeHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidthAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeightAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResizeUpdateMessage";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNewSizeBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

