/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.editor.AnimationToolbar;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.error.IssuePanelSplitter;
import com.android.tools.idea.uibuilder.handlers.transition.TransitionLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.palette2.PaletteDefinition;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.util.SyncUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewForm
implements Disposable,
CaretListener {
    public static final String PREVIEW_DESIGN_SURFACE = "NlPreviewFormDesignSurface";
    private final NlPreviewManager myManager;
    private final Project myProject;
    private final NlDesignSurface mySurface;
    private final WorkBench<DesignSurface> myWorkBench;
    private final JPanel myRoot = new JPanel(new BorderLayout());
    private final MergingUpdateQueue myRenderingQueue = new MergingUpdateQueue("android.layout.preview.caret", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    private boolean myUseInteractiveSelector = true;
    private boolean myIgnoreListener;
    private RenderResult myRenderResult;
    private XmlFile myFile;
    private boolean isActive = false;
    private ActionsToolbar myActionsToolbar;
    private JComponent myContentPanel;
    @Nullable
    private AnimationToolbar myAnimationToolbar;
    private NlModel myModel;
    private Pending myPendingFile;
    private TextEditor myPendingEditor;
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private SceneMode mySceneMode;

    public NlPreviewForm(NlPreviewManager manager) {
        this.myManager = manager;
        this.myProject = this.myManager.getProject();
        this.mySurface = new NlDesignSurface(this.myProject, true, this);
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setCentered(true);
        this.mySurface.setScreenMode(SceneMode.SCREEN_ONLY, false);
        this.mySurface.setName(PREVIEW_DESIGN_SURFACE);
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.myWorkBench = new WorkBench(this.myProject, "Preview", null);
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        this.myRoot.add((Component)((Object)new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench)));
        Disposer.register((Disposable)this, this.myWorkBench);
    }

    private void createContentPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
    }

    private void setEditor(@Nullable TextEditor editor) {
        if (editor != this.myEditor) {
            this.myEditor = editor;
            this.mySurface.setFileEditorDelegate((FileEditor)editor);
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener((CaretListener)this);
                this.myCaretModel = null;
            }
            if (editor != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener((CaretListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaret() {
        int offset;
        SceneView screenView;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (screenView = this.mySurface.getCurrentSceneView()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            NlComponent parent;
            NlComponent selectedComponent;
            ImmutableList views = screenView.getModel().findByOffset(offset);
            if (views.isEmpty()) {
                views = screenView.getModel().getComponents();
            }
            if (this.mySurface.isPreviewSurface() && views.size() == 1 && "intent".equals((selectedComponent = (NlComponent)views.get(0)).getTagName()) && "PreferenceScreen".equals(selectedComponent.getRoot().getTagName()) && (parent = selectedComponent.getParent()) != null) {
                views = ImmutableList.of((Object)parent);
            }
            try {
                this.myIgnoreListener = true;
                SelectionModel selectionModel = screenView.getSelectionModel();
                selectionModel.setSelection((List<NlComponent>)views);
                this.myRenderingQueue.queue(new Update("Preview update"){

                    public void run() {
                        NlPreviewForm.this.mySurface.repaint();
                    }

                    public boolean canEat(Update update) {
                        return true;
                    }
                });
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    @Nullable
    public JComponent getToolbarComponent() {
        return this.myActionsToolbar.getToolbarComponent();
    }

    @Nullable
    public XmlFile getFile() {
        return this.myFile;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            NlPreviewForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void dispose() {
        this.deactivate();
        this.disposeActionsToolbar();
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
            this.myModel = null;
        }
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }

    public boolean setNextEditor(@NotNull TextEditor editor) {
        PsiFile psiFile;
        if (editor == null) {
            NlPreviewForm.$$$reportNull$$$0(1);
        }
        if (this.myAnimationToolbar != null) {
            this.myAnimationToolbar.stop();
        }
        if ((psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getEditor().getDocument())) == null) {
            return false;
        }
        this.myPendingEditor = editor;
        this.myFile = this.myManager.getBoundXmlFile(psiFile);
        if (this.myPendingFile != null) {
            this.myPendingFile.invalidate();
        }
        if (this.isActive) {
            this.initPreviewForm();
        }
        return true;
    }

    public void clearRenderResult() {
        if (this.myRenderResult != null && this.myRenderResult.getFile() != this.myFile) {
            this.myRenderResult = RenderResult.createBlank((PsiFile)this.myFile);
        }
    }

    private void initPreviewForm() {
        if (this.myContentPanel == null) {
            ClearResourceCacheAfterFirstBuild.getInstance(this.myProject).runWhenResourceCacheClean(this::initPreviewFormAfterInitialBuild, this::buildError);
        } else {
            this.initNeleModel();
        }
    }

    private void initPreviewFormAfterInitialBuild() {
        ProjectSystemSyncManager syncManager = ProjectSystemUtil.getSyncManager(this.myProject);
        if (!syncManager.isSyncInProgress()) {
            if (syncManager.getLastSyncResult().isSuccessful()) {
                UIUtil.invokeLaterIfNeeded(this::initPreviewFormAfterBuildOnEventDispatchThread);
                return;
            }
            this.buildError();
        }
        SyncUtil.listenUntilNextSuccessfulSync(this.myProject, this, result -> {
            if (result.isSuccessful()) {
                UIUtil.invokeLaterIfNeeded(this::initPreviewFormAfterBuildOnEventDispatchThread);
            } else {
                this.buildError();
            }
        });
    }

    private void buildError() {
        this.myWorkBench.loadingStopped("Preview is unavailable until a successful build");
    }

    private void initPreviewFormAfterBuildOnEventDispatchThread() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myContentPanel == null) {
            this.createContentPanel();
            ArrayList<PaletteDefinition> tools = new ArrayList<PaletteDefinition>(4);
            tools.add(new PaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.AUTO_HIDE));
            this.myWorkBench.init(this.myContentPanel, (Object)this.mySurface, tools);
        }
        this.initNeleModel();
    }

    private void initAnimationsToolbar() {
        boolean animationsBarEnabled;
        if (this.myAnimationToolbar != null) {
            this.myContentPanel.remove(this.myAnimationToolbar);
        }
        boolean bl = animationsBarEnabled = (Boolean)StudioFlags.NELE_ANIMATIONS_PREVIEW.get() != false || (Boolean)StudioFlags.NELE_TRANSITION_LAYOUT_ANIMATIONS.get() != false;
        if (!animationsBarEnabled || this.myModel == null) {
            this.myAnimationToolbar = null;
            return;
        }
        if (((Boolean)StudioFlags.NELE_TRANSITION_LAYOUT_ANIMATIONS.get()).booleanValue()) {
            long maxTimeMs;
            NlComponent transitionLayout = this.myModel.flattenComponents().filter(component2 -> NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.TransitionLayout")).findAny().orElse(null);
            TransitionLayoutHandler.TransitionLayoutComponentHelper helper = transitionLayout != null ? new TransitionLayoutHandler.TransitionLayoutComponentHelper(transitionLayout) : null;
            long l = maxTimeMs = helper != null ? helper.getMaxTimeMs() : -1L;
            if (helper != null) {
                this.myAnimationToolbar = AnimationToolbar.createAnimationToolbar(this, timeMs -> {
                    LayoutlibSceneManager sceneManager = this.mySurface.getSceneManager();
                    if (this.myModel != null && sceneManager != null) {
                        sceneManager.setElapsedFrameTimeMs(timeMs);
                        helper.setValue((float)(timeMs - 500L) / (float)maxTimeMs);
                    }
                }, 16L, 500L, maxTimeMs + 500L);
            }
        }
        if (this.myAnimationToolbar == null) {
            this.myAnimationToolbar = AnimationToolbar.createUnlimitedAnimationToolbar(this, timeMs -> {
                LayoutlibSceneManager sceneManager = this.mySurface.getSceneManager();
                if (this.myModel != null && sceneManager != null) {
                    sceneManager.setElapsedFrameTimeMs(timeMs);
                    sceneManager.requestRender();
                }
            }, 16L, 500L);
        }
        this.myContentPanel.add((Component)this.myAnimationToolbar, "South");
    }

    private void initNeleModel() {
        AndroidFacet facet;
        XmlFile xmlFile = this.myFile;
        AndroidFacet androidFacet = facet = xmlFile != null ? AndroidFacet.getInstance((PsiElement)xmlFile) : null;
        if (!this.isActive || facet == null || xmlFile.getVirtualFile() == null) {
            this.myPendingFile = null;
            this.setActiveModel(null);
        } else {
            Device device;
            if (this.myModel != null) {
                Disposer.dispose((Disposable)this.myModel);
            }
            this.myModel = NlModel.create(null, facet, xmlFile.getVirtualFile());
            this.mySurface.setModel(this.myModel);
            this.myPendingFile = new Pending(xmlFile, this.myModel);
            if (this.myModel.getType() == NlLayoutType.ADAPTIVE_ICON && (device = this.myModel.getConfiguration().getDevice()) != null && !"Custom Density".equals(device.getId())) {
                NlModelHelperKt.overrideConfigurationDensity(this.myModel, Density.XXXHIGH);
            }
        }
    }

    public void setActiveModel(@Nullable NlModel model) {
        NlModel oldModel;
        this.myPendingFile = null;
        SceneView currentScreenView = this.mySurface.getCurrentSceneView();
        if (currentScreenView != null && model != (oldModel = currentScreenView.getModel())) {
            oldModel.deactivate(this);
            Disposer.dispose((Disposable)oldModel);
        }
        if (model == null) {
            this.setEditor(null);
            this.disposeActionsToolbar();
            this.myWorkBench.setToolContext(null);
        } else {
            this.myFile = model.getFile();
            if (!this.mySurface.isCanvasResizing()) {
                this.mySurface.zoomToFit();
            } else {
                this.mySurface.updateScrolledAreaSize();
            }
            this.setEditor(this.myPendingEditor);
            this.myPendingEditor = null;
            model.activate(this);
            this.myWorkBench.setToolContext((Object)this.mySurface);
            this.myWorkBench.setFileEditor((FileEditor)this.myEditor);
            this.disposeActionsToolbar();
            this.myActionsToolbar = new ActionsToolbar(null, this.mySurface);
            this.myActionsToolbar.setModel(model);
            this.myContentPanel.add((Component)this.myActionsToolbar.getToolbarComponent(), "North");
            if (!model.getType().isSupportedByDesigner()) {
                this.mySceneMode = this.mySurface.getSceneMode();
                this.mySurface.setScreenMode(SceneMode.SCREEN_ONLY, false);
                this.myWorkBench.setMinimizePanelsVisible(false);
            } else if (this.mySceneMode != null && this.mySurface.getSceneMode() == SceneMode.SCREEN_ONLY) {
                this.mySurface.setScreenMode(this.mySceneMode, false);
                this.myWorkBench.setMinimizePanelsVisible(true);
            }
        }
        this.initAnimationsToolbar();
    }

    private void disposeActionsToolbar() {
        if (this.myActionsToolbar == null) {
            return;
        }
        this.myContentPanel.remove(this.myActionsToolbar.getToolbarComponent());
        Disposer.dispose((Disposable)this.myActionsToolbar);
        this.myActionsToolbar = null;
    }

    @NotNull
    public NlDesignSurface getSurface() {
        NlDesignSurface nlDesignSurface = this.mySurface;
        if (nlDesignSurface == null) {
            NlPreviewForm.$$$reportNull$$$0(2);
        }
        return nlDesignSurface;
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            NlPreviewForm.$$$reportNull$$$0(3);
        }
        if (!this.myIgnoreListener) {
            this.updateCaret();
        }
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.initPreviewForm();
        this.mySurface.activate();
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.mySurface.deactivate();
        this.isActive = false;
        if (this.myContentPanel != null) {
            this.myPendingFile = null;
            this.setActiveModel(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNextEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Pending
    implements RenderListener,
    Runnable {
        public final XmlFile file;
        public final NlModel model;
        public final SceneView screenView;
        public boolean valid = true;

        Pending(XmlFile file, NlModel model) {
            this.file = file;
            this.model = model;
            this.screenView = NlPreviewForm.this.mySurface.getCurrentSceneView();
            if (this.screenView != null) {
                this.screenView.getSceneManager().addRenderListener(this);
                this.screenView.getSceneManager().requestRender();
            }
        }

        @Override
        public void onRenderCompleted() {
            if (this.screenView != null) {
                this.screenView.getSceneManager().removeRenderListener(this);
            }
            if (this.valid) {
                this.valid = false;
                ApplicationManager.getApplication().invokeLater((Runnable)this, this.model.getProject().getDisposed());
            }
        }

        public void invalidate() {
            this.valid = false;
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            NlPreviewForm.this.setActiveModel(this.model);
        }
    }
}

