/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import icons.StudioIcons;
import java.awt.event.HierarchyListener;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewManager
implements ProjectComponent {
    private final MergingUpdateQueue myToolWindowUpdateQueue;
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private NlPreviewForm myToolWindowForm;
    private ToolWindow myToolWindow;
    private boolean myToolWindowReady = false;
    private boolean myToolWindowDisposed = false;
    private int myUpdateCount;
    private boolean mySeenEditor;
    private JComponent myPendingShowComponent;
    private HierarchyListener myHierarchyListener;
    private boolean myRenderImmediately;

    public NlPreviewManager(Project project, FileEditorManager fileEditorManager) {
        this.myProject = project;
        this.myFileEditorManager = fileEditorManager;
        this.myToolWindowUpdateQueue = new MergingUpdateQueue("android.layout.preview", 100, true, null, (Disposable)project);
        MessageBusConnection connection2 = project.getMessageBus().connect((Disposable)project);
        connection2.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> {
            this.myToolWindowReady = true;
            this.processFileEditorChange(this.getActiveLayoutXmlEditor(null));
        });
    }

    public boolean isWindowVisible() {
        return this.myToolWindow != null && this.myToolWindow.isVisible();
    }

    protected boolean isUseInteractiveSelector() {
        return true;
    }

    protected String getToolWindowId() {
        return AndroidBundle.message("android.layout.preview.tool.window.title", new Object[0]);
    }

    @NotNull
    protected NlPreviewForm createPreviewForm() {
        NlPreviewForm nlPreviewForm = new NlPreviewForm(this);
        if (nlPreviewForm == null) {
            NlPreviewManager.$$$reportNull$$$0(0);
        }
        return nlPreviewForm;
    }

    protected void initToolWindow() {
        this.myToolWindowForm = this.createPreviewForm();
        final String toolWindowId = this.getToolWindowId();
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(toolWindowId, false, ToolWindowAnchor.RIGHT, (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PREVIEW);
        ((ToolWindowEx)this.myToolWindow).setUseLastFocusedOnActivation(false);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged() {
                if (NlPreviewManager.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindow window = ToolWindowManager.getInstance((Project)NlPreviewManager.this.myProject).getToolWindow(toolWindowId);
                if (window != null && window.isAvailable()) {
                    boolean visible = window.isVisible();
                    AndroidEditorSettings.getInstance().getGlobalState().setVisible(visible);
                    if (NlPreviewManager.this.myToolWindowForm != null) {
                        if (visible) {
                            NlPreviewManager.this.myToolWindowForm.activate();
                        } else {
                            NlPreviewManager.this.myToolWindowForm.deactivate();
                        }
                    }
                }
            }
        });
        JComponent contentPanel = this.myToolWindowForm.getComponent();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(contentPanel, null, false);
        content.setDisposer((Disposable)this.myToolWindowForm);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(contentPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindowForm.setUseInteractiveSelector(this.isUseInteractiveSelector());
        if (this.isWindowVisible()) {
            this.myToolWindowForm.activate();
        }
    }

    public void projectClosed() {
        if (this.myToolWindowForm != null) {
            Disposer.dispose((Disposable)this.myToolWindowForm);
            this.myToolWindowForm = null;
            this.myToolWindow = null;
            this.myToolWindowDisposed = true;
        }
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("NlPreviewManager" == null) {
            NlPreviewManager.$$$reportNull$$$0(1);
        }
        return "NlPreviewManager";
    }

    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    private void processFileEditorChange(final @Nullable TextEditor newEditor) {
        if (this.myPendingShowComponent != null) {
            this.myPendingShowComponent.removeHierarchyListener(this.myHierarchyListener);
            this.myPendingShowComponent = null;
        }
        this.myToolWindowUpdateQueue.cancelAllUpdates();
        this.myToolWindowUpdateQueue.queue(new Update("update"){

            public void run() {
                Editor activeEditor;
                NlPreviewManager.this.myUpdateCount++;
                if (!NlPreviewManager.this.myToolWindowReady || NlPreviewManager.this.myToolWindowDisposed) {
                    return;
                }
                NlPreviewManager.this.myRenderImmediately = false;
                Editor editor = activeEditor = newEditor != null ? newEditor.getEditor() : null;
                if (NlPreviewManager.this.myToolWindow == null) {
                    if (activeEditor == null) {
                        return;
                    }
                    if (!activeEditor.getComponent().isShowing()) {
                        if (!NlPreviewManager.this.mySeenEditor) {
                            NlPreviewManager.this.myPendingShowComponent = activeEditor.getComponent();
                            if (NlPreviewManager.this.myHierarchyListener == null) {
                                NlPreviewManager.this.myHierarchyListener = hierarchyEvent -> {
                                    if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && hierarchyEvent.getComponent() == NlPreviewManager.this.myPendingShowComponent && NlPreviewManager.this.myPendingShowComponent.isShowing()) {
                                        NlPreviewManager.this.myPendingShowComponent.removeHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                                        NlPreviewManager.this.mySeenEditor = true;
                                        NlPreviewManager.this.myPendingShowComponent = null;
                                        NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(null));
                                    }
                                };
                            }
                            NlPreviewManager.this.myPendingShowComponent.addHierarchyListener(NlPreviewManager.this.myHierarchyListener);
                        }
                        return;
                    }
                    NlPreviewManager.this.mySeenEditor = true;
                    NlPreviewManager.this.initToolWindow();
                }
                AndroidEditorSettings settings = AndroidEditorSettings.getInstance();
                boolean hideForNonLayoutFiles = settings.getGlobalState().isHideForNonLayoutFiles();
                if (activeEditor == null) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                if (!NlPreviewManager.this.myToolWindowForm.setNextEditor(newEditor)) {
                    NlPreviewManager.this.myToolWindow.setAvailable(!hideForNonLayoutFiles, null);
                    return;
                }
                NlPreviewManager.this.myToolWindow.setAvailable(true, null);
                boolean visible = AndroidEditorSettings.getInstance().getGlobalState().isVisible();
                if (visible && !NlPreviewManager.this.myToolWindow.isVisible()) {
                    Runnable restoreFocus = null;
                    if (NlPreviewManager.this.myToolWindow.getType() == ToolWindowType.WINDOWED) {
                        restoreFocus = () -> IdeFocusManager.getInstance((Project)NlPreviewManager.this.myProject).doWhenFocusSettlesDown(() -> NlPreviewManager.restoreFocusToEditor(newEditor));
                    }
                    NlPreviewManager.this.myToolWindowForm.clearRenderResult();
                    NlPreviewManager.this.myToolWindow.activate(restoreFocus, false, false);
                }
            }
        });
    }

    private static void restoreFocusToEditor(@NotNull TextEditor newEditor) {
        if (newEditor == null) {
            NlPreviewManager.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (newEditor == null) {
                NlPreviewManager.$$$reportNull$$$0(7);
            }
            newEditor.getEditor().getContentComponent().requestFocus();
        });
    }

    @Nullable
    private TextEditor getActiveLayoutXmlEditor(@Nullable PsiFile file) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (TextEditor)ApplicationManager.getApplication().runReadAction(() -> this.getActiveLayoutXmlEditor(file));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return Arrays.stream(this.myFileEditorManager.getSelectedEditors()).filter(editor -> editor instanceof TextEditor && this.isApplicableEditor((TextEditor)editor, file)).findFirst().orElse(null);
    }

    public boolean isApplicableEditor(@NotNull TextEditor textEditor, @Nullable PsiFile file) {
        if (textEditor == null) {
            NlPreviewManager.$$$reportNull$$$0(3);
        }
        Document document = textEditor.getEditor().getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        if (file != null && !file.equals(psiFile)) {
            return false;
        }
        return NlPreviewManager.isInResourceFolder(psiFile);
    }

    @Nullable
    protected XmlFile getBoundXmlFile(@Nullable PsiFile file) {
        return (XmlFile)file;
    }

    @Nullable
    protected ToolWindow getToolWindow() {
        return this.myToolWindow;
    }

    @NotNull
    public NlPreviewForm getPreviewForm() {
        if (this.myToolWindow == null) {
            this.initToolWindow();
        }
        NlPreviewForm nlPreviewForm = this.myToolWindowForm;
        if (nlPreviewForm == null) {
            NlPreviewManager.$$$reportNull$$$0(4);
        }
        return nlPreviewForm;
    }

    private static boolean isInResourceFolder(@Nullable PsiFile psiFile) {
        if (psiFile instanceof XmlFile) {
            return RenderService.canRender(psiFile);
        }
        return false;
    }

    public static NlPreviewManager getInstance(Project project) {
        return (NlPreviewManager)project.getComponent(NlPreviewManager.class);
    }

    public void notifyFileShown(@NotNull TextEditor editor, boolean renderImmediately) {
        if (editor == null) {
            NlPreviewManager.$$$reportNull$$$0(5);
        }
        if (renderImmediately) {
            this.myRenderImmediately = true;
        }
        this.processFileEditorChange(editor);
        if (renderImmediately) {
            this.myToolWindowUpdateQueue.sendFlush();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NlPreviewManager.$$$reportNull$$$0(6);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewForm";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restoreFocusToEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifyFileShown";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreFocusToEditor$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(1);
            }
            if (!file.isValid()) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)NlPreviewManager.this.myProject).findFile(file);
            NlPreviewManager.this.processFileEditorChange(NlPreviewManager.this.getActiveLayoutXmlEditor(psiFile));
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            TextEditor textEditor;
            if (event == null) {
                MyFileEditorManagerListener.$$$reportNull$$$0(2);
            }
            FileEditor newEditor = event.getNewEditor();
            TextEditor layoutXmlEditor = null;
            if (newEditor instanceof TextEditor && NlPreviewManager.this.isApplicableEditor(textEditor = (TextEditor)newEditor, null)) {
                layoutXmlEditor = textEditor;
            }
            NlPreviewManager.this.processFileEditorChange(layoutXmlEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewManager$MyFileEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

