/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.HtmlBuilder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlIssue {
    public static final String EXECUTE_FIX = "Execute Fix: ";

    @NotNull
    public abstract String getSummary();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract HighlightSeverity getSeverity();

    @Nullable
    public abstract NlComponent getSource();

    public abstract String getCategory();

    @Nullable
    public HyperlinkListener getHyperlinkListener() {
        return null;
    }

    @NotNull
    public Stream<Fix> getFixes() {
        Stream<Fix> stream = Stream.empty();
        if (stream == null) {
            NlIssue.$$$reportNull$$$0(0);
        }
        return stream;
    }

    @NotNull
    public static NlIssue wrapIssue(@NotNull RenderErrorModel.Issue renderIssue2) {
        if (renderIssue2 == null) {
            NlIssue.$$$reportNull$$$0(1);
        }
        NlRenderIssueWrapper nlRenderIssueWrapper = new NlRenderIssueWrapper(renderIssue2);
        if (nlRenderIssueWrapper == null) {
            NlIssue.$$$reportNull$$$0(2);
        }
        return nlRenderIssueWrapper;
    }

    @NotNull
    public static NlIssue wrapIssue(@NotNull LintAnnotationsModel.IssueData lintIssue) {
        if (lintIssue == null) {
            NlIssue.$$$reportNull$$$0(3);
        }
        NlLintIssueWrapper nlLintIssueWrapper = new NlLintIssueWrapper(lintIssue);
        if (nlLintIssueWrapper == null) {
            NlIssue.$$$reportNull$$$0(4);
        }
        return nlLintIssueWrapper;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NlIssue)) {
            return false;
        }
        NlIssue nlIssue = (NlIssue)object;
        return nlIssue.getSeverity().equals((Object)this.getSeverity()) && nlIssue.getSummary().equals(this.getSummary()) && nlIssue.getDescription().equals(this.getDescription()) && nlIssue.getCategory().equals(this.getCategory()) && nlIssue.getSource() == this.getSource();
    }

    public int hashCode() {
        int result = 13;
        result += 17 * this.getSeverity().hashCode();
        result += 19 * this.getSummary().hashCode();
        result += 23 * this.getDescription().hashCode();
        result += 29 * this.getCategory().hashCode();
        NlComponent source = this.getSource();
        if (source != null) {
            result += 31 * source.hashCode();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/error/NlIssue";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderIssue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lintIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/error/NlIssue";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapIssue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Fix {
        String myDescription;
        Runnable myRunnable;

        private Fix(@NotNull String description, @NotNull Runnable runnable) {
            if (description == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (runnable == null) {
                Fix.$$$reportNull$$$0(1);
            }
            this.myDescription = description;
            this.myRunnable = runnable;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                Fix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public Runnable getRunnable() {
            Runnable runnable = this.myRunnable;
            if (runnable == null) {
                Fix.$$$reportNull$$$0(3);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/error/NlIssue$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/error/NlIssue$Fix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NlLintIssueWrapper
    extends NlIssue {
        private final LintAnnotationsModel.IssueData myIssue;
        private String myDescription;

        private NlLintIssueWrapper(@NotNull LintAnnotationsModel.IssueData issue2) {
            if (issue2 == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(0);
            }
            this.myIssue = issue2;
        }

        private String createFullDescription() {
            Issue issue2 = this.myIssue.issue;
            String headerFontColor = HtmlBuilderHelper.getHeaderFontColor();
            HtmlBuilder builder = new HtmlBuilder();
            builder.addHtml(TextFormat.RAW.convertTo(this.myIssue.message, TextFormat.HTML));
            builder.newline().newline();
            builder.addHtml(issue2.getExplanation(TextFormat.HTML));
            builder.newline();
            List moreInfo = issue2.getMoreInfo();
            int count = moreInfo.size();
            if (count > 1) {
                builder.addHeading("More Info: ", headerFontColor);
                builder.beginList();
            }
            for (String uri : moreInfo) {
                if (count > 1) {
                    builder.listItem();
                }
                builder.addLink(uri, uri);
            }
            if (count > 1) {
                builder.endList();
            }
            builder.newline();
            return builder.getHtml();
        }

        @Override
        @NotNull
        public String getSummary() {
            String string = this.myIssue.issue.getBriefDescription(TextFormat.RAW);
            if (string == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            if (this.myDescription == null) {
                this.myDescription = this.createFullDescription();
            }
            String string = this.myDescription;
            if (string == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myIssue.level.getSeverity();
            if (highlightSeverity == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(3);
            }
            return highlightSeverity;
        }

        @Override
        @NotNull
        public NlComponent getSource() {
            NlComponent nlComponent = this.myIssue.component;
            if (nlComponent == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(4);
            }
            return nlComponent;
        }

        @Override
        public String getCategory() {
            return this.myIssue.issue.getCategory().getFullName();
        }

        @Override
        @NotNull
        public Stream<Fix> getFixes() {
            AndroidLintInspectionBase inspection = this.myIssue.inspection;
            AndroidLintQuickFix[] quickFixes = inspection.getQuickFixes(this.myIssue.startElement, this.myIssue.endElement, this.myIssue.message, this.myIssue.quickfixData);
            IntentionAction[] intentions = inspection.getIntentions(this.myIssue.startElement, this.myIssue.endElement);
            Stream<Fix> stream = Stream.concat(Arrays.stream(quickFixes).map(this::createQuickFixPair), Arrays.stream(intentions).map(this::createQuickFixPair));
            if (stream == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(5);
            }
            return stream;
        }

        @NotNull
        private Fix createQuickFixPair(@NotNull AndroidLintQuickFix fix) {
            if (fix == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(6);
            }
            Fix fix2 = new Fix(fix.getName(), this.createQuickFixRunnable(fix));
            if (fix2 == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(7);
            }
            return fix2;
        }

        @NotNull
        private Fix createQuickFixPair(@NotNull IntentionAction fix) {
            if (fix == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(8);
            }
            Fix fix2 = new Fix(fix.getText(), this.createQuickFixRunnable(fix));
            if (fix2 == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(9);
            }
            return fix2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof NlLintIssueWrapper)) {
                return false;
            }
            NlLintIssueWrapper other = (NlLintIssueWrapper)object;
            return super.equals(object) && Objects.equals(other.myIssue.startElement, this.myIssue.startElement) && Objects.equals(other.myIssue.endElement, this.myIssue.endElement);
        }

        @Override
        public int hashCode() {
            int res = super.hashCode();
            return res += 31 * Objects.hash(this.myIssue.startElement, this.myIssue.endElement);
        }

        @NotNull
        private Runnable createQuickFixRunnable(@NotNull AndroidLintQuickFix fix) {
            if (fix == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(10);
            }
            Runnable runnable = () -> {
                if (fix == null) {
                    NlLintIssueWrapper.$$$reportNull$$$0(16);
                }
                NlModel model = this.myIssue.component.getModel();
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(this.myIssue.startElement);
                if (editor != null) {
                    Project project = model.getProject();
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (fix == null) {
                            NlLintIssueWrapper.$$$reportNull$$$0(17);
                        }
                        fix.apply(this.myIssue.startElement, this.myIssue.endElement, AndroidQuickfixContexts.BatchContext.getInstance());
                    }, NlIssue.EXECUTE_FIX + fix.getName(), null);
                }
            };
            if (runnable == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(11);
            }
            return runnable;
        }

        @NotNull
        private Runnable createQuickFixRunnable(@NotNull IntentionAction fix) {
            if (fix == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(12);
            }
            Runnable runnable = () -> {
                if (fix == null) {
                    NlLintIssueWrapper.$$$reportNull$$$0(14);
                }
                NlModel model = this.myIssue.component.getModel();
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(this.myIssue.startElement);
                if (editor != null) {
                    Project project = model.getProject();
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (fix == null) {
                            NlLintIssueWrapper.$$$reportNull$$$0(15);
                        }
                        fix.invoke(project, editor, (PsiFile)model.getFile());
                    }, NlIssue.EXECUTE_FIX + fix.getFamilyName(), null);
                }
            };
            if (runnable == null) {
                NlLintIssueWrapper.$$$reportNull$$$0(13);
            }
            return runnable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "issue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/error/NlIssue$NlLintIssueWrapper";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/error/NlIssue$NlLintIssueWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSummary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSource";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFixes";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickFixPair";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQuickFixRunnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    break;
                }
                case 6: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createQuickFixPair";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "createQuickFixRunnable";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createQuickFixRunnable$3";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$2";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createQuickFixRunnable$1";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NlRenderIssueWrapper
    extends NlIssue {
        private final RenderErrorModel.Issue myIssue;

        private NlRenderIssueWrapper(@NotNull RenderErrorModel.Issue issue2) {
            if (issue2 == null) {
                NlRenderIssueWrapper.$$$reportNull$$$0(0);
            }
            this.myIssue = issue2;
        }

        @Override
        @NotNull
        public String getSummary() {
            String string = this.myIssue.getSummary();
            if (string == null) {
                NlRenderIssueWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myIssue.getHtmlContent();
            if (string == null) {
                NlRenderIssueWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myIssue.getSeverity();
            if (highlightSeverity == null) {
                NlRenderIssueWrapper.$$$reportNull$$$0(3);
            }
            return highlightSeverity;
        }

        @Override
        @Nullable
        public NlComponent getSource() {
            return null;
        }

        @Override
        public String getCategory() {
            return "Rendering Issue";
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myIssue.getHyperlinkListener();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "issue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/error/NlIssue$NlRenderIssueWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/error/NlIssue$NlRenderIssueWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSummary";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

