/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.ColorTheme;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidgetContainer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import javax.swing.Timer;

public class WidgetDecorator {
    public static final int BLUEPRINT_STYLE = 0;
    public static final int ANDROID_STYLE = 1;
    public static Image sLockImageIcon = null;
    public static Image sUnlockImageIcon = null;
    public static Image sDeleteConnectionsImageIcon = null;
    public static Image sPackChainImageIcon = null;
    private static final int ACTIONS_HIDE_TIMEOUT = 1000;
    private boolean mIsVisible = true;
    private boolean mIsSelected = false;
    protected ColorSet mColorSet;
    private AnimationProgress mShowBaseline = new AnimationProgress();
    private AnimationProgress mShowBias = new AnimationProgress();
    ColorTheme mBackgroundColor;
    ColorTheme mFrameColor;
    ColorTheme mTextColor;
    ColorTheme mConstraintsColor;
    ColorTheme.Look mLook;
    protected final ConstraintWidget mWidget;
    private int mStyle;
    private final Timer mHideActions = new Timer(1000, e -> this.repaint());

    public WidgetDecorator(ConstraintWidget widget) {
        this.mWidget = widget;
        this.mShowBias.setDelay(0L);
        this.mShowBias.setDuration(1000L);
        this.mShowBaseline.setDelay(1000L);
        this.mShowBaseline.setDuration(1000L);
        this.mHideActions.setRepeats(false);
    }

    public void repaint() {
    }

    public void repaint(int x, int y, int w, int h) {
    }

    public void setColorSet(ColorSet colorSet) {
        if (this.mColorSet == colorSet) {
            return;
        }
        this.mColorSet = colorSet;
        if (this.mColorSet == null) {
            return;
        }
        this.mBackgroundColor = new ColorTheme(this.mColorSet.getSubduedBackground(), this.mColorSet.getBackground(), this.mColorSet.getHighlightedBackground(), this.mColorSet.getSelectedBackground());
        this.mFrameColor = new ColorTheme(this.mColorSet.getSubduedFrames(), this.mColorSet.getFrames(), this.mColorSet.getHighlightedFrames(), this.mColorSet.getSelectedFrames());
        this.mTextColor = new ColorTheme(this.mColorSet.getSubduedText(), this.mColorSet.getText(), this.mColorSet.getText(), this.mColorSet.getSelectedText());
        this.mConstraintsColor = new ColorTheme(this.mColorSet.getSubduedConstraints(), this.mColorSet.getConstraints(), this.mColorSet.getHighlightedConstraints(), this.mColorSet.getSelectedConstraints());
    }

    public void setIsVisible(boolean isVisible) {
        this.mIsVisible = isVisible;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setLook(ColorTheme.Look look) {
        this.mLook = look;
    }

    public ColorTheme.Look getLook() {
        return this.mLook;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor.getColor();
    }

    public void onPaintBackground(ViewTransform transform2, Graphics2D g) {
        if (this.mColorSet == null) {
            return;
        }
        if (!this.mColorSet.drawBackground()) {
            return;
        }
        if (this.mWidget.isRoot() || this.mWidget.isRootContainer()) {
            return;
        }
        if (!(this.mWidget instanceof ConstraintWidgetContainer) && this.mWidget.getVisibility() == 0) {
            int l = transform2.getSwingX(this.mWidget.getDrawX());
            int t = transform2.getSwingY(this.mWidget.getDrawY());
            int w = transform2.getSwingDimension(this.mWidget.getDrawWidth());
            int h = transform2.getSwingDimension(this.mWidget.getDrawHeight());
            g.setColor(this.mBackgroundColor.getColor());
            if (this.mBackgroundColor.getLook() != ColorTheme.Look.NORMAL) {
                g.fillRect(l, t, w, h);
            }
            Color bg = new Color(0, 0, 0, 0);
            Color fg = ColorTheme.updateBrightness(this.mBackgroundColor.getColor(), 1.6f);
            Graphics2D gfill = (Graphics2D)g.create();
            gfill.setPaint(new LinearGradientPaint(l, t, l + 2, t + 2, new float[]{0.0f, 0.1f, 0.1001f}, new Color[]{fg, fg, bg}, MultipleGradientPaint.CycleMethod.REFLECT));
            gfill.fillRect(l, t, w, h);
            gfill.dispose();
        }
    }

    public int getStyle() {
        return this.mStyle;
    }

    public void setStyle(int style) {
        this.mStyle = style;
    }

    class AnimationProgress {
        long mStart = 0L;
        long mDelay = 1000L;
        long mDuration = 300L;

        AnimationProgress() {
        }

        public void setDelay(long delay) {
            this.mDelay = delay;
        }

        public void setDuration(long duration) {
            this.mDuration = duration;
        }

        public void start() {
            this.mStart = System.currentTimeMillis() + this.mDelay;
        }

        public float getProgress() {
            if (this.mStart == 0L) {
                return 0.0f;
            }
            long current = System.currentTimeMillis();
            long delta = current - this.mStart;
            if (delta < 0L) {
                return 0.0f;
            }
            if (delta > this.mDuration) {
                return 1.0f;
            }
            return (float)(current - this.mStart) / (float)this.mDuration;
        }

        public boolean isDone() {
            if (this.mStart == 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            long delta = current - this.mStart;
            return delta > this.mDuration;
        }

        public void reset() {
            this.mStart = 0L;
        }

        public boolean isRunning() {
            return this.mStart != 0L && !this.isDone();
        }
    }
}

