/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.transition;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.handlers.assistant.TransitionLayoutAssistantPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.assistant.ComponentAssistant;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSlider;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransitionLayoutHandler
extends ConstraintLayoutHandler {
    @Override
    @Nullable
    public CustomPanel getCustomPanel() {
        return new AnimationPositionPanel();
    }

    @Override
    @Nullable
    public CustomPanel getLayoutCustomPanel() {
        return new AnimationPositionPanel();
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"transitionPosition");
        if (immutableList == null) {
            TransitionLayoutHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public ComponentAssistant.PanelFactory getComponentAssistant(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        if (surface == null) {
            TransitionLayoutHandler.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            TransitionLayoutHandler.$$$reportNull$$$0(2);
        }
        if (!((Boolean)StudioFlags.NELE_TRANSITION_LAYOUT_ANIMATIONS.get()).booleanValue() || !"android.support.constraint.TransitionLayout".equals(component2.getTagName())) {
            return null;
        }
        return (component1, close) -> {
            if (surface == null) {
                TransitionLayoutHandler.$$$reportNull$$$0(3);
            }
            return new TransitionLayoutAssistantPanel(surface, component1, (Function0<Unit>)close);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/transition/TransitionLayoutHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/transition/TransitionLayoutHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAssistant";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getComponentAssistant$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnimationPositionPanel
    extends CustomPanel {
        private NlComponent myComponent;
        private TransitionLayoutComponentHelper myTransitionHandler;

        @Override
        public void useComponent(@NotNull NlComponent component2) {
            if (component2 == null) {
                AnimationPositionPanel.$$$reportNull$$$0(0);
            }
            this.myComponent = component2;
            NlComponent transitionLayoutComponent = null;
            if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.constraint.TransitionLayout")) {
                transitionLayoutComponent = component2;
            } else {
                NlComponent parent = this.myComponent.getParent();
                if (parent != null && NlComponentHelperKt.isOrHasSuperclass(parent, "android.support.constraint.TransitionLayout")) {
                    transitionLayoutComponent = parent;
                }
            }
            this.myTransitionHandler = transitionLayoutComponent != null ? new TransitionLayoutComponentHelper(transitionLayoutComponent) : null;
        }

        AnimationPositionPanel() {
            this.setLayout(new BoxLayout(this, 3));
            this.add(new JLabel("Animation position:"));
            JSlider slider = new JSlider();
            slider.setValue(0);
            slider.setMinimum(0);
            slider.setMaximum(100);
            slider.addChangeListener(e -> {
                if (this.myTransitionHandler == null) {
                    return;
                }
                float value = (float)slider.getValue() / 100.0f;
                this.myTransitionHandler.setValue(value);
            });
            this.add(slider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/transition/TransitionLayoutHandler$AnimationPositionPanel", "useComponent"));
        }
    }

    public static class TransitionLayoutComponentHelper {
        private NlComponent myTransitionLayoutComponent;
        private Method myCallSetTransitionPosition;
        private Method myCallEvaluate;
        private Method myGetMaxTimeMethod;

        public TransitionLayoutComponentHelper(@NotNull NlComponent component2) {
            if (component2 == null) {
                TransitionLayoutComponentHelper.$$$reportNull$$$0(0);
            }
            this.myTransitionLayoutComponent = component2;
        }

        private void setTransitionPosition(Object instance, float position) {
            if (this.myCallSetTransitionPosition == null) {
                try {
                    this.myCallSetTransitionPosition = instance.getClass().getMethod("setTransitionPosition", Float.TYPE);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (this.myCallSetTransitionPosition != null) {
                try {
                    RenderService.runRenderAction(() -> {
                        try {
                            this.myCallSetTransitionPosition.invoke(instance, Float.valueOf(position));
                        }
                        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                            this.myCallSetTransitionPosition = null;
                            e.printStackTrace();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void evaluate(Object instance) {
            if (this.myCallEvaluate == null) {
                try {
                    this.myCallEvaluate = instance.getClass().getMethod("evaluate", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (this.myCallEvaluate != null) {
                try {
                    RenderService.runRenderAction(() -> {
                        try {
                            this.myCallEvaluate.invoke(instance, new Object[0]);
                        }
                        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                            this.myCallEvaluate = null;
                            e.printStackTrace();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void setValue(float value) {
            ViewInfo info = NlComponentHelperKt.getViewInfo(this.myTransitionLayoutComponent);
            if (info == null) {
                return;
            }
            Object instance = info.getViewObject();
            this.setTransitionPosition(instance, value);
            this.evaluate(instance);
            NlModel model = this.myTransitionLayoutComponent.getModel();
            model.notifyLiveUpdate(false);
        }

        public long getMaxTimeMs() {
            ViewInfo info = NlComponentHelperKt.getViewInfo(this.myTransitionLayoutComponent);
            if (info == null) {
                return 0L;
            }
            Object instance = info.getViewObject();
            if (this.myGetMaxTimeMethod == null) {
                try {
                    this.myGetMaxTimeMethod = instance.getClass().getMethod("getTransitionTimeMs", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            if (this.myGetMaxTimeMethod != null) {
                try {
                    return RenderService.runRenderAction(() -> {
                        try {
                            return (long)((Long)this.myGetMaxTimeMethod.invoke(instance, new Object[0]));
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            this.myGetMaxTimeMethod = null;
                            e.printStackTrace();
                            return 0;
                        }
                    }).longValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return 0L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/transition/TransitionLayoutHandler$TransitionLayoutComponentHelper", "<init>"));
        }
    }
}

