/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupFileHelper {
    public static final Set<String> VALID_EXTENSION = new HashSet<String>(Arrays.asList("psd", "png", "jpg"));
    public static final Logger LOGGER = Logger.getInstance(MockupFileHelper.class);
    private static final Map<String, Image> IMAGE_CACHE = ContainerUtil.createWeakMap();

    @Nullable
    public static Image openImageFile(String path) {
        Image image = null;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (IMAGE_CACHE.containsKey(path)) {
            return IMAGE_CACHE.get(path);
        }
        try (FileInputStream in = new FileInputStream(file);){
            image = PixelProbe.probe((InputStream)in, (Decoder.Options)Decoder.Options.LAYER_METADATA_ONLY);
            IMAGE_CACHE.put(path, image);
        }
        catch (IOException e) {
            Logger.getInstance(MockupLayer.class).error((Throwable)e);
        }
        return image;
    }

    @NotNull
    public static FileChooserDescriptor getFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> VALID_EXTENSION.contains(file.getExtension())).withTitle("Choose Mockup File").withDescription("PSD, JPEG, PNG are accepted");
        if (fileChooserDescriptor == null) {
            MockupFileHelper.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor;
    }

    public static void writePositionToXML(@NotNull Mockup mockup) {
        NlComponent component2;
        if (mockup == null) {
            MockupFileHelper.$$$reportNull$$$0(1);
        }
        if ((component2 = mockup.getComponent()) == null) {
            return;
        }
        NlWriteCommandAction.run(component2, "Edit Mockup Crop", () -> {
            if (mockup == null) {
                MockupFileHelper.$$$reportNull$$$0(5);
            }
            if (mockup.isFullScreen()) {
                component2.removeAttribute("http://schemas.android.com/tools", "mockup_crop");
            } else {
                component2.setAttribute("http://schemas.android.com/tools", "mockup_crop", MockupFileHelper.getPositionString(mockup));
            }
        });
    }

    public static String getPositionString(@NotNull Mockup mockup) {
        if (mockup == null) {
            MockupFileHelper.$$$reportNull$$$0(2);
        }
        Rectangle bounds = mockup.getBounds();
        Rectangle crop = mockup.getCropping();
        String cropping = bounds.equals(new Rectangle(0, 0, -1, -1)) ? String.format(Locale.US, "%d %d %d %d", crop.x, crop.y, crop.width, crop.height) : String.format(Locale.US, "%d %d %d %d %d %d %d %d", crop.x, crop.y, crop.width, crop.height, bounds.x, bounds.y, bounds.width, bounds.height);
        return cropping;
    }

    @Nullable
    public static Path getXMLFilePath(@NotNull Project project, @NotNull String filePath) {
        String basePath;
        if (project == null) {
            MockupFileHelper.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            MockupFileHelper.$$$reportNull$$$0(4);
        }
        if ((basePath = project.getBasePath()) == null) {
            return null;
        }
        Path path = null;
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            path = MockupFileHelper.getFullFilePath(project, filePath);
            if (path != null && path.startsWith(projectDirectory)) {
                return projectDirectory.relativize(path).normalize();
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
        }
        return path;
    }

    @Nullable
    public static Path getFullFilePath(Project project, String filePath) {
        String basePath = project.getBasePath();
        if (filePath == null || filePath.isEmpty() || basePath == null) {
            return null;
        }
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!path.isAbsolute()) {
                path = projectDirectory.resolve(path).normalize();
            }
            return path.normalize();
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/MockupFileHelper";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileChooserDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/MockupFileHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writePositionToXML";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPositionString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXMLFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$writePositionToXML$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

