/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.colorextractor;

import com.android.tools.idea.uibuilder.mockup.colorextractor.Clusterer;
import java.util.ArrayList;
import java.util.List;

public class DBSCANClusterer
implements Clusterer {
    private int myVisited = 0;
    private float myEps;
    private int myMinPts;
    private List<List<double[]>> myClusters = new ArrayList<List<double[]>>();
    private PointType[] myPointTypes;
    Clusterer.ProgressListener listener;

    public DBSCANClusterer(float eps, int minPts) {
        this.myEps = eps;
        this.myMinPts = minPts;
    }

    public DBSCANClusterer(float eps, int minPts, Clusterer.ProgressListener listener) {
        this(eps, minPts);
        this.listener = listener;
    }

    @Override
    public List<List<double[]>> cluster(double[][] input) {
        ArrayList<Object> cluster = new ArrayList<double[]>();
        this.myPointTypes = new PointType[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (this.myPointTypes[i] != null || !this.expandCluster(input, i, cluster)) continue;
            if (!cluster.isEmpty()) {
                this.myClusters.add(cluster);
                this.myVisited += cluster.size();
                this.notifyProgress();
            }
            cluster = new ArrayList();
        }
        return this.myClusters;
    }

    private boolean expandCluster(double[][] input, int pointIndex, List<double[]> cluster) {
        List<Integer> seeds = this.regionQuery(input, pointIndex);
        if (seeds.size() < this.myMinPts) {
            this.myPointTypes[pointIndex] = PointType.NOISE;
            for (int i = 0; i < seeds.size(); ++i) {
                this.myPointTypes[seeds.get((int)i).intValue()] = PointType.NOISE;
            }
            return false;
        }
        cluster.add(input[pointIndex]);
        this.myPointTypes[pointIndex] = PointType.CORE;
        for (int i = 0; i < seeds.size(); ++i) {
            cluster.add(input[seeds.get(i)]);
            this.myPointTypes[seeds.get((int)i).intValue()] = PointType.BORDER;
        }
        while (!seeds.isEmpty()) {
            int currentP = seeds.get(0);
            List<Integer> result = this.regionQuery(input, currentP);
            if (result.size() >= this.myMinPts) {
                this.myPointTypes[currentP] = PointType.CORE;
                for (int i = 0; i < result.size(); ++i) {
                    Integer resultP = result.get(i);
                    if (this.myPointTypes[resultP] != null && this.myPointTypes[resultP] != PointType.NOISE) continue;
                    if (this.myPointTypes[resultP] == null) {
                        seeds.add(resultP);
                    }
                    this.myPointTypes[resultP.intValue()] = PointType.BORDER;
                    cluster.add(input[resultP]);
                }
            }
            seeds.remove(0);
        }
        return true;
    }

    private void notifyProgress() {
        if (this.listener != null) {
            this.listener.progress((float)this.myVisited / (float)this.myPointTypes.length);
        }
    }

    private List<Integer> regionQuery(double[][] input, int pointIndex) {
        ArrayList<Integer> seeds = new ArrayList<Integer>();
        double[] current = input[pointIndex];
        for (int i = 0; i < input.length; ++i) {
            float epsSquare = this.myEps * this.myEps;
            if (input[i] == current || !(DBSCANClusterer.distance(input[i], current) <= (double)epsSquare)) continue;
            seeds.add(i);
        }
        return seeds;
    }

    private static double distance(double[] neighbor, double[] point) {
        double squares = 0.0;
        for (int i = 0; i < Math.min(neighbor.length, point.length); ++i) {
            squares += Math.pow(neighbor[i] - point[i], 2.0);
        }
        return squares;
    }

    private static enum PointType {
        NOISE,
        BORDER,
        CORE;

    }
}

