/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor.creators;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.mockup.editor.creators.SimpleViewCreator;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.intellij.openapi.Disposable;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class IncludeTagCreator
extends SimpleViewCreator {
    private String myNewLayoutResource;

    public IncludeTagCreator(@NotNull Mockup mockup, @NotNull NlModel model, @NotNull SceneView screenView, @NotNull Rectangle selection) {
        if (mockup == null) {
            IncludeTagCreator.$$$reportNull$$$0(0);
        }
        if (model == null) {
            IncludeTagCreator.$$$reportNull$$$0(1);
        }
        if (screenView == null) {
            IncludeTagCreator.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            IncludeTagCreator.$$$reportNull$$$0(3);
        }
        super(mockup, model, screenView, selection);
    }

    @Override
    protected void addAttributes(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(4);
        }
        this.myNewLayoutResource = this.createNewIncludedLayout();
        super.addAttributes(transaction);
        if (this.myNewLayoutResource != null) {
            IncludeTagCreator.addIncludeAttribute(transaction, this.myNewLayoutResource);
        }
    }

    @Override
    @NotNull
    public String getAndroidViewTag() {
        if ("include" == null) {
            IncludeTagCreator.$$$reportNull$$$0(5);
        }
        return "include";
    }

    @Override
    public NlComponent addToModel() {
        NlComponent component2 = this.getMockup().getComponent();
        if (NlComponentHelperKt.isOrHasSuperclass(component2, "android.support.v7.widget.RecyclerView")) {
            this.addListItemAttribute(component2);
            return component2;
        }
        return super.addToModel();
    }

    private void addListItemAttribute(NlComponent component2) {
        String newLayoutResource = this.createNewIncludedLayout();
        NlWriteCommandAction.run(component2, "Add listitem attribute", () -> component2.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + newLayoutResource));
    }

    private static void addIncludeAttribute(@NotNull AttributesTransaction transaction, @NotNull String resourceName) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(6);
        }
        if (resourceName == null) {
            IncludeTagCreator.$$$reportNull$$$0(7);
        }
        transaction.setAttribute(null, "layout", "@layout/" + resourceName);
    }

    private String createNewIncludedLayout() {
        ResourceFolderType folderType;
        AndroidFacet facet = this.getMockup().getComponent().getModel().getFacet();
        XmlFile newFile = CreateResourceFileAction.createFileResource(facet, folderType = AndroidResourceUtil.XML_FILE_RESOURCE_TYPES.get(ResourceType.LAYOUT), null, null, null, true, null, null, null, false);
        if (newFile == null) {
            return null;
        }
        XmlTag rootTag = newFile.getRootTag();
        if (rootTag == null) {
            return null;
        }
        final SceneManager manager = this.getScreenView().getSurface().getSceneManager();
        if (manager != null) {
            final NlModel model = NlModel.create((Disposable)newFile.getProject(), facet, newFile.getVirtualFile());
            manager.addRenderListener(new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    manager.removeRenderListener(this);
                    if (model.getComponents().isEmpty()) {
                        return;
                    }
                    NlComponent component2 = (NlComponent)model.getComponents().get(0);
                    AttributesTransaction transaction = component2.startAttributeTransaction();
                    IncludeTagCreator.this.addShowInAttribute(transaction);
                    IncludeTagCreator.this.addSizeAttributes(transaction, IncludeTagCreator.this.getAndroidBounds());
                    IncludeTagCreator.this.addMockupAttributes(transaction, IncludeTagCreator.this.getSelectionBounds());
                    NlWriteCommandAction.run(component2, "", transaction::commit);
                }
            });
        }
        return IncludeTagCreator.getResourceName(newFile);
    }

    @NotNull
    private static String getResourceName(@NotNull XmlFile newFile) {
        if (newFile == null) {
            IncludeTagCreator.$$$reportNull$$$0(8);
        }
        String string = AndroidCommonUtils.getResourceName((String)ResourceType.LAYOUT.getName(), (String)newFile.getName());
        if (string == null) {
            IncludeTagCreator.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void addShowInAttribute(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            IncludeTagCreator.$$$reportNull$$$0(10);
        }
        String showInName = IncludeTagCreator.getResourceName(this.getModel().getFile());
        transaction.setAttribute("http://schemas.android.com/tools", "showIn", "@layout/" + showInName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/mockup/editor/creators/IncludeTagCreator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidViewTag";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAttributes";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addIncludeAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getResourceName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addShowInAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

