/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.project.AndroidProjectBuildNotifications;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ActionMenuViewHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewGroupHandler;
import com.android.tools.idea.uibuilder.handlers.CustomViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceCategoryHandler;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.tools.idea.uibuilder.menu.MenuHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.base.Charsets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;
import icons.StudioIcons;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.xml.bind.JAXBException;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.converters.PackageClassConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPaletteModel
implements Disposable {
    static final String THIRD_PARTY_GROUP = "3rd Party";
    static final String PROJECT_GROUP = "Project";
    private static final Function<Project, Query<PsiClass>> VIEW_CLASSES_QUERY = project -> {
        PsiClass viewClass = JavaPsiFacade.getInstance((Project)project).findClass("android.view.View", GlobalSearchScope.allScope((Project)project));
        if (viewClass == null) {
            return EmptyQuery.getEmptyQuery();
        }
        return ClassInheritorsSearch.search((PsiClass)viewClass, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)true);
    };
    private final Map<NlLayoutType, Palette> myTypeToPalette;
    private final Module myModule;
    private UpdateListener myListener;

    public void dispose() {
        this.myListener = null;
    }

    public static NlPaletteModel get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NlPaletteModel.$$$reportNull$$$0(0);
        }
        return (NlPaletteModel)facet.getModule().getComponent(NlPaletteModel.class);
    }

    private NlPaletteModel(@NotNull Module module) {
        if (module == null) {
            NlPaletteModel.$$$reportNull$$$0(1);
        }
        this.myTypeToPalette = new EnumMap<NlLayoutType, Palette>(NlLayoutType.class);
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
    }

    @NotNull
    public Palette getPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(2);
        }
        assert (type.isSupportedByDesigner());
        Palette palette = this.myTypeToPalette.get((Object)type);
        if (palette == null) {
            this.loadPalette(type);
            Palette palette2 = this.myTypeToPalette.get((Object)type);
            if (palette2 == null) {
                NlPaletteModel.$$$reportNull$$$0(3);
            }
            return palette2;
        }
        Palette palette3 = palette;
        if (palette3 == null) {
            NlPaletteModel.$$$reportNull$$$0(4);
        }
        return palette3;
    }

    public void setUpdateListener(@NotNull UpdateListener updateListener) {
        if (updateListener == null) {
            NlPaletteModel.$$$reportNull$$$0(5);
        }
        this.myListener = updateListener;
    }

    private void loadPalette(@NotNull NlLayoutType type) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(6);
        }
        try {
            Palette palette;
            String metadata = type.getPaletteFileName();
            URL url = NlPaletteModel.class.getResource(metadata);
            URLConnection connection2 = url.openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection2.getInputStream(), Charsets.UTF_8);){
                palette = this.loadPalette(reader, type);
            }
            this.loadAdditionalComponents(type, palette, VIEW_CLASSES_QUERY);
            AndroidProjectBuildNotifications.subscribe(this.myModule.getProject(), this, context -> {
                if (type == null) {
                    NlPaletteModel.$$$reportNull$$$0(30);
                }
                this.loadAdditionalComponents(type, palette, VIEW_CLASSES_QUERY);
            });
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    void loadAdditionalComponents(@NotNull NlLayoutType type, @NotNull Palette palette, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        Project project;
        DumbService dumbService;
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(7);
        }
        if (palette == null) {
            NlPaletteModel.$$$reportNull$$$0(8);
        }
        if (viewClasses == null) {
            NlPaletteModel.$$$reportNull$$$0(9);
        }
        if ((dumbService = DumbService.getInstance((Project)(project = this.myModule.getProject()))).isDumb()) {
            dumbService.runWhenSmart(() -> {
                if (type == null) {
                    NlPaletteModel.$$$reportNull$$$0(27);
                }
                if (palette == null) {
                    NlPaletteModel.$$$reportNull$$$0(28);
                }
                if (viewClasses == null) {
                    NlPaletteModel.$$$reportNull$$$0(29);
                }
                this.loadAdditionalComponents(type, palette, viewClasses);
            });
        } else {
            palette.getItems().stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> PROJECT_GROUP.equals(g.getName()) || THIRD_PARTY_GROUP.equals(g.getName())).map(Palette.Group::getItems).forEach(List::clear);
            this.loadProjectComponents(type, palette, viewClasses);
        }
        UpdateListener listener = this.myListener;
        if (listener != null) {
            ApplicationManager.getApplication().invokeLater(listener::update);
        }
    }

    @NotNull
    public Palette loadPalette(@NotNull Reader reader, @NotNull NlLayoutType type) throws JAXBException {
        if (reader == null) {
            NlPaletteModel.$$$reportNull$$$0(10);
        }
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(11);
        }
        Palette palette = Palette.parse(reader, ViewHandlerManager.get(this.myModule.getProject()));
        this.myTypeToPalette.put(type, palette);
        Palette palette2 = palette;
        if (palette2 == null) {
            NlPaletteModel.$$$reportNull$$$0(12);
        }
        return palette2;
    }

    private void loadProjectComponents(@NotNull NlLayoutType type, @NotNull Palette palette, @NotNull Function<Project, Query<PsiClass>> viewClasses) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(13);
        }
        if (palette == null) {
            NlPaletteModel.$$$reportNull$$$0(14);
        }
        if (viewClasses == null) {
            NlPaletteModel.$$$reportNull$$$0(15);
        }
        Project project = this.myModule.getProject();
        viewClasses.apply(project).forEach(psiClass -> {
            if (type == null) {
                NlPaletteModel.$$$reportNull$$$0(25);
            }
            if (palette == null) {
                NlPaletteModel.$$$reportNull$$$0(26);
            }
            String description = psiClass.getName();
            String tagName = psiClass.getQualifiedName();
            String className = PackageClassConverter.getQualifiedName(psiClass);
            if (description == null || tagName == null || className == null) {
                return false;
            }
            this.addAdditionalComponent(type, PROJECT_GROUP, palette, StudioIcons.LayoutEditor.Palette.CUSTOM_VIEW, StudioIcons.LayoutEditor.Palette.CUSTOM_VIEW_LARGE, tagName, className, null, null, "", null, Collections.emptyList(), Collections.emptyList());
            return true;
        });
    }

    boolean addAdditionalComponent(@NotNull NlLayoutType type, @NotNull String groupName, @NotNull Palette palette, @Nullable Icon icon16, @Nullable Icon icon24, @NotNull String tagName, @NotNull String className, @Nullable @Language(value="XML") String xml, @Nullable @Language(value="XML") String previewXml, @NotNull String libraryCoordinate, @Nullable String preferredProperty, @NotNull List<String> properties, @NotNull List<String> layoutProperties) {
        if (type == null) {
            NlPaletteModel.$$$reportNull$$$0(16);
        }
        if (groupName == null) {
            NlPaletteModel.$$$reportNull$$$0(17);
        }
        if (palette == null) {
            NlPaletteModel.$$$reportNull$$$0(18);
        }
        if (tagName == null) {
            NlPaletteModel.$$$reportNull$$$0(19);
        }
        if (className == null) {
            NlPaletteModel.$$$reportNull$$$0(20);
        }
        if (libraryCoordinate == null) {
            NlPaletteModel.$$$reportNull$$$0(21);
        }
        if (properties == null) {
            NlPaletteModel.$$$reportNull$$$0(22);
        }
        if (layoutProperties == null) {
            NlPaletteModel.$$$reportNull$$$0(23);
        }
        if (tagName.indexOf(46) < 0 || !NlComponentHelper.INSTANCE.viewClassToTag(tagName).equals(tagName) || tagName.equals("android.support.constraint.ConstraintLayout")) {
            return false;
        }
        ViewHandlerManager manager = ViewHandlerManager.get(this.myModule.getProject());
        ViewHandler handler = manager.createBuiltInHandler(tagName);
        if (type != NlLayoutType.LAYOUT || handler instanceof PreferenceHandler || handler instanceof PreferenceCategoryHandler || handler instanceof MenuHandler || handler instanceof ActionMenuViewHandler) {
            return false;
        }
        if (handler == null) {
            handler = manager.getHandlerOrDefault(tagName);
            if (type != NlLayoutType.LAYOUT || handler instanceof PreferenceHandler || handler instanceof PreferenceCategoryHandler || handler instanceof MenuHandler || handler instanceof ActionMenuViewHandler) {
                return false;
            }
            handler = handler instanceof ViewGroupHandler ? new CustomViewGroupHandler((ViewGroupHandler)handler, icon16, icon24, tagName, className, xml, previewXml, libraryCoordinate, preferredProperty, properties, layoutProperties) : new CustomViewHandler(handler, icon16, icon24, tagName, className, xml, previewXml, libraryCoordinate, preferredProperty, properties);
        }
        manager.registerHandler(tagName, handler);
        List<Palette.BaseItem> groups = palette.getItems();
        Palette.Group group = groups.stream().filter(Palette.Group.class::isInstance).map(Palette.Group.class::cast).filter(g -> {
            if (groupName == null) {
                NlPaletteModel.$$$reportNull$$$0(24);
            }
            return groupName.equals(g.getName());
        }).findFirst().orElse(null);
        if (group == null) {
            group = new Palette.Group(groupName);
            groups.add(group);
        }
        Palette.Item item = new Palette.Item(tagName, handler);
        group.getItems().add(item);
        item.setUp(palette, manager);
        item.setParent(group);
        return true;
    }

    private static Logger getLogger() {
        return Logger.getLogger(NlPaletteModel.class.getSimpleName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateListener";
                break;
            }
            case 8: 
            case 14: 
            case 18: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "palette";
                break;
            }
            case 9: 
            case 15: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewClasses";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryCoordinate";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPaletteModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPalette";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPalette";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPalette";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateListener";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadPalette";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalComponents";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectComponents";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalComponent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdditionalComponent$5";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadProjectComponents$4";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadAdditionalComponents$2";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$loadPalette$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UpdateListener {
        public void update();
    }
}

