/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DecoratorUtilities {
    public static final String VIEW = "view";
    public static final String TOP_CONNECTION = "north";
    public static final String LEFT_CONNECTION = "left";
    public static final String RIGHT_CONNECTION = "right";
    public static final String BOTTOM_CONNECTION = "bottom";
    public static final String BASELINE_CONNECTION = "baseline";
    private static final String MODE_SUFFIX = "_mode";
    private static final String PREV_SUFFIX = "_prev";
    private static final String TIME_SUFFIX = "_time";
    private static final String TRY_TO_CONNECT = "trying_to_connect";
    public static int MASK_TOP = 1;
    public static int MASK_BOTTOM = 2;
    public static int MASK_LEFT = 4;
    public static int MASK_RIGHT = 8;
    public static int MASK_BASELINE = 16;

    public static ViewStates mapState(SceneComponent.DrawState sState) {
        switch (sState) {
            case SUBDUED: {
                return ViewStates.SUBDUED;
            }
            case HOVER: {
                return ViewStates.HOVER;
            }
            case SELECTED: {
                return ViewStates.SELECTED;
            }
            case DRAG: {
                return ViewStates.DRAG;
            }
        }
        return ViewStates.NORMAL;
    }

    public static void setTimeChange(NlComponent component2, String type, long time2, ViewStates from, ViewStates to) {
        component2.putClientProperty(type + MODE_SUFFIX, (Object)to);
        component2.putClientProperty(type + PREV_SUFFIX, (Object)from);
        component2.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static void setTimeChange(NlComponent component2, String type, ViewStates from, ViewStates to) {
        long time2 = System.nanoTime();
        component2.putClientProperty(type + MODE_SUFFIX, (Object)to);
        component2.putClientProperty(type + PREV_SUFFIX, (Object)from);
        component2.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static void setTimeChange(NlComponent component2, String type, ViewStates to) {
        long time2 = System.nanoTime();
        component2.putClientProperty(type + MODE_SUFFIX, (Object)to);
        ViewStates from = (ViewStates)((Object)component2.getClientProperty(type + MODE_SUFFIX));
        if (from == null) {
            from = ViewStates.NORMAL;
        }
        component2.putClientProperty(type + PREV_SUFFIX, (Object)from);
        component2.putClientProperty(type + TIME_SUFFIX, time2);
    }

    public static ViewStates getTimedChange_prev(NlComponent component2, String type) {
        return (ViewStates)((Object)component2.getClientProperty(type + PREV_SUFFIX));
    }

    public static ViewStates getTimedChange_value(NlComponent component2, String type) {
        return (ViewStates)((Object)component2.getClientProperty(type + MODE_SUFFIX));
    }

    public static Long getTimedChange_time(NlComponent component2, String type) {
        return (Long)component2.getClientProperty(type + TIME_SUFFIX);
    }

    static HashSet<String> getConnected(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<String> set = new HashSet<String>();
        String id = c.getId();
        if (id == null) {
            return set;
        }
        set.add(id);
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                for (int i = 0; i < list.length; ++i) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i]);
                    if (!set.contains(str)) continue;
                    set.add(sister.getId());
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    public static void setTryingToConnectState(NlComponent component2, AnchorTarget.Type type, boolean on) {
        block10: {
            List<NlComponent> sisters;
            block9: {
                sisters = component2.getParent().getChildren();
                String id = component2.getId();
                if (!on) break block9;
                component2.putClientProperty(TRY_TO_CONNECT, 0);
                switch (type) {
                    case TOP: 
                    case BOTTOM: {
                        Integer mask = MASK_TOP | MASK_BOTTOM;
                        HashSet<String> connected = DecoratorUtilities.getConnected(component2, sisters, ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes);
                        for (NlComponent sister : sisters) {
                            if (sister == component2 || connected.contains(sister.getId())) continue;
                            sister.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break block10;
                    }
                    case RIGHT: 
                    case LEFT: {
                        Integer mask = MASK_LEFT | MASK_RIGHT;
                        HashSet<String> connected = DecoratorUtilities.getConnected(component2, sisters, ConstraintComponentUtilities.ourRightAttributes, ConstraintComponentUtilities.ourLeftAttributes, ConstraintComponentUtilities.ourStartAttributes, ConstraintComponentUtilities.ourEndAttributes);
                        for (NlComponent sister : sisters) {
                            if (sister == component2 || connected.contains(sister.getId())) continue;
                            sister.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break block10;
                    }
                    case BASELINE: {
                        System.out.println(BASELINE_CONNECTION);
                        Integer mask = MASK_BASELINE;
                        HashSet<String> connected = DecoratorUtilities.getConnected(component2, sisters, ConstraintComponentUtilities.ourBottomAttributes, ConstraintComponentUtilities.ourTopAttributes, ConstraintComponentUtilities.ourBaselineAttributes);
                        for (NlComponent sister : sisters) {
                            if (sister == component2 || connected.contains(sister.getId())) continue;
                            sister.putClientProperty(TRY_TO_CONNECT, mask);
                        }
                        break;
                    }
                }
                break block10;
            }
            for (NlComponent sister : sisters) {
                sister.removeClientProperty(TRY_TO_CONNECT);
            }
        }
    }

    public static Integer getTryingToConnectState(NlComponent component2) {
        return (Integer)component2.getClientProperty(TRY_TO_CONNECT);
    }

    public static enum ViewStates {
        NORMAL(0),
        SUBDUED(1),
        SELECTED(2),
        HOVER(3),
        TARGETED(4),
        SECONDARY(5),
        WILL_DESTROY(6),
        INFERRED(7),
        DRAG(8);

        public static final int NORMAL_VALUE = 0;
        public static final int SUBDUED_VALUE = 1;
        public static final int SELECTED_VALUE = 2;
        public static final int HOVER_VALUE = 3;
        public static final int TARGETED_VALUE = 4;
        public static final int SECONDARY_VALUE = 5;
        public static final int WILL_DESTROY_VALUE = 6;
        public static final int INFERRED_VALUE = 7;
        public static final int DRAG_VALUE = 8;
        private final int val;

        private ViewStates(int v) {
            this.val = v;
        }

        public int getVal() {
            return this.val;
        }
    }
}

