/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.actions.ComponentHelpAction;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEvent;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeModel;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.android.tools.idea.uibuilder.structure.NlTreeBadgeHandler;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.android.tools.idea.uibuilder.structure.StructureTreeDecorator;
import com.android.tools.idea.uibuilder.structure.TreeTransferHandler;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponentTree
extends Tree
implements DesignSurfaceListener,
ModelListener,
SelectionListener,
Disposable,
DataProvider {
    private static final Insets INSETS = new JBInsets(0, 6, 0, 6);
    private static final Color LINE_COLOR = ColorUtil.brighter((Color)UIUtil.getTreeSelectionBackground(), (int)10);
    private final AtomicBoolean mySelectionIsUpdating;
    private final MergingUpdateQueue myUpdateQueue;
    private final NlTreeBadgeHandler myBadgeHandler;
    @Nullable
    private NlModel myModel;
    private boolean mySkipWait;
    private int myInsertAfterRow;
    private int myRelativeDepthToInsertionRow;
    @Nullable
    private Rectangle myInsertionRowBounds;
    @Nullable
    private Rectangle myInsertionReceiverBounds;
    @Nullable
    private NlDesignSurface mySurface;

    public NlComponentTree(@NotNull Project project, @Nullable NlDesignSurface designSurface) {
        if (project == null) {
            NlComponentTree.$$$reportNull$$$0(0);
        }
        this.myInsertAfterRow = -1;
        this.myRelativeDepthToInsertionRow = 0;
        this.mySelectionIsUpdating = new AtomicBoolean(false);
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.structure-pane", 250, true, null, null, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myBadgeHandler = new NlTreeBadgeHandler();
        this.setModel(new NlComponentTreeModel());
        this.setBorder(new EmptyBorder(INSETS));
        this.setDesignSurface(designSurface);
        this.setName("componentTree");
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setToggleClickCount(2);
        this.setCellRenderer((TreeCellRenderer)this.createCellRenderer());
        this.getSelectionModel().setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.addTreeSelectionListener(new StructurePaneSelectionListener());
        new StructureSpeedSearch(this);
        this.enableDnD();
        this.addMouseListener(new StructurePaneMouseListener());
        this.addMouseListener(this.myBadgeHandler.getBadgeMouseAdapter());
        this.addMouseMotionListener(this.myBadgeHandler.getBadgeMouseAdapter());
        ComponentHelpAction help = new ComponentHelpAction(project, () -> {
            List<NlComponent> components = this.getSelectedComponents();
            return !components.isEmpty() ? components.get(0).getTagName() : null;
        });
        help.registerCustomShortcutSet(112, 1, (JComponent)((Object)this));
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new TreeTransferHandler());
            this.setDropTarget(new DropTarget((Component)((Object)this), new NlDropListener(this)));
        }
    }

    public void setDesignSurface(@Nullable NlDesignSurface designSurface) {
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().addListener(this);
            this.mySurface.getActionManager().registerActionsShortcuts((JComponent)((Object)this));
            this.mySurface.getActionManager().registerActionsShortcuts((JComponent)((Object)this));
        }
        this.setModel(designSurface != null ? designSurface.getModel() : null);
        this.myBadgeHandler.setIssuePanel(designSurface != null ? designSurface.getIssuePanel() : null);
    }

    @Nullable
    public Scene getScene() {
        return this.mySurface != null ? this.mySurface.getScene() : null;
    }

    private void setModel(@Nullable NlModel model) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
        }
        this.myModel = model;
        this.myBadgeHandler.setNlModel(this.myModel);
        if (this.myModel != null) {
            this.myModel.addListener(this);
        }
        this.updateHierarchy();
    }

    @Nullable
    public NlModel getDesignerModel() {
        return this.myModel;
    }

    public void dispose() {
        if (this.mySurface != null) {
            this.mySurface.getSelectionModel().removeListener(this);
        }
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel = null;
        }
        Disposer.dispose((Disposable)this.myUpdateQueue);
    }

    private ColoredTreeCellRenderer createCellRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 10));
                if (value instanceof NlComponent) {
                    StructureTreeDecorator.decorate((ColoredTextContainer)this, (NlComponent)value, tree.hasFocus() && selected);
                } else if (value instanceof String) {
                    StructureTreeDecorator.decorate((ColoredTextContainer)this, (String)value);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$1", "customizeCellRenderer"));
            }
        };
    }

    private void invalidateUI() {
        IJSwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void updateHierarchy() {
        this.clearInsertionPoint();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdateQueue.queue(new Update("updateComponentStructure"){

            public void run() {
                try {
                    if (NlComponentTree.this.myModel == null) {
                        return;
                    }
                    NlComponentTree.this.mySelectionIsUpdating.set(true);
                    Collection components = NlComponentTree.this.getCollapsedComponents();
                    NlComponentTree.this.setModel(new NlComponentTreeModel(NlComponentTree.this.myModel));
                    NlComponentTree.this.collapseComponents(components);
                    NlComponentTree.this.invalidateUI();
                }
                finally {
                    NlComponentTree.this.mySelectionIsUpdating.set(false);
                }
                NlComponentTree.this.updateSelection();
            }
        });
        if (this.mySkipWait) {
            this.mySkipWait = false;
            this.myUpdateQueue.flush();
        }
    }

    @NotNull
    private Collection<NlComponent> getCollapsedComponents() {
        int rowCount = this.getRowCount();
        HashSet components = Sets.newHashSetWithExpectedSize((int)rowCount);
        for (int row = 0; row < rowCount; ++row) {
            NlComponent component2;
            Object last;
            if (!this.isCollapsed(row) || !((last = this.getPathForRow(row).getLastPathComponent()) instanceof NlComponent) || (component2 = (NlComponent)last).getChildCount() == 0) continue;
            components.add(component2);
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            NlComponentTree.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private void collapseComponents(@NotNull Collection<NlComponent> components) {
        NlComponent root;
        if (components == null) {
            NlComponentTree.$$$reportNull$$$0(2);
        }
        if ((root = (NlComponent)this.getModel().getRoot()) == null) {
            return;
        }
        this.expandAll(root);
        components.forEach(component2 -> this.collapsePath(NlComponentTree.newTreePath(component2)));
    }

    private void expandAll(@NotNull NlComponent parent) {
        if (parent == null) {
            NlComponentTree.$$$reportNull$$$0(3);
        }
        if (parent.getChildren().stream().allMatch(child -> child.getChildCount() == 0)) {
            this.expandPath(NlComponentTree.newTreePath(parent));
        } else {
            parent.getChildren().forEach(this::expandAll);
        }
    }

    void skipNextUpdateDelay() {
        this.mySkipWait = true;
    }

    private void updateSelection() {
        if (!this.mySelectionIsUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.clearSelection();
            if (this.mySurface != null) {
                for (NlComponent component2 : this.mySurface.getSelectionModel().getSelection()) {
                    this.addSelectionPath(NlComponentTree.newTreePath(component2));
                }
            }
        }
        finally {
            this.mySelectionIsUpdating.set(false);
        }
    }

    @NotNull
    private static TreePath newTreePath(@NotNull NlComponent component2) {
        if (component2 == null) {
            NlComponentTree.$$$reportNull$$$0(4);
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>();
        components.add(component2);
        for (NlComponent parent = component2.getParent(); parent != null; parent = parent.getParent()) {
            components.add(parent);
        }
        Collections.reverse(components);
        TreePath treePath = new TreePath(components.toArray());
        if (treePath == null) {
            NlComponentTree.$$$reportNull$$$0(5);
        }
        return treePath;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myInsertAfterRow >= 0) {
            this.paintInsertionPoint((Graphics2D)g);
        }
        this.myBadgeHandler.paintBadges((Graphics2D)g, (JTree)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintInsertionPoint(@NotNull Graphics2D g2D) {
        if (g2D == null) {
            NlComponentTree.$$$reportNull$$$0(6);
        }
        if (this.myInsertionReceiverBounds == null || this.myInsertionRowBounds == null) {
            return;
        }
        RenderingHints savedHints = g2D.getRenderingHints();
        Color savedColor = g2D.getColor();
        try {
            g2D.setColor(LINE_COLOR);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            NlComponentTree.paintInsertionRectangle(g2D, this.getX(), this.myInsertionReceiverBounds.y, this.getWidth(), this.myInsertionReceiverBounds.height);
            NlComponentTree.paintColumnLine(g2D, this.myInsertionReceiverBounds.x, this.myInsertionReceiverBounds.y + this.myInsertionReceiverBounds.height, this.myInsertionRowBounds.y + this.myInsertionRowBounds.height);
            NlComponentTree.paintInsertionLine(g2D, this.myInsertionReceiverBounds.x, this.myInsertionRowBounds.y + this.myInsertionRowBounds.height, this.getWidth());
        }
        finally {
            g2D.setRenderingHints(savedHints);
            g2D.setColor(savedColor);
        }
    }

    private static void paintInsertionLine(@NotNull Graphics2D g, int x, int y, int width) {
        if (g == null) {
            NlComponentTree.$$$reportNull$$$0(7);
        }
        Polygon triangle = new Polygon();
        int indicatorSize = JBUI.scale((int)6);
        triangle.addPoint(x + indicatorSize, y);
        triangle.addPoint(x, y + indicatorSize / 2);
        triangle.addPoint(x, y - indicatorSize / 2);
        Stroke stroke = g.getStroke();
        g.drawLine(x, y, x + width, y);
        g.setStroke(stroke);
        g.drawPolygon(triangle);
        g.fillPolygon(triangle);
    }

    private static void paintColumnLine(@NotNull Graphics2D g, int x, int y1, int y2) {
        if (g == null) {
            NlComponentTree.$$$reportNull$$$0(8);
        }
        int columnMargin = JBUI.scale((int)13);
        Stroke stroke = g.getStroke();
        g.setStroke(NlConstants.DASHED_STROKE);
        g.drawLine(x -= columnMargin, y1, x, y2);
        g.drawLine(x, y2, x + columnMargin, y2);
        g.setStroke(stroke);
    }

    private static void paintInsertionRectangle(@NotNull Graphics2D g, int x, int y, int width, int height) {
        if (g == null) {
            NlComponentTree.$$$reportNull$$$0(9);
        }
        g.drawRect(x += JBUI.scale((int)1), y += JBUI.scale((int)1), width -= JBUI.scale((int)3), height -= JBUI.scale((int)4));
    }

    public void markInsertionPoint(int row, int relativeDepth) {
        if (row == this.myInsertAfterRow && relativeDepth == this.myRelativeDepthToInsertionRow) {
            return;
        }
        if (row < 0) {
            this.clearInsertionPoint();
            return;
        }
        this.myInsertAfterRow = row;
        this.myRelativeDepthToInsertionRow = relativeDepth;
        this.myInsertionReceiverBounds = this.myInsertionRowBounds = this.getRowBounds(this.myInsertAfterRow);
        if (this.myRelativeDepthToInsertionRow < 1) {
            TreePath receiverPath = this.getPathForRow(this.myInsertAfterRow);
            for (int i = this.myRelativeDepthToInsertionRow; i < 1 && receiverPath != null; receiverPath = receiverPath.getParentPath(), ++i) {
            }
            if (receiverPath != null) {
                this.myInsertionReceiverBounds = this.getPathBounds(receiverPath);
            }
        }
        this.repaint();
    }

    public void clearInsertionPoint() {
        this.myInsertionReceiverBounds = null;
        this.myInsertionRowBounds = null;
        this.myInsertAfterRow = -1;
        this.myRelativeDepthToInsertionRow = 0;
        this.repaint();
    }

    protected void clearToggledPaths() {
        super.clearToggledPaths();
    }

    @NotNull
    public List<NlComponent> getSelectedComponents() {
        ArrayList<NlComponent> selected = new ArrayList<NlComponent>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Object last = path.getLastPathComponent();
                if (!(last instanceof NlComponent)) continue;
                selected.add((NlComponent)last);
            }
        }
        ArrayList<NlComponent> arrayList = selected;
        if (arrayList == null) {
            NlComponentTree.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(11);
        }
        if (selection == null) {
            NlComponentTree.$$$reportNull$$$0(12);
        }
        UIUtil.invokeLaterIfNeeded(this::updateSelection);
    }

    @Override
    public void modelDerivedDataChanged(@NotNull NlModel model) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(13);
        }
        UIUtil.invokeLaterIfNeeded(this::updateHierarchy);
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(14);
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(15);
        }
        this.setModel(model);
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component2) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(16);
        }
        if (component2 == null) {
            NlComponentTree.$$$reportNull$$$0(17);
        }
        return false;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            NlComponentTree.$$$reportNull$$$0(18);
        }
        return this.mySurface == null ? null : this.mySurface.getData(dataId);
    }

    private void deleteNonNlComponent(TreePath[] selectedPath) {
        Object component2;
        TreePath parent = NlTreeUtil.getUniqueParent(selectedPath);
        if (parent != null && (component2 = parent.getLastPathComponent()) instanceof NlComponent) {
            NlTreeUtil.delegateEvent(DelegatedTreeEvent.Type.DELETE, this, (NlComponent)component2, -1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlComponentTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2D";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlComponentTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collapseComponents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newTreePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintInsertionPoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "paintInsertionLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paintColumnLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintInsertionRectangle";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "modelDerivedDataChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StructureSpeedSearch
    extends TreeSpeedSearch {
        StructureSpeedSearch(@NotNull NlComponentTree tree) {
            if (tree == null) {
                StructureSpeedSearch.$$$reportNull$$$0(0);
            }
            super((JTree)((Object)tree));
        }

        protected boolean isMatchingElement(Object element, String pattern) {
            if (pattern == null) {
                return false;
            }
            Object component2 = ((TreePath)element).getLastPathComponent();
            return this.compare(component2 instanceof NlComponent ? StructureTreeDecorator.toString((NlComponent)component2) : "", pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$StructureSpeedSearch", "<init>"));
        }
    }

    private class StructurePaneSelectionListener
    implements TreeSelectionListener {
        private StructurePaneSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!NlComponentTree.this.mySelectionIsUpdating.compareAndSet(false, true)) {
                return;
            }
            try {
                if (NlComponentTree.this.mySurface != null) {
                    NlComponentTree.this.mySurface.getSelectionModel().setSelection(NlComponentTree.this.getSelectedComponents());
                }
            }
            finally {
                NlComponentTree.this.mySelectionIsUpdating.set(false);
            }
        }
    }

    private class StructurePaneMouseListener
    extends MouseAdapter {
        private StructurePaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.handleDoubleClick(e);
            } else {
                this.handlePopup(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            Object component2;
            TreePath path;
            if (e.isPopupTrigger() && (path = NlComponentTree.this.getPathForLocation(e.getX(), e.getY())) != null && NlComponentTree.this.mySurface != null && (component2 = path.getLastPathComponent()) instanceof NlComponent) {
                NlComponentTree.this.mySurface.getActionManager().showPopup(e, (NlComponent)component2);
            }
        }

        private void handleDoubleClick(@NotNull MouseEvent event) {
            int y;
            int x;
            TreePath path;
            if (event == null) {
                StructurePaneMouseListener.$$$reportNull$$$0(0);
            }
            if ((path = NlComponentTree.this.getPathForLocation(x = event.getX(), y = event.getY())) == null || NlComponentTree.this.mySurface == null) {
                return;
            }
            Object component2 = path.getLastPathComponent();
            if (!(component2 instanceof NlComponent)) {
                return;
            }
            ViewHandler handler = NlComponentHelperKt.getViewHandler((NlComponent)component2);
            if (handler != null) {
                handler.onActivateInComponentTree((NlComponent)component2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlComponentTree$StructurePaneMouseListener", "handleDoubleClick"));
        }
    }
}

