/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.adaptiveicon.ShapeMenuAction;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.ConstraintsLayer;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Lists;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDesignSurface
extends DesignSurface {
    @NotNull
    private static SceneMode ourDefaultSceneMode = SceneMode.Companion.loadPreferredMode();
    @NotNull
    private SceneMode mySceneMode;
    private int myScreenX;
    private int myScreenY;
    private boolean myIsCanvasResizing;
    private boolean myStackVertically;
    private boolean myMockupVisible;
    private MockupEditor myMockupEditor;
    private boolean myCentered;
    private final boolean myInPreview;
    private ShapeMenuAction.AdaptiveIconShape myAdaptiveIconShape;

    public NlDesignSurface(@NotNull Project project, boolean inPreview, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NlDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NlDesignSurface.$$$reportNull$$$0(1);
        }
        super(project, parentDisposable);
        this.mySceneMode = ourDefaultSceneMode;
        this.myScreenX = 70;
        this.myScreenY = 70;
        this.myIsCanvasResizing = false;
        this.myAdaptiveIconShape = ShapeMenuAction.AdaptiveIconShape.getDefaultShape();
        this.myInPreview = inPreview;
    }

    public boolean isPreviewSurface() {
        return this.myInPreview;
    }

    public void setResizeMode(boolean isResizing) {
        this.myIsCanvasResizing = isResizing;
    }

    public boolean isCanvasResizing() {
        return this.myIsCanvasResizing;
    }

    @Override
    public boolean isLayoutDisabled() {
        return this.myIsCanvasResizing;
    }

    @NotNull
    public SceneMode getSceneMode() {
        SceneMode sceneMode = this.mySceneMode;
        if (sceneMode == null) {
            NlDesignSurface.$$$reportNull$$$0(2);
        }
        return sceneMode;
    }

    public void setScreenMode(@NotNull SceneMode sceneMode, boolean setAsDefault) {
        if (sceneMode == null) {
            NlDesignSurface.$$$reportNull$$$0(3);
        }
        if (setAsDefault && ourDefaultSceneMode != sceneMode) {
            ourDefaultSceneMode = sceneMode;
            SceneMode.Companion.savePreferredMode(sceneMode);
        }
        if (sceneMode != this.mySceneMode) {
            this.mySceneMode = sceneMode;
            LayoutlibSceneManager manager = this.getSceneManager();
            if (manager != null) {
                manager.updateSceneView();
                manager.requestLayoutAndRender(false);
            }
            if (!this.contentResizeSkipped()) {
                this.zoomToFit();
            }
            this.updateScrolledAreaSize();
            this.repaint();
        }
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        if (model == null) {
            NlDesignSurface.$$$reportNull$$$0(4);
        }
        LayoutlibSceneManager layoutlibSceneManager = new LayoutlibSceneManager(model, this);
        if (layoutlibSceneManager == null) {
            NlDesignSurface.$$$reportNull$$$0(5);
        }
        return layoutlibSceneManager;
    }

    @Override
    @Nullable
    public LayoutlibSceneManager getSceneManager() {
        return (LayoutlibSceneManager)super.getSceneManager();
    }

    public void forceLayersPaint(boolean value) {
        for (Layer layer : this.getLayers()) {
            if (layer instanceof ConstraintsLayer) {
                ConstraintsLayer constraintsLayer = (ConstraintsLayer)layer;
                constraintsLayer.setTemporaryShow(value);
                this.repaint();
            }
            if (!(layer instanceof SceneLayer)) continue;
            SceneLayer sceneLayer = (SceneLayer)layer;
            sceneLayer.setTemporaryShow(value);
            this.repaint();
        }
    }

    @Override
    @Nullable
    public SceneView getSceneView(int x, int y) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView primarySceneView = manager != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (secondarySceneView != null && x >= secondarySceneView.getX() && y >= secondarySceneView.getY()) {
            return secondarySceneView;
        }
        return primarySceneView;
    }

    @Override
    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView primarySceneView = manager != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (secondarySceneView != null && x >= secondarySceneView.getX() && x <= secondarySceneView.getX() + secondarySceneView.getSize().width && y >= secondarySceneView.getY() && y <= secondarySceneView.getY() + secondarySceneView.getSize().height) {
            return secondarySceneView;
        }
        if (primarySceneView != null && x >= primarySceneView.getX() && x <= primarySceneView.getX() + primarySceneView.getSize().width && y >= primarySceneView.getY() && y <= primarySceneView.getY() + primarySceneView.getSize().height) {
            return primarySceneView;
        }
        return null;
    }

    @Override
    public Dimension getScrolledAreaSize() {
        SceneView primarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView sceneView = primarySceneView = manager != null ? manager.getSceneView() : null;
        if (primarySceneView == null) {
            return null;
        }
        Dimension size = primarySceneView.getSize();
        Dimension dimension2 = new Dimension(size.width + 100, size.height + 100);
        if (this.mySceneMode == SceneMode.BOTH) {
            if (this.isStackVertically()) {
                dimension2.setSize(dimension2.getWidth(), dimension2.getHeight() + (double)size.height + 10.0);
            } else {
                dimension2.setSize(dimension2.getWidth() + (double)size.width + 10.0, dimension2.getHeight());
            }
        }
        return dimension2;
    }

    public void setAdaptiveIconShape(@NotNull ShapeMenuAction.AdaptiveIconShape adaptiveIconShape) {
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(6);
        }
        this.myAdaptiveIconShape = adaptiveIconShape;
    }

    @NotNull
    public ShapeMenuAction.AdaptiveIconShape getAdaptiveIconShape() {
        ShapeMenuAction.AdaptiveIconShape adaptiveIconShape = this.myAdaptiveIconShape;
        if (adaptiveIconShape == null) {
            NlDesignSurface.$$$reportNull$$$0(7);
        }
        return adaptiveIconShape;
    }

    private static boolean isVerticalScreenConfig(int availableWidth, int availableHeight, @NotNull Dimension preferredSize) {
        boolean stackVertically;
        if (preferredSize == null) {
            NlDesignSurface.$$$reportNull$$$0(8);
        }
        boolean bl = stackVertically = preferredSize.width > preferredSize.height;
        if (availableWidth > 10 && availableHeight > 3 * availableWidth / 2) {
            stackVertically = true;
        }
        return stackVertically;
    }

    public void setCentered(boolean centered) {
        this.myCentered = centered;
    }

    @Override
    public float getSceneScalingFactor() {
        Configuration configuration = this.getConfiguration();
        if (configuration != null) {
            return (float)configuration.getDensity().getDpiValue() / 160.0f;
        }
        return 1.0f;
    }

    @Override
    public float getScreenScalingFactor() {
        return SystemInfo.isMac && UIUtil.isRetina() ? 2.0f : 1.0f;
    }

    @NotNull
    protected NlActionManager createActionManager() {
        NlActionManager nlActionManager = new NlActionManager(this);
        if (nlActionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(9);
        }
        return nlActionManager;
    }

    @Override
    @NotNull
    public NlActionManager getActionManager() {
        NlActionManager nlActionManager = (NlActionManager)super.getActionManager();
        if (nlActionManager == null) {
            NlDesignSurface.$$$reportNull$$$0(10);
        }
        return nlActionManager;
    }

    @Override
    protected void layoutContent() {
        SceneView primarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView sceneView = primarySceneView = manager != null ? manager.getSceneView() : null;
        if (primarySceneView == null) {
            return;
        }
        Dimension screenViewSize = primarySceneView.getSize();
        int availableWidth = this.myScrollPane.getWidth();
        int availableHeight = this.myScrollPane.getHeight();
        this.myStackVertically = NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, screenViewSize);
        if (!this.myIsCanvasResizing) {
            if (this.myCentered && availableWidth > 10 && availableHeight > 10) {
                int requiredWidth = screenViewSize.width;
                if (this.mySceneMode == SceneMode.BOTH && !this.myStackVertically) {
                    requiredWidth += 10;
                    requiredWidth += screenViewSize.width;
                }
                this.myScreenX = Math.max((availableWidth - requiredWidth) / 2, 70);
                int requiredHeight = screenViewSize.height;
                if (this.mySceneMode == SceneMode.BOTH && this.myStackVertically) {
                    requiredHeight += 10;
                    requiredHeight += screenViewSize.height;
                }
                this.myScreenY = Math.max((availableHeight - requiredHeight) / 2, 70);
            } else {
                this.myScreenX = 70;
                this.myScreenY = 70;
            }
        }
        SceneView secondarySceneView = manager.getSecondarySceneView();
        primarySceneView.setLocation(this.myScreenX, this.myScreenY);
        if (secondarySceneView != null) {
            if (this.myStackVertically) {
                secondarySceneView.setLocation(this.myScreenX, this.myScreenY + screenViewSize.height + 10);
            } else {
                secondarySceneView.setLocation(this.myScreenX + screenViewSize.width + 10, this.myScreenY);
            }
        }
        manager.getScene().needsRebuildList();
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getContentOriginX() {
        return this.myScreenX;
    }

    @Override
    public int getContentOriginY() {
        return this.myScreenY;
    }

    public boolean isStackVertically() {
        return this.myStackVertically;
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension2) {
        SceneView secondarySceneView;
        LayoutlibSceneManager manager;
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        SceneView primarySceneView = (manager = this.getSceneManager()) != null ? manager.getSceneView() : null;
        SceneView sceneView = secondarySceneView = manager != null ? manager.getSecondarySceneView() : null;
        if (this.mySceneMode == SceneMode.BOTH && primarySceneView != null && secondarySceneView != null) {
            if (this.isStackVertically()) {
                dimension2.setSize(primarySceneView.getSize().getWidth(), primarySceneView.getSize().getHeight() + secondarySceneView.getSize().getHeight());
            } else {
                dimension2.setSize(primarySceneView.getSize().getWidth() + secondarySceneView.getSize().getWidth(), primarySceneView.getSize().getHeight());
            }
        } else if (this.getCurrentSceneView() != null) {
            dimension2.setSize(this.getCurrentSceneView().getSize().getWidth(), this.getCurrentSceneView().getSize().getHeight());
        }
        Dimension dimension3 = dimension2;
        if (dimension3 == null) {
            NlDesignSurface.$$$reportNull$$$0(11);
        }
        return dimension3;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(120, 120);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView primarySceneView;
        LayoutlibSceneManager manager = this.getSceneManager();
        SceneView sceneView = primarySceneView = manager != null ? manager.getSceneView() : null;
        if (primarySceneView == null) {
            JBDimension jBDimension = JBUI.emptySize();
            if (jBDimension == null) {
                NlDesignSurface.$$$reportNull$$$0(12);
            }
            return jBDimension;
        }
        Dimension preferredSize = primarySceneView.getPreferredSize();
        int requiredWidth = preferredSize.width;
        int requiredHeight = preferredSize.height;
        if (this.mySceneMode == SceneMode.BOTH) {
            if (NlDesignSurface.isVerticalScreenConfig(availableWidth, availableHeight, preferredSize)) {
                requiredHeight *= 2;
                requiredHeight += 10;
            } else {
                requiredWidth *= 2;
                requiredWidth += 10;
            }
        }
        Dimension dimension2 = new Dimension(requiredWidth, requiredHeight);
        if (dimension2 == null) {
            NlDesignSurface.$$$reportNull$$$0(13);
        }
        return dimension2;
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2, int x, int y) {
        ViewHandler handler;
        if (component2 == null) {
            NlDesignSurface.$$$reportNull$$$0(14);
        }
        if ((handler = NlComponentHelperKt.getViewHandler(component2)) != null) {
            handler.onActivateInDesignSurface(component2, x, y);
        }
        super.notifyComponentActivate(component2, x, y);
    }

    public void setMockupVisible(boolean mockupVisible) {
        this.myMockupVisible = mockupVisible;
        this.repaint();
    }

    public boolean isMockupVisible() {
        return this.myMockupVisible;
    }

    public void setMockupEditor(@Nullable MockupEditor mockupEditor) {
        this.myMockupEditor = mockupEditor;
    }

    @Nullable
    public MockupEditor getMockupEditor() {
        return this.myMockupEditor;
    }

    public void updateErrorDisplay() {
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "Do not hold read lock when calling updateErrorDisplay!";
        this.getErrorQueue().cancelAllUpdates();
        this.getErrorQueue().queue(new Update("errors"){

            public void run() {
                RenderResult result;
                LayoutlibSceneManager sceneManager = NlDesignSurface.this.getSceneManager();
                RenderResult renderResult = result = sceneManager != null ? sceneManager.getRenderResult() : null;
                if (result == null) {
                    return;
                }
                Project project = NlDesignSurface.this.getProject();
                if (project.isDisposed()) {
                    return;
                }
                BuildMode gradleBuildMode = BuildSettings.getInstance(project).getBuildMode();
                RenderErrorModel model = gradleBuildMode != null && result.getLogger().hasErrors() ? RenderErrorModel.STILL_BUILDING_ERROR_MODEL : RenderErrorModelFactory.createErrorModel(result, DataManager.getInstance().getDataContext((Component)NlDesignSurface.this.getIssuePanel()));
                NlDesignSurface.this.getIssueModel().setRenderErrorModel(model);
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    protected void modelRendered() {
        if (this.getCurrentSceneView() != null) {
            this.updateErrorDisplay();
        }
        super.modelRendered();
    }

    @Override
    public void forceUserRequestedRefresh() {
        LayoutlibSceneManager sceneManager = this.getSceneManager();
        if (sceneManager != null) {
            sceneManager.requestUserInitatedRender();
        }
    }

    @Override
    protected boolean useSmallProgressIcon() {
        if (this.getCurrentSceneView() == null) {
            return false;
        }
        LayoutlibSceneManager manager = this.getSceneManager();
        assert (manager != null);
        return manager.getRenderResult() != null;
    }

    @Override
    protected double getMinScale() {
        return Math.min(this.getFitScale(false), 1.0);
    }

    @Override
    protected double getMaxScale() {
        return 10.0;
    }

    public boolean hasCustomDevice() {
        Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            return false;
        }
        Device device = configuration.getDevice();
        return device != null && "Custom".equals(device.getId());
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        ViewGroupHandler viewGroupHandler;
        if (view == null) {
            NlDesignSurface.$$$reportNull$$$0(15);
        }
        ScreenView screenView = (ScreenView)view;
        Dimension size = screenView.getSize();
        Rectangle resizeZone = new Rectangle(view.getX() + size.width, screenView.getY() + size.height, 48, 48);
        if (resizeZone.contains(mouseX, mouseY) && this.hasCustomDevice()) {
            Configuration configuration = this.getConfiguration();
            assert (configuration != null);
            return new CanvasResizeInteraction(this, screenView, configuration);
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        NlComponent component2 = Coordinates.findComponent(screenView, mouseX, mouseY);
        if (component2 == null) {
            if (!selectionModel.isEmpty()) {
                component2 = selectionModel.getPrimary();
            } else {
                return null;
            }
        }
        ViewGroupHandler viewGroupHandler2 = viewGroupHandler = component2 != null ? NlComponentHelperKt.getViewGroupHandler(component2) : null;
        if (viewGroupHandler == null) {
            return null;
        }
        Interaction interaction = null;
        if (!selectionModel.isEmpty()) {
            NlComponent parent;
            NlComponent primary = screenView.getSelectionModel().getPrimary();
            NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
            if (parent != null) {
                ViewGroupHandler handler;
                int ax = Coordinates.getAndroidX(screenView, mouseX);
                int ay = Coordinates.getAndroidY(screenView, mouseY);
                if (NlComponentHelperKt.containsX(primary, ax) && NlComponentHelperKt.containsY(primary, ay) && (handler = NlComponentHelperKt.getViewGroupHandler(parent)) != null) {
                    interaction = handler.createInteraction(screenView, primary);
                }
            }
        }
        if (interaction == null) {
            interaction = viewGroupHandler.createInteraction(screenView, component2);
        }
        return interaction;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        List<Object> dragged;
        if (draggedSceneComponent == null) {
            NlDesignSurface.$$$reportNull$$$0(16);
        }
        if (primary == null) {
            primary = draggedSceneComponent;
        }
        NlComponent primaryNlComponent = primary.getNlComponent();
        if (this.getSelectionModel().isSelected(draggedSceneComponent.getNlComponent())) {
            dragged = Lists.newArrayList();
            if (primary.getParent() == null) {
                primaryNlComponent = null;
            } else {
                dragged.add(primaryNlComponent);
            }
            for (NlComponent selected : this.getSelectionModel().getSelection()) {
                if (selected.isRoot() || selected == primaryNlComponent) continue;
                dragged.add(selected);
            }
        } else {
            dragged = Collections.singletonList(primaryNlComponent);
        }
        return new DragDropInteraction(this, dragged);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneMode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adaptiveIconShape";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredSize";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedSceneComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/NlDesignSurface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconShape";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScreenMode";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdaptiveIconShape";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isVerticalScreenConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCreateInteractionOnClick";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionOnDrag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

