/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.compiler.AndroidAutogenerator;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidRegenerateSourcesAction
extends AnAction {
    private static final String TITLE = "Generate Sources";

    public AndroidRegenerateSourcesAction() {
        super(TITLE);
    }

    public void update(@NotNull AnActionEvent e) {
        String title;
        boolean visible;
        block2: {
            Project project;
            block3: {
                if (e == null) {
                    AndroidRegenerateSourcesAction.$$$reportNull$$$0(0);
                }
                Module module = (Module)e.getData(DataKeys.MODULE);
                project = (Project)e.getData(DataKeys.PROJECT);
                visible = project != null && !ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID).isEmpty();
                title = TITLE;
                if (!visible) break block2;
                visible = false;
                if (module == null) break block3;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) break block2;
                visible = AndroidAutogenerator.supportsAutogeneration(facet);
                title = "Generate Sources for '" + module.getName() + "'";
                break block2;
            }
            List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
            for (AndroidFacet facet : facets) {
                if (!AndroidAutogenerator.supportsAutogeneration(facet)) continue;
                visible = true;
                break;
            }
        }
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible);
        e.getPresentation().setText(title);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AndroidRegenerateSourcesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(DataKeys.PROJECT);
        Module module = (Module)e.getData(DataKeys.MODULE);
        if (module != null) {
            AndroidRegenerateSourcesAction.generate(project, module);
            return;
        }
        assert (project != null);
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        ArrayList<Module> modulesToProcess = new ArrayList<Module>();
        for (AndroidFacet facet : facets) {
            module = facet.getModule();
            if (!AndroidAutogenerator.supportsAutogeneration(facet)) continue;
            modulesToProcess.add(module);
        }
        if (!modulesToProcess.isEmpty()) {
            AndroidRegenerateSourcesAction.generate(project, modulesToProcess.toArray(new Module[modulesToProcess.size()]));
        }
    }

    private static void generate(Project project, final Module ... modules) {
        CompilerManager.getInstance((Project)project).executeTask(new CompileTask(){

            public boolean execute(CompileContext context) {
                for (Module module : modules) {
                    AndroidFacet facet = AndroidFacet.getInstance(module);
                    if (facet == null) continue;
                    for (AndroidAutogeneratorMode mode : AndroidAutogeneratorMode.values()) {
                        AndroidCompileUtil.generate(facet, mode, context, true);
                    }
                }
                return true;
            }
        }, (CompileScope)new ModuleCompileScope(project, modules, false), AndroidBundle.message("android.compile.messages.generating.r.java.content.name", new Object[0]), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/android/actions/AndroidRegenerateSourcesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

