/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.attrs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeDefinition
implements Cloneable {
    private String myName;
    private final List<String> myParentStyleables;
    private final Set<AttributeFormat> myFormats;
    private LinkedList<String> myValues;
    private final Map<String, String> myStyleable2DocValue;
    private HashMap<String, String> myValueDoc;
    private HashMap<String, Integer> myValueMappings;
    private String myGlobalDocValue;
    private String myAttrGroup;
    private final String myLibraryName;

    public AttributeDefinition(@NotNull String name) {
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(0);
        }
        this(name, null, null, Collections.emptySet());
    }

    public AttributeDefinition(@NotNull String name, @Nullable String libraryName, @Nullable String parentStyleableName, @NotNull Collection<AttributeFormat> formats) {
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(1);
        }
        if (formats == null) {
            AttributeDefinition.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myLibraryName = libraryName;
        this.myParentStyleables = parentStyleableName == null ? ContainerUtil.newSmartList() : ContainerUtil.newSmartList((Object)parentStyleableName);
        this.myFormats = formats.isEmpty() ? EnumSet.noneOf(AttributeFormat.class) : EnumSet.copyOf(formats);
        this.myStyleable2DocValue = new HashMap<String, String>();
    }

    public void addValue(@NotNull String name) {
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(3);
        }
        if (this.myValues == null) {
            this.myValues = new LinkedList();
        }
        this.myValues.add(name);
    }

    public void addValueMapping(@NotNull String flagName, @NotNull Integer intValue) {
        if (flagName == null) {
            AttributeDefinition.$$$reportNull$$$0(4);
        }
        if (intValue == null) {
            AttributeDefinition.$$$reportNull$$$0(5);
        }
        if (this.myValueMappings == null) {
            this.myValueMappings = new HashMap();
        }
        this.myValueMappings.put(flagName, intValue);
    }

    @Nullable
    public Integer getValueMapping(@NotNull String flagName) {
        if (flagName == null) {
            AttributeDefinition.$$$reportNull$$$0(6);
        }
        return this.myValueMappings != null ? this.myValueMappings.get(flagName) : null;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AttributeDefinition.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public String getLibraryName() {
        return this.myLibraryName;
    }

    @NotNull
    public List<String> getParentStyleables() {
        List<String> list = this.myParentStyleables;
        if (list == null) {
            AttributeDefinition.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Set<AttributeFormat> getFormats() {
        Set<AttributeFormat> set = Collections.unmodifiableSet(this.myFormats);
        if (set == null) {
            AttributeDefinition.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Nullable
    public String getAttrGroup() {
        return this.myAttrGroup;
    }

    public void setAttrGroup(@Nullable String attrGroup) {
        this.myAttrGroup = attrGroup;
    }

    public void addFormats(@NotNull Collection<AttributeFormat> format) {
        if (format == null) {
            AttributeDefinition.$$$reportNull$$$0(10);
        }
        this.myFormats.addAll(format);
    }

    @NotNull
    public String[] getValues() {
        String[] stringArray = this.myValues == null ? ArrayUtil.EMPTY_STRING_ARRAY : ArrayUtil.toStringArray(this.myValues);
        if (stringArray == null) {
            AttributeDefinition.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    @Nullable
    public String getDocValue(@Nullable String parentStyleable) {
        if (parentStyleable == null || !this.myStyleable2DocValue.containsKey(parentStyleable)) {
            return this.myGlobalDocValue;
        }
        return this.myStyleable2DocValue.get(parentStyleable);
    }

    public void addDocValue(@NotNull String docValue, @Nullable String parentStyleable) {
        if (docValue == null) {
            AttributeDefinition.$$$reportNull$$$0(12);
        }
        if (parentStyleable == null || this.myGlobalDocValue == null) {
            this.myGlobalDocValue = docValue;
        }
        if (parentStyleable != null) {
            this.myStyleable2DocValue.put(parentStyleable, docValue);
        }
    }

    public String toString() {
        return this.myName + " [" + this.myFormats + ']';
    }

    public void addValueDoc(@NotNull String value, @NotNull String doc) {
        if (value == null) {
            AttributeDefinition.$$$reportNull$$$0(13);
        }
        if (doc == null) {
            AttributeDefinition.$$$reportNull$$$0(14);
        }
        if (this.myValueDoc == null) {
            this.myValueDoc = new HashMap();
        }
        this.myValueDoc.put(value, doc);
    }

    @Nullable
    public String getValueDoc(@NotNull String value) {
        if (value == null) {
            AttributeDefinition.$$$reportNull$$$0(15);
        }
        return this.myValueDoc != null ? this.myValueDoc.get(value) : null;
    }

    public boolean isAttributeDeprecated() {
        String doc = this.getDocValue(null);
        return doc != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    public boolean isValueDeprecated(@NotNull String value) {
        String doc;
        if (value == null) {
            AttributeDefinition.$$$reportNull$$$0(16);
        }
        return (doc = this.getValueDoc(value)) != null && StringUtil.containsIgnoreCase((String)doc, (String)"deprecated");
    }

    @NotNull
    public AttributeDefinition cloneWithName(@NotNull String name) {
        AttributeDefinition attributeDefinition;
        if (name == null) {
            AttributeDefinition.$$$reportNull$$$0(17);
        }
        try {
            AttributeDefinition copy = (AttributeDefinition)super.clone();
            copy.myName = name;
            attributeDefinition = copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
        if (attributeDefinition == null) {
            AttributeDefinition.$$$reportNull$$$0(18);
        }
        return attributeDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/attrs/AttributeDefinition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docValue";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/attrs/AttributeDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentStyleables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormats";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addValueMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueMapping";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFormats";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDocValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addValueDoc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getValueDoc";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isValueDeprecated";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

