/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutViewClassUtils {
    private LayoutViewClassUtils() {
    }

    @NotNull
    public static String[] getTagNamesByClass(final @NotNull PsiClass c, final int apiLevel) {
        if (c == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(0);
        }
        String[] stringArray = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                String name = c.getName();
                if (name == null) {
                    return ArrayUtil.EMPTY_STRING_ARRAY;
                }
                String qualifiedName = c.getQualifiedName();
                if (qualifiedName == null) {
                    return new String[]{name};
                }
                if (ResourceHelper.isClassPackageNeeded(qualifiedName, c, apiLevel)) {
                    return new String[]{qualifiedName};
                }
                return new String[]{name, qualifiedName};
            }
        });
        if (stringArray == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull PsiClass baseClass) {
        if (facet == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(3);
        }
        if (baseClass == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(4);
        }
        Module module = facet.getModule();
        Project project = module.getProject();
        if (!name.contains(".")) {
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(name, module.getModuleWithLibrariesScope());
            int apiLevel = AndroidModuleInfo.getInstance(facet).getModuleMinApi();
            for (PsiClass aClass : classes) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || ResourceHelper.isClassPackageNeeded(qualifiedName, baseClass, apiLevel) || !aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
        } else {
            PsiClass[] classes;
            for (PsiClass aClass : classes = JavaPsiFacade.getInstance((Project)project).findClasses(name, module.getModuleWithDependenciesAndLibrariesScope(false))) {
                if (!aClass.isInheritor(baseClass, true)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiClass findClassByTagName(@NotNull AndroidFacet facet, @NotNull String name, @NotNull String baseClassQName) {
        PsiClass baseClass;
        if (facet == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(5);
        }
        if (name == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(6);
        }
        if (baseClassQName == null) {
            LayoutViewClassUtils.$$$reportNull$$$0(7);
        }
        return (baseClass = JavaPsiFacade.getInstance((Project)facet.getModule().getProject()).findClass(baseClassQName, facet.getModule().getModuleWithLibrariesScope())) != null ? LayoutViewClassUtils.findClassByTagName(facet, name, baseClass) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/LayoutViewClassUtils";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassQName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/LayoutViewClassUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagNamesByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTagNamesByClass";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClassByTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

