/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.SmartHashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppCompatMigrationEntry {
    public static final int CHANGE_CLASS = 1;
    public static final int CHANGE_METHOD = 2;
    public static final int CHANGE_THEME_AND_STYLE = 3;
    public static final int CHANGE_CUSTOM_VIEW_SUPERCLASS = 4;
    public static final int REPLACE_METHOD = 5;
    public static final int CHANGE_TAG = 6;
    public static final int CHANGE_ATTR = 7;
    public static final int CHANGE_ATTR_VALUE = 8;
    protected final int myType;

    AppCompatMigrationEntry(int type) {
        this.myType = type;
    }

    public int getType() {
        return this.myType;
    }

    static class ReplaceMethodCallMigrationEntry
    extends MethodMigrationEntry {
        final int myQualifierParamIndex;

        ReplaceMethodCallMigrationEntry(String oldClassName, String oldMethodName, String newClassName, String newMethodName, int qualifierParamIndex) {
            super(5, oldClassName, oldMethodName, newClassName, newMethodName);
            this.myQualifierParamIndex = qualifierParamIndex;
        }
    }

    static class MethodMigrationEntry
    extends AppCompatMigrationEntry {
        final String myOldClassName;
        final String myOldMethodName;
        final String myNewMethodName;
        final String myNewClassName;

        MethodMigrationEntry(String oldClassName, String oldMethodName, String newClassName, String newMethodName) {
            this(2, oldClassName, oldMethodName, newClassName, newMethodName);
        }

        protected MethodMigrationEntry(int type, String oldClassName, String oldMethodName, String newClassName, String newMethodName) {
            super(type);
            this.myOldClassName = oldClassName;
            this.myOldMethodName = oldMethodName;
            this.myNewClassName = newClassName;
            this.myNewMethodName = newMethodName;
        }
    }

    static class ClassMigrationEntry
    extends AppCompatMigrationEntry {
        final String myOldName;
        final String myNewName;

        ClassMigrationEntry(@NotNull String oldName, @NotNull String newName2) {
            if (oldName == null) {
                ClassMigrationEntry.$$$reportNull$$$0(0);
            }
            if (newName2 == null) {
                ClassMigrationEntry.$$$reportNull$$$0(1);
            }
            super(1);
            this.myOldName = oldName;
            this.myNewName = newName2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$ClassMigrationEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AttributeValueMigrationEntry
    extends XmlElementMigration {
        final String myOldAttrValue;
        final String myNewAttrValue;
        final String myAttributeName;
        final String myNamespace;
        final int myFlags;
        final Set<String> myTagNames;

        AttributeValueMigrationEntry(String oldAttrValue, String newAttrValue, String attributeName, String namespace, int flags, String ... tagNames) {
            super(8);
            this.myOldAttrValue = oldAttrValue;
            this.myNewAttrValue = newAttrValue;
            this.myAttributeName = attributeName;
            this.myNamespace = namespace;
            this.myFlags = flags;
            this.myTagNames = new SmartHashSet(Arrays.asList(tagNames));
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return this.myTagNames;
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            XmlAttribute attr;
            if (this.myTagNames.contains(tag.getName()) && (attr = tag.getAttribute(this.myAttributeName, this.myNamespace)) != null && StringUtil.equals((CharSequence)this.myOldAttrValue, (CharSequence)attr.getValue())) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlAttrValueUsageInfo((PsiElement)attr.getValueElement(), this);
            }
            return null;
        }
    }

    static class AttributeMigrationEntry
    extends XmlElementMigration {
        final String myOldAttributeName;
        final String myNewAttributeName;
        final String myNewNamespace;
        final String myOldNamespace;
        private final int myFlags;
        private final Set<String> myTagNames;

        AttributeMigrationEntry(String oldAttributeName, String oldNamespace, String newAttributeName, String newNamespace, int flags, String ... tagNames) {
            super(7);
            this.myOldAttributeName = oldAttributeName;
            this.myOldNamespace = oldNamespace;
            this.myNewAttributeName = newAttributeName;
            this.myNewNamespace = newNamespace;
            this.myFlags = flags;
            this.myTagNames = new SmartHashSet(Arrays.asList(tagNames));
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return this.myTagNames;
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            XmlAttribute attr;
            if (this.myTagNames.contains(tag.getName()) && (attr = tag.getAttribute(this.myOldAttributeName, this.myOldNamespace)) != null) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlAttrUsageInfo((PsiElement)attr.getNameElement(), this);
            }
            return null;
        }
    }

    static class XmlTagMigrationEntry
    extends XmlElementMigration {
        final String myOldTagName;
        final String myOldNamespace;
        final String myNewTagName;
        final String myNewNamespace;
        final int myFlags;

        XmlTagMigrationEntry(String oldTagName, @Nullable String oldNamespace, String newTagName, @Nullable String newNamespace, int flags) {
            super(6);
            this.myOldTagName = oldTagName;
            this.myOldNamespace = oldNamespace;
            this.myNewTagName = newTagName;
            this.myNewNamespace = newNamespace;
            this.myFlags = flags;
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return Sets.newHashSet((Object[])new String[]{this.myOldTagName});
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            if (StringUtil.equals((CharSequence)tag.getLocalName(), (CharSequence)this.myOldTagName) && StringUtil.equals((CharSequence)tag.getNamespace(), (CharSequence)this.myOldNamespace)) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlTagUsageInfo((PsiElement)tag, this);
            }
            return null;
        }
    }

    static abstract class XmlElementMigration
    extends AppCompatMigrationEntry {
        public static final int FLAG_LAYOUT = 1;
        public static final int FLAG_MENU = 2;
        public static final int FLAG_STYLE = 4;

        XmlElementMigration(int type) {
            super(type);
        }

        public abstract int getFlags();

        public abstract Set<String> applicableTagNames();

        public abstract UsageInfo apply(XmlTag var1);

        public boolean isMenuOperation() {
            return (this.getFlags() & 2) == 2;
        }

        public boolean isLayoutOperation() {
            return (this.getFlags() & 1) == 1;
        }

        public boolean isStyleOperation() {
            return (this.getFlags() & 4) == 4;
        }
    }
}

