/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.resources.ResourceType;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

abstract class ValueResourceInfoBase
implements ValueResourceInfo {
    protected final String myName;
    protected final ResourceType myType;
    protected final VirtualFile myFile;

    protected ValueResourceInfoBase(@NotNull String name, @NotNull ResourceType type, @NotNull VirtualFile file) {
        if (name == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myType = type;
        this.myFile = file;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        ResourceType resourceType = this.myType;
        if (resourceType == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(5);
        }
        return resourceType;
    }

    public String toString() {
        return "ANDROID_RESOURCE: " + this.myType + ", " + this.myName + ", " + this.myFile.getPath() + "]";
    }

    @Override
    public int compareTo(@NotNull ValueResourceInfo other) {
        VirtualFile file2;
        VirtualFile file1;
        int delta;
        if (other == null) {
            ValueResourceInfoBase.$$$reportNull$$$0(6);
        }
        if ((delta = AndroidResourceUtil.compareResourceFiles(file1 = this.myFile, file2 = other.getContainingFile())) != 0) {
            return delta;
        }
        return this.getSortingRank() - ((ValueResourceInfoBase)other).getSortingRank();
    }

    protected abstract int getSortingRank();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ValueResourceInfoBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ValueResourceInfoBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

