/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDependenciesCache {
    private static final Key<SoftReference<AndroidDependenciesCache>> KEY = Key.create((String)"ANDROID_DEPENDENCIES_CACHE");
    private final Module myModule;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllDependencies;
    private final Ref<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies;

    private AndroidDependenciesCache(@NotNull Module module) {
        if (module == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(0);
        }
        this.myAllDependencies = Ref.create();
        this.myAllLibraryDependencies = Ref.create();
        this.myModule = module;
        module.getProject().getMessageBus().connect((Disposable)module).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AndroidDependenciesCache.this.dropCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/android/util/AndroidDependenciesCache$1", "rootsChanged"));
            }
        });
    }

    private synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    @NotNull
    public static AndroidDependenciesCache getInstance(@NotNull Module module) {
        AndroidDependenciesCache cache;
        if (module == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(1);
        }
        if ((cache = (AndroidDependenciesCache)SoftReference.dereference((Reference)((Reference)module.getUserData(KEY)))) == null) {
            cache = new AndroidDependenciesCache(module);
            module.putUserData(KEY, (Object)new SoftReference((Object)cache));
        }
        AndroidDependenciesCache androidDependenciesCache = cache;
        if (androidDependenciesCache == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(2);
        }
        return androidDependenciesCache;
    }

    @NotNull
    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        List<AndroidFacet> list = AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
        if (list == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private Ref<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        Ref<List<WeakReference<AndroidFacet>>> ref = androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
        if (ref == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(4);
        }
        return ref;
    }

    @NotNull
    private static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module, boolean androidLibrariesOnly, Ref<List<WeakReference<AndroidFacet>>> listRef) {
        List refs;
        if (module == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(5);
        }
        if ((refs = (List)listRef.get()) == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module, androidLibrariesOnly, facets, (Set<AndroidFacet>)new HashSet());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), (Function)new Function<AndroidFacet, WeakReference<AndroidFacet>>(){

                public WeakReference<AndroidFacet> fun(AndroidFacet facet) {
                    return new WeakReference<AndroidFacet>(facet);
                }
            });
            listRef.set((Object)refs);
        }
        List<AndroidFacet> list = AndroidDependenciesCache.dereference(refs);
        if (list == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<AndroidFacet> dereference(@NotNull List<WeakReference<AndroidFacet>> refs) {
        if (refs == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.mapNotNull(refs, (Function)new Function<WeakReference<AndroidFacet>, AndroidFacet>(){

            public AndroidFacet fun(WeakReference<AndroidFacet> ref) {
                return (AndroidFacet)((Object)ref.get());
            }
        });
        if (list == null) {
            AndroidDependenciesCache.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void collectAllAndroidDependencies(Module module, boolean androidLibrariesOnly, List<AndroidFacet> result, Set<AndroidFacet> visited) {
        OrderEntry[] entries = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        for (int i = entries.length - 1; i >= 0; --i) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            OrderEntry orderEntry = entries[i];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance(depModule)) == null || androidLibrariesOnly && depFacet.isAppProject() || !visited.add(depFacet)) continue;
            List cachedDepDeps = (List)AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result, visited);
            }
            result.add(depFacet);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidDependenciesCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidDependenciesCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getListRef";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dereference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dereference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

