/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.build;

import com.android.sdklib.build.ApkBuilder;
import com.android.sdklib.build.ApkCreationException;
import com.android.sdklib.build.DuplicateFileException;
import com.android.sdklib.build.SealedApkException;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;

@Deprecated
public final class ApkBuilderMain {
    private static final Pattern PATTERN_JAR_EXT = Pattern.compile("^.+\\.jar$", 2);

    public static void main(String[] args) {
        if (args.length < 1) {
            ApkBuilderMain.printUsageAndQuit();
        }
        System.err.println("\nTHIS TOOL IS DEPRECATED. See --help for more information.\n");
        try {
            File outApk = new File(args[0]);
            File dexFile = null;
            ArrayList<File> zipArchives = new ArrayList<File>();
            ArrayList<File> sourceFolders = new ArrayList<File>();
            ArrayList<File> jarFiles = new ArrayList<File>();
            ArrayList<File> nativeFolders = new ArrayList<File>();
            boolean verbose = false;
            boolean signed = true;
            boolean debug = false;
            int index = 1;
            do {
                String argument;
                if ("-v".equals(argument = args[index++])) {
                    verbose = true;
                    continue;
                }
                if ("-d".equals(argument)) {
                    debug = true;
                    continue;
                }
                if ("-u".equals(argument)) {
                    signed = false;
                    continue;
                }
                if ("-z".equals(argument)) {
                    if (index == args.length) {
                        ApkBuilderMain.printAndExit("Missing value for -z");
                    }
                    zipArchives.add(new File(args[index++]));
                    continue;
                }
                if ("-f".equals(argument)) {
                    if (dexFile != null) {
                        ApkBuilderMain.printAndExit("Can't have more than one dex file (-f)");
                    }
                    if (index == args.length) {
                        ApkBuilderMain.printAndExit("Missing value for -f");
                    }
                    dexFile = new File(args[index++]);
                    continue;
                }
                if ("-rf".equals(argument)) {
                    if (index == args.length) {
                        ApkBuilderMain.printAndExit("Missing value for -rf");
                    }
                    sourceFolders.add(new File(args[index++]));
                    continue;
                }
                if ("-rj".equals(argument)) {
                    if (index == args.length) {
                        ApkBuilderMain.printAndExit("Missing value for -rj");
                    }
                    jarFiles.add(new File(args[index++]));
                    continue;
                }
                if ("-nf".equals(argument)) {
                    if (index == args.length) {
                        ApkBuilderMain.printAndExit("Missing value for -nf");
                    }
                    nativeFolders.add(new File(args[index++]));
                    continue;
                }
                if ("-storetype".equals(argument)) {
                    if (index != args.length) continue;
                    ApkBuilderMain.printAndExit("Missing value for -storetype");
                    continue;
                }
                ApkBuilderMain.printAndExit("Unknown argument: " + argument);
            } while (index < args.length);
            if (zipArchives.isEmpty()) {
                ApkBuilderMain.printAndExit("No zip archive, there must be one for the resources");
            }
            ApkBuilder builder = new ApkBuilder(outApk, (File)zipArchives.get(0), dexFile, signed ? ApkBuilder.getDebugKeystore() : null, verbose ? System.out : null);
            builder.setDebugMode(debug);
            for (int i = 1; i < zipArchives.size(); ++i) {
                builder.addZipFile((File)zipArchives.get(i));
            }
            for (File sourceFolder : sourceFolders) {
                builder.addSourceFolder(sourceFolder);
            }
            for (File jarFile : jarFiles) {
                if (jarFile.isDirectory()) {
                    String[] filenames;
                    for (String filename : filenames = jarFile.list((dir, name) -> PATTERN_JAR_EXT.matcher(name).matches())) {
                        builder.addResourcesFromJar(new File(jarFile, filename));
                    }
                    continue;
                }
                builder.addResourcesFromJar(jarFile);
            }
            for (File nativeFolder : nativeFolders) {
                builder.addNativeLibraries(nativeFolder);
            }
            builder.sealApk();
        }
        catch (ApkCreationException e) {
            ApkBuilderMain.printAndExit(e.getMessage());
        }
        catch (DuplicateFileException e) {
            ApkBuilderMain.printAndExit(String.format("Found duplicate file for APK: %1$s\nOrigin 1: %2$s\nOrigin 2: %3$s", e.getArchivePath(), e.getFile1(), e.getFile2()));
        }
        catch (SealedApkException e) {
            ApkBuilderMain.printAndExit(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printUsageAndQuit() {
        System.err.println("\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        System.err.println("THIS TOOL IS DEPRECATED and may stop working at any time!\n");
        System.err.println("If you wish to use apkbuilder for a custom build system, please look at the");
        System.err.println("com.android.sdklib.build.ApkBuilder which provides support for");
        System.err.println("recent build improvements including library projects.");
        System.err.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
        System.err.println("A command line tool to package an Android application from various sources.");
        System.err.println("Usage: apkbuilder <out archive> [-v][-u][-storetype STORE_TYPE] [-z inputzip]");
        System.err.println("            [-f inputfile] [-rf input-folder] [-rj -input-path]");
        System.err.println("");
        System.err.println("    -v      Verbose.");
        System.err.println("    -d      Debug Mode: Includes debug files in the APK file.");
        System.err.println("    -u      Creates an unsigned package.");
        System.err.println("    -storetype Forces the KeyStore type. If omitted the default is used.");
        System.err.println("");
        System.err.println("    -z      Followed by the path to a zip archive.");
        System.err.println("            Adds the content of the application package.");
        System.err.println("");
        System.err.println("    -f      Followed by the path to a file.");
        System.err.println("            Adds the file to the application package.");
        System.err.println("");
        System.err.println("    -rf     Followed by the path to a source folder.");
        System.err.println("            Adds the java resources found in that folder to the application");
        System.err.println("            package, while keeping their path relative to the source folder.");
        System.err.println("");
        System.err.println("    -rj     Followed by the path to a jar file or a folder containing");
        System.err.println("            jar files.");
        System.err.println("            Adds the java resources found in the jar file(s) to the application");
        System.err.println("            package.");
        System.err.println("");
        System.err.println("    -nf     Followed by the root folder containing native libraries to");
        System.err.println("            include in the application package.");
        System.exit(1);
    }

    private static void printAndExit(String ... messages) {
        for (String message : messages) {
            System.err.println(message);
        }
        System.exit(1);
    }

    private ApkBuilderMain() {
    }
}

