/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import org.jetbrains.annotations.NotNull;

public class CheckoutAction
extends AnAction
implements DumbAware,
ActionIdProvider {
    private final CheckoutProvider myProvider;
    private final String myIdPrefix;

    public CheckoutAction(CheckoutProvider provider, String idPrefix) {
        super(provider.getVcsName());
        this.myProvider = provider;
        this.myIdPrefix = idPrefix;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CheckoutAction.$$$reportNull$$$0(0);
        }
        project = (project = (Project)e.getData(CommonDataKeys.PROJECT)) == null ? ProjectManager.getInstance().getDefaultProject() : project;
        this.myProvider.doCheckout(project, this.getListener(project));
    }

    protected CheckoutProvider.Listener getListener(Project project) {
        return ProjectLevelVcsManager.getInstance((Project)project).getCompositeCheckoutListener();
    }

    @Override
    public String getId() {
        return this.myIdPrefix + "." + this.myProvider.getVcsName().replaceAll("_", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/checkout/CheckoutAction", "actionPerformed"));
    }
}

