/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.AopBundle;
import com.intellij.aop.psi.AopElementType;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParserUtil {
    protected static ParsingCommand sequence(final ParsingCommand ... commands) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                for (ParsingCommand command : commands) {
                    if (command.perform(builder)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected static PsiBuilder.Marker doAndPrecedeMarker(PsiBuilder.Marker marker, IElementType type) {
        PsiBuilder.Marker preceding = marker.precede();
        marker.done(type);
        return preceding;
    }

    protected static ParsingCommand token(final String text) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                if (text.equals(builder.getTokenText())) {
                    builder.advanceLexer();
                    return true;
                }
                builder.error(AopBundle.message("error.0.expected", text));
                return false;
            }
        };
    }

    protected static ParsingCommand token(final AopElementType tokenType, final @NonNls @Nullable String expected) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                if (((Object)((Object)tokenType)).equals(builder.getTokenType())) {
                    builder.advanceLexer();
                    return true;
                }
                builder.error(AopBundle.message("error.0.expected", expected));
                return false;
            }
        };
    }

    protected static ParsingCommand token(final TokenSet set, final @NonNls String expected) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                if (set.contains(builder.getTokenType())) {
                    builder.advanceLexer();
                    return true;
                }
                builder.error(AopBundle.message("error.0.expected", expected));
                return false;
            }
        };
    }

    protected static boolean dropMarker(PsiBuilder.Marker marker) {
        marker.drop();
        return false;
    }

    protected static boolean doMarker(ParsingCommand command, PsiBuilder.Marker marker, IElementType type, PsiBuilder builder) {
        return ParserUtil.doMarker(command.perform(builder), marker, type);
    }

    protected static boolean doMarker(boolean result, PsiBuilder.Marker marker, IElementType type) {
        marker.done(type);
        return result;
    }

    protected static ParsingCommand condition(final IElementType type, final ParsingCommand then, final ParsingCommand elze) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                return builder.getTokenType() == type ? then.perform(builder) : elze.perform(builder);
            }
        };
    }

    protected static ParsingCommand or(ParsingCommand ... commands) {
        return ParserUtil.or(commands.length - 1, commands);
    }

    private static ParsingCommand or(final int main, final ParsingCommand ... commands) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder myBuilder) {
                for (ParsingCommand command : commands) {
                    PsiBuilder.Marker marker = myBuilder.mark();
                    if (command.perform(myBuilder)) {
                        marker.drop();
                        return true;
                    }
                    marker.rollbackTo();
                }
                return commands[main].perform(myBuilder);
            }
        };
    }

    protected static ParsingCommand parseList(final @NotNull ParsingCommand member, final @Nullable ParsingCommand separator, final @Nullable IElementType endType, final boolean canBeEmpty) {
        if (member == null) {
            ParserUtil.$$$reportNull$$$0(0);
        }
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                if (canBeEmpty) {
                    if (!ParserUtil.tryParse(member, builder, endType)) {
                        return true;
                    }
                    if (!ParserUtil.tryParse(separator, builder, null)) {
                        return true;
                    }
                }
                do {
                    if ((separator != null || ParserUtil.tryParse(member, builder, endType)) && (separator == null || member.perform(builder))) continue;
                    return separator == null;
                } while (ParserUtil.tryParse(separator, builder, null));
                return true;
            }
        };
    }

    protected static boolean tryParse(@Nullable ParsingCommand command, PsiBuilder builder, @Nullable IElementType endType) {
        if (command == null) {
            return true;
        }
        boolean canBeEnd = endType == null || builder.getTokenType() == endType;
        PsiBuilder.Marker beforeSeparator = builder.mark();
        if (!command.perform(builder) && canBeEnd) {
            beforeSeparator.rollbackTo();
            return false;
        }
        beforeSeparator.drop();
        return true;
    }

    protected static ParsingCommand optional(ParsingCommand command) {
        return ParserUtil.or(command, ParsingCommand.TRUE);
    }

    protected static ParsingCommand parseBinary(final AopElementType exprType, final IElementType separatorType, final ParsingCommand lower) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                PsiBuilder.Marker expr = builder.mark();
                if (!lower.perform(builder)) {
                    return ParserUtil.dropMarker(expr);
                }
                while (separatorType == builder.getTokenType()) {
                    builder.advanceLexer();
                    if (!lower.perform(builder)) {
                        return ParserUtil.dropMarker(expr);
                    }
                    expr = ParserUtil.doAndPrecedeMarker(expr, exprType);
                }
                expr.drop();
                return true;
            }
        };
    }

    protected static ParsingCommand wrap(final ParsingCommand inner, final IElementType type) {
        return new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                return ParserUtil.doMarker(inner, builder.mark(), type, builder);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/aop/psi/ParserUtil", "parseList"));
    }

    protected static abstract class ParsingCommand {
        public static ParsingCommand TRUE = new ParsingCommand(){

            @Override
            public boolean perform(PsiBuilder builder) {
                return true;
            }
        };

        protected ParsingCommand() {
        }

        public abstract boolean perform(PsiBuilder var1);
    }
}

