/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewProperty;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ViewNode
implements TreeNode {
    public final String name;
    public final Map<String, List<ViewProperty>> groupedProperties = Maps.newHashMap();
    public final Map<String, ViewProperty> namedProperties = Maps.newHashMap();
    public final List<ViewProperty> properties = Lists.newArrayList();
    public final List<ViewNode> children = Lists.newArrayList();
    public final ViewNode parent;
    public final int index;
    public final String hashCode;
    public final String id;
    public final DisplayInfo displayInfo;
    public final Rectangle previewBox = new Rectangle();
    private boolean myParentVisible;
    private boolean myNodeDrawn;
    private ForcedState myForcedState = ForcedState.NONE;

    public ViewNode(ViewNode parent, String data) {
        int delimIndex;
        this.parent = parent;
        int n = this.index = this.parent == null ? 0 : this.parent.children.size();
        if (this.parent != null) {
            this.parent.children.add(this);
        }
        if ((delimIndex = data.indexOf(64)) < 0) {
            throw new IllegalArgumentException("Invalid format for ViewNode, missing @: " + data);
        }
        this.name = data.substring(0, delimIndex);
        data = data.substring(delimIndex + 1);
        delimIndex = data.indexOf(32);
        this.hashCode = data.substring(0, delimIndex);
        if (data.length() > delimIndex + 1) {
            this.loadProperties(data.substring(delimIndex + 1).trim());
            this.id = this.getProperty("mID", "id").getValue();
        } else {
            this.id = "unknown";
        }
        this.displayInfo = new DisplayInfo(this);
    }

    private void loadProperties(String data) {
        boolean stop;
        int start = 0;
        do {
            int index = data.indexOf(61, start);
            ViewProperty property = new ViewProperty(data.substring(start, index));
            int index2 = data.indexOf(44, index + 1);
            int length = Integer.parseInt(data.substring(index + 1, index2));
            start = index2 + 1 + length;
            property.setValue(data.substring(index2 + 1, index2 + 1 + length));
            this.properties.add(property);
            this.namedProperties.put(property.fullName, property);
            this.addPropertyToGroup(property);
            boolean bl = stop = start >= data.length();
            if (stop) continue;
            ++start;
        } while (!stop);
        Collections.sort(this.properties);
    }

    private void addPropertyToGroup(ViewProperty property) {
        String key = this.getKey(property);
        List propertiesList = this.groupedProperties.getOrDefault(key, new LinkedList());
        propertiesList.add(property);
        this.groupedProperties.put(key, propertiesList);
    }

    private String getKey(ViewProperty property) {
        if (property.category != null) {
            return property.category;
        }
        if (property.fullName.endsWith("()")) {
            return "methods";
        }
        return "properties";
    }

    public ViewProperty getProperty(String name, String ... altNames) {
        ViewProperty property = this.namedProperties.get(name);
        for (int i = 0; property == null && i < altNames.length; ++i) {
            property = this.namedProperties.get(altNames[i]);
        }
        return property;
    }

    public void updateNodeDrawn() {
        this.updateNodeDrawn(this.myParentVisible);
    }

    private void updateNodeDrawn(boolean parentVisible) {
        this.myParentVisible = parentVisible;
        if (this.myForcedState == ForcedState.NONE) {
            this.myNodeDrawn = !this.displayInfo.willNotDraw && parentVisible && this.displayInfo.isVisible;
            parentVisible &= this.displayInfo.isVisible;
        } else {
            parentVisible = this.myNodeDrawn = this.myForcedState == ForcedState.VISIBLE && parentVisible;
        }
        for (ViewNode child : this.children) {
            child.updateNodeDrawn(parentVisible);
            this.myNodeDrawn |= child.myNodeDrawn && child.displayInfo.isVisible;
        }
    }

    public boolean isDrawn() {
        return this.myNodeDrawn;
    }

    public boolean isParentVisible() {
        return this.myParentVisible;
    }

    public String toString() {
        return this.name + "@" + this.hashCode;
    }

    @Override
    public ViewNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public ViewNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf((ViewNode)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    public ForcedState getForcedState() {
        return this.myForcedState;
    }

    public void setForcedState(ForcedState forcedState) {
        this.myForcedState = forcedState;
    }

    public static ViewNode parseFlatString(byte[] bytes) {
        ViewNode root = null;
        ViewNode lastNode = null;
        int lastWhitespaceCount = Integer.MIN_VALUE;
        Stack<ViewNode> stack = new Stack<ViewNode>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), Charsets.UTF_8));
        try {
            String line;
            while ((line = in.readLine()) != null && !"DONE.".equalsIgnoreCase(line)) {
                int whitespaceCount = 0;
                while (line.charAt(whitespaceCount) == ' ') {
                    ++whitespaceCount;
                }
                if (lastWhitespaceCount < whitespaceCount) {
                    stack.push(lastNode);
                } else if (!stack.isEmpty()) {
                    int count = lastWhitespaceCount - whitespaceCount;
                    for (int i = 0; i < count; ++i) {
                        stack.pop();
                    }
                }
                lastWhitespaceCount = whitespaceCount;
                ViewNode parent = null;
                if (!stack.isEmpty()) {
                    parent = (ViewNode)stack.peek();
                }
                lastNode = new ViewNode(parent, line.trim());
                if (root != null) continue;
                root = lastNode;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (root != null) {
            super.updateNodeDrawn(true);
        }
        return root;
    }

    public static TreePath getPath(ViewNode node) {
        return ViewNode.getPathImpl(node, null);
    }

    public static TreePath getPathFromParent(ViewNode node, ViewNode root) {
        return ViewNode.getPathImpl(node, root);
    }

    private static TreePath getPathImpl(ViewNode node, ViewNode root) {
        ArrayList nodes = Lists.newArrayList();
        do {
            nodes.add(0, node);
        } while ((node = node.parent) != null && node != root);
        if (root != null && node == root) {
            nodes.add(0, root);
        }
        return new TreePath(nodes.toArray());
    }

    public static enum ForcedState {
        NONE,
        VISIBLE,
        INVISIBLE;

    }
}

