/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.refactoring.pushIn;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiAspectJFile;
import com.intellij.lang.aspectj.psi.PsiInterTypeDeclaration;
import com.intellij.lang.aspectj.refactoring.pushIn.PushInProcessor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushInHandler
implements RefactoringActionHandler {
    private static final Class[] ELEMENT_TYPES = new Class[]{PsiInterTypeDeclaration.class, PsiAspect.class, PsiAspectJFile.class};

    @NotNull
    public static String getRefactoringName() {
        String string = AspectJBundle.message("action.push.in.name", new Object[0]);
        if (string == null) {
            PushInHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            PushInHandler.$$$reportNull$$$0(1);
        }
        if ((element = file.findElementAt(editor.getCaretModel().getOffset())) != null) {
            PsiElement parent;
            element = parent = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])ELEMENT_TYPES);
        }
        if (element == null) {
            element = file;
        }
        PushInHandler.invoke(project, Collections.singletonList(element));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        List filtered;
        if (project == null) {
            PushInHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PushInHandler.$$$reportNull$$$0(3);
        }
        if ((filtered = ContainerUtil.findAll((Object[])elements, element -> element instanceof PsiAspect || element instanceof PsiAspectJFile || element instanceof PsiDirectory && PushInHandler.isRootOrInSource((PsiDirectory)element))).isEmpty()) {
            String message = AspectJBundle.message("action.push.in.wrong.position", new Object[0]);
            CommonRefactoringUtil.showErrorMessage((String)PushInHandler.getRefactoringName(), (String)message, (String)"Using_the_Push_ITDs_In_refactoring", (Project)project);
            return;
        }
        PushInHandler.invoke(project, filtered);
    }

    private static boolean isRootOrInSource(PsiDirectory directory) {
        return ProjectRootsUtil.isProjectHome((PsiDirectory)directory) || ProjectRootsUtil.isModuleContentRoot((PsiDirectory)directory) || ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) || ProjectRootsUtil.isInSource((PsiDirectory)directory);
    }

    private static void invoke(Project project, List<PsiElement> elements) {
        new MyRefactoringDialog(project, elements).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/aspectj/refactoring/pushIn/PushInHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRefactoringDialog
    extends RefactoringDialog {
        public static final String DELETE_ASPECTS_PROPERTY = "action.push.in.delete.aspects";
        private final Project myProject;
        private final List<PsiElement> myElements;
        private JBCheckBox myDeleteAspectCb;

        MyRefactoringDialog(Project project, List<PsiElement> elements) {
            super(project, true);
            this.myProject = project;
            this.myElements = elements;
            this.setTitle(AspectJBundle.message("action.push.in.title", new Object[0]));
            this.init();
        }

        protected String getHelpId() {
            return "Using_the_Push_ITDs_In_refactoring";
        }

        protected void doAction() {
            boolean deleteAspects = this.myDeleteAspectCb.isSelected();
            PropertiesComponent.getInstance().setValue(DELETE_ASPECTS_PROPERTY, Boolean.toString(deleteAspects), "true");
            PushInProcessor processor = new PushInProcessor(this.myProject, this.myElements, deleteAspects);
            processor.setPreviewUsages(this.isPreviewUsages());
            this.invokeRefactoring(processor);
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.myDeleteAspectCb = new JBCheckBox(AspectJBundle.message(DELETE_ASPECTS_PROPERTY, new Object[0]));
            this.myDeleteAspectCb.setSelected(PropertiesComponent.getInstance().getBoolean(DELETE_ASPECTS_PROPERTY, true));
            panel.add((Component)this.myDeleteAspectCb, "West");
            return panel;
        }
    }
}

