/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.search;

import com.intellij.lang.aspectj.augment.LightInterTypeMethod;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.psi.util.PseudoImplLightClass;
import com.intellij.lang.aspectj.search.AjSourceFilterScope;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AjDefinitionSearcher
extends QueryExecutorBase<PsiElement, PsiElement> {
    public AjDefinitionSearcher() {
        super(true);
    }

    public void processQuery(@NotNull PsiElement element, @NotNull Processor<? super PsiElement> consumer) {
        if (element == null) {
            AjDefinitionSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            AjDefinitionSearcher.$$$reportNull$$$0(1);
        }
        if (element instanceof LightInterTypeMethod) {
            AjDefinitionSearcher.processInterTypeMethod((LightInterTypeMethod)element, consumer);
        } else if (element instanceof PsiMethod) {
            AjDefinitionSearcher.processMethod((PsiMethod)element, consumer);
        }
    }

    private static void processMethod(PsiMethod method, Processor<? super PsiElement> consumer) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isInterface()) {
            return;
        }
        Project project = method.getProject();
        AjSourceFilterScope scope = new AjSourceFilterScope(project);
        Collection methods = JavaMethodNameIndex.getInstance().get(method.getName(), project, (GlobalSearchScope)scope);
        if (methods == null || methods.isEmpty()) {
            return;
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        for (PsiMethod candidate : methods) {
            LightInterTypeMethod wrapper;
            PsiClass candidateInterface;
            PsiClass candidateClass;
            if (!(candidate instanceof PsiInterTypeMethod) || !((candidateClass = candidate.getContainingClass()) instanceof PseudoImplLightClass) || !InheritanceUtil.isInheritorOrSelf((PsiClass)(candidateInterface = ((PseudoImplLightClass)candidateClass).getDelegate()), (PsiClass)aClass, (boolean)true) || !MethodSignatureUtil.areSignaturesEqual((MethodSignature)signature, (MethodSignature)candidate.getHierarchicalMethodSignature()) || consumer.process((Object)(wrapper = new LightInterTypeMethod((PsiInterTypeMethod)candidate, candidateInterface)))) continue;
            return;
        }
    }

    private static void processInterTypeMethod(LightInterTypeMethod method, Processor<? super PsiElement> consumer) {
        PsiClass aClass;
        if (method.getModifierList().hasModifierProperty("abstract") && (aClass = method.getContainingClass()).isInterface()) {
            consumer.process((Object)method);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/aspectj/search/AjDefinitionSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

