/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;

public abstract class SpringDataRepositoriesInspection
extends SpringUastInspectionBase {
    public boolean isEnabledForProject(@NotNull Project project) {
        if (project == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(0);
        }
        return super.isEnabledForProject(project) && SpringDataUtil.hasSpringDataSupport(project);
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (aClass == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(2);
        }
        if ((sourcePsi = aClass.getSourcePsi()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
        if (module == null) {
            return null;
        }
        if (!SpringDataUtil.isRepository(aClass.getJavaPsi())) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, sourcePsi.getContainingFile(), isOnTheFly);
        this.checkRepositoryClass(aClass, holder, module);
        Pair<PsiClass, ? extends PsiType> typePair = SpringDataUtil.substituteRepositoryTypes(aClass.getJavaPsi());
        if (typePair != null) {
            for (UMethod psiMethod : aClass.getMethods()) {
                if (!SpringDataUtil.isQueryMethod(psiMethod.getJavaPsi())) continue;
                this.checkRepositoryMethod(holder, aClass, psiMethod, module, typePair);
            }
        }
        return holder.getResultsArray();
    }

    protected void checkRepositoryClass(@NotNull UClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(5);
        }
    }

    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        if (holder == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(6);
        }
        if (psiMethod == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(7);
        }
        if (module == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(8);
        }
        if (typePair == null) {
            SpringDataRepositoriesInspection.$$$reportNull$$$0(9);
        }
    }

    @Nullable
    public static PsiType getSubstitutedTypeParameters(@Nullable PsiType returnType, String ... classes) {
        for (String aClass : classes) {
            PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)returnType, (String)aClass, (int)0, (boolean)false);
            if (psiType == null) continue;
            return psiType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoriesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForProject";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRepositoryMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

