/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoriesInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public class SpringDataRepositoryMethodParametersInspection
extends SpringDataRepositoriesInspection {
    @Override
    protected void checkRepositoryMethod(@NotNull ProblemsHolder holder, UClass repositoryClass, @NotNull UMethod psiMethod, @NotNull Module module, @NotNull Pair<PsiClass, ? extends PsiType> typePair) {
        PsiClass domainClass;
        String methodName;
        PartTree partTree;
        if (holder == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(0);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(2);
        }
        if (typePair == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(3);
        }
        if (!SpringDataUtil.hasQueryAnnotation(psiMethod.getJavaPsi()) && !SpringDataRepositoryMethodParametersInspection.hasUnresolvedPropertyPaths(partTree = new PartTree(methodName = psiMethod.getName(), domainClass = (PsiClass)typePair.getFirst()))) {
            SpringDataRepositoryMethodParametersInspection.checkParameters(holder, partTree, psiMethod, domainClass);
        }
    }

    private static boolean hasUnresolvedPropertyPaths(@NotNull PartTree partTree) {
        if (partTree == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(4);
        }
        for (Part part : partTree.getParts()) {
            for (PropertyPath property : part.getProperty()) {
                PsiType type = property.getType();
                if (type != null) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkParameters(@NotNull ProblemsHolder holder, @NotNull PartTree partTree, @NotNull UMethod psiMethod, @NotNull PsiClass domainClass) {
        PsiElement identifier;
        if (holder == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(5);
        }
        if (partTree == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(6);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(7);
        }
        if (domainClass == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(8);
        }
        List<Part> parts = partTree.getParts();
        List<PsiType> requiredParameterTypes = SpringDataRepositoryMethodParametersInspection.getRequiredParameterTypes(parts, psiMethod.getJavaPsi().getProject());
        if (!SpringDataRepositoryMethodParametersInspection.areAssignableTypes(psiMethod.getJavaPsi(), requiredParameterTypes, domainClass) && (identifier = UElementKt.getSourcePsiElement((UElement)psiMethod.getUastAnchor())) != null) {
            String text = SpringDataRepositoryMethodParametersInspection.getRequiredParametersTypesToString(requiredParameterTypes, psiMethod.getJavaPsi().getParameterList());
            holder.registerProblem(identifier, SpringDataBundle.message("required.parameters", text), SpringDataRepositoryMethodParametersInspection.getQuickFixes(psiMethod.getJavaPsi(), parts));
        }
    }

    private static LocalQuickFix[] getQuickFixes(PsiMethod psiMethod, Iterable<Part> requiredParameterTypes) {
        List actions = JvmElementActionFactories.createChangeParametersActions((JvmMethod)psiMethod, (ChangeParametersRequest)MethodRequestsKt.setMethodParametersRequest(SpringDataRepositoryMethodParametersInspection.createParamMap(requiredParameterTypes, psiMethod).entrySet()));
        return IntentionWrapper.wrapToQuickFixes((IntentionAction[])actions.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)psiMethod.getContainingFile());
    }

    private static PsiClassType getObjectClassType(Project project) {
        return PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    private static boolean areAssignableTypes(@NotNull PsiMethod psiMethod, @NotNull List<PsiType> requiredParameterTypes, @NotNull PsiClass domainClass) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(9);
        }
        if (requiredParameterTypes == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(10);
        }
        if (domainClass == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(11);
        }
        if ((parameters = psiMethod.getParameterList().getParameters()).length == 0 && requiredParameterTypes.size() == 0) {
            return true;
        }
        int requiredParameterIndex = 0;
        for (PsiParameter parameter : parameters) {
            PsiType parameterType = parameter.getType();
            if (SpringDataRepositoryMethodParametersInspection.isNotQueryParameter(psiMethod, parameterType)) continue;
            if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"java.util.Optional")) {
                parameterType = SpringDataRepositoryMethodParametersInspection.getSubstitutedTypeParameters(parameterType, "java.util.Optional");
            }
            if (requiredParameterIndex >= requiredParameterTypes.size()) {
                return false;
            }
            PsiType requiredType = requiredParameterTypes.get(requiredParameterIndex);
            if (requiredType == null || parameterType == null || InheritanceUtil.isInheritor((PsiType)requiredType, (String)"java.util.Collection")) {
                ++requiredParameterIndex;
                continue;
            }
            if (!SpringDataRepositoryMethodParametersInspection.isAssignableOrDomainClassFrom(parameterType, requiredType, domainClass)) {
                return false;
            }
            ++requiredParameterIndex;
        }
        return requiredParameterIndex == requiredParameterTypes.size();
    }

    private static boolean isNotQueryParameter(@NotNull PsiMethod psiMethod, PsiType parameterType) {
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(12);
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"java.lang.Class")) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Pageable") || InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.domain.Sort")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)parameterType, (String)"org.springframework.data.geo.Distance") && InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults");
    }

    private static boolean isAssignableOrDomainClassFrom(@NotNull PsiType parameterType, @NotNull PsiType requiredType, @NotNull PsiClass domainClass) {
        if (parameterType == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(13);
        }
        if (requiredType == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(14);
        }
        if (domainClass == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(15);
        }
        if (parameterType.isAssignableFrom(requiredType)) {
            return true;
        }
        PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)parameterType, (boolean)false);
        if (iterableTypeParameter != null && iterableTypeParameter.isAssignableFrom(requiredType)) {
            return true;
        }
        return parameterType instanceof PsiClassType && domainClass.equals(((PsiClassType)parameterType).resolve());
    }

    private static String getRequiredParametersTypesToString(List<PsiType> requiredParameterTypes, PsiParameterList parameterList) {
        String[] types = new String[requiredParameterTypes.size()];
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < requiredParameterTypes.size(); ++i) {
            boolean boldType = true;
            PsiType requiredType = requiredParameterTypes.get(i);
            if (i < parameters.length) {
                PsiType parameterType = parameters[i].getType();
                if (requiredType != null && parameterType.isAssignableFrom(requiredType)) {
                    boldType = false;
                }
            }
            String text = requiredType == null ? SpringDataRepositoryMethodParametersInspection.getUnresolvedTypeText() : XmlStringUtil.escapeString((String)requiredType.getPresentableText());
            types[i] = boldType ? "<b>" + text + "</b>" : text;
        }
        return StringUtil.join((String[])types, (String)", ");
    }

    private static String getUnresolvedTypeText() {
        return "? extends Object";
    }

    @NotNull
    private static List<PsiType> getRequiredParameterTypes(@NotNull Iterable<Part> parts, @NotNull Project project) {
        if (parts == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(16);
        }
        if (project == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(17);
        }
        LinkedList<PsiType> psiTypes = new LinkedList<PsiType>();
        for (Part part : parts) {
            PsiType psiType = part.getProperty().getLeafProperty().getType();
            if (psiType == null) continue;
            if (SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(part)) {
                psiType = SpringDataRepositoryMethodParametersInspection.createTypedCollection(project, psiType);
            }
            int argumentsNumber = part.getType().getNumberOfArguments();
            for (int i = 0; i < argumentsNumber; ++i) {
                ContainerUtil.addAllNotNull(psiTypes, (Object[])new PsiType[]{psiType});
            }
        }
        LinkedList<PsiType> linkedList = psiTypes;
        if (linkedList == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(18);
        }
        return linkedList;
    }

    @Nullable
    private static PsiType createTypedCollection(@NotNull Project project, @NotNull PsiType psiType) {
        PsiClass aClass;
        if (project == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(19);
        }
        if (psiType == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(20);
        }
        if ((aClass = SpringDataRepositoryMethodParametersInspection.getCollectionClass(project)) == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(aClass, psiType);
    }

    private static boolean isCollectionTypeRequired(@NotNull Part part) {
        if (part == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(21);
        }
        return part.getType() == Part.Type.IN || part.getType() == Part.Type.NOT_IN;
    }

    @Nullable
    private static PsiClass getCollectionClass(Project project) {
        return JavaPsiFacade.getInstance((Project)project).findClass("java.util.Collection", GlobalSearchScope.allScope((Project)project));
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringDataRepositoryMethodParametersInspection" == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(22);
        }
        return "SpringDataRepositoryMethodParametersInspection";
    }

    @NotNull
    private static Map<String, PsiType> createParamMap(@NotNull Iterable<Part> nodes, @NotNull PsiMethod psiMethod) {
        String pageable;
        if (nodes == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(23);
        }
        if (psiMethod == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(24);
        }
        LinkedHashMap<String, PsiType> paramMap = new LinkedHashMap<String, PsiType>();
        PsiClassType objectClassType = SpringDataRepositoryMethodParametersInspection.getObjectClassType(psiMethod.getProject());
        for (Part node : nodes) {
            PropertyPath nodeProperty = node.getProperty();
            PropertyPath property = nodeProperty.getLeafProperty();
            String propertyName = StringUtil.replace((String)nodeProperty.toDotPath(), (String)".", (String)"_");
            PsiType psiType = property.getType();
            if (psiType == null) continue;
            if (SpringDataRepositoryMethodParametersInspection.isCollectionTypeRequired(node)) {
                psiType = SpringDataRepositoryMethodParametersInspection.createTypedCollection(psiMethod.getProject(), psiType);
            }
            int argumentsNumber = node.getType().getNumberOfArguments();
            for (int arg = 0; arg < argumentsNumber; ++arg) {
                String paramName = SpringDataRepositoryMethodParametersInspection.getUnusedName(paramMap, propertyName);
                paramMap.put(paramName, (PsiType)(psiType == null ? objectClassType : psiType));
            }
        }
        if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.domain.Page")) {
            pageable = SpringDataRepositoryMethodParametersInspection.getUnusedName(paramMap, "pageable");
            PsiType pageablePsiType = SpringDataRepositoryMethodParametersInspection.getPsiType(psiMethod.getProject(), "org.springframework.data.domain.Pageable");
            if (pageablePsiType != null) {
                paramMap.put(pageable, pageablePsiType);
            }
        } else if (InheritanceUtil.isInheritor((PsiType)psiMethod.getReturnType(), (String)"org.springframework.data.geo.GeoResults")) {
            pageable = SpringDataRepositoryMethodParametersInspection.getUnusedName(paramMap, "distance");
            PsiType distanceType = SpringDataRepositoryMethodParametersInspection.getPsiType(psiMethod.getProject(), "org.springframework.data.geo.Distance");
            if (distanceType != null) {
                paramMap.put(pageable, distanceType);
            }
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            if (!InheritanceUtil.isInheritor((PsiType)parameter.getType(), (String)"org.springframework.data.domain.Sort")) continue;
            paramMap.put(parameter.getName(), SpringDataRepositoryMethodParametersInspection.getPsiType(parameter.getProject(), "org.springframework.data.domain.Sort"));
            break;
        }
        LinkedHashMap<String, PsiType> linkedHashMap = paramMap;
        if (linkedHashMap == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(25);
        }
        return linkedHashMap;
    }

    @Nullable
    private static PsiType getPsiType(Project project, String fqn) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass pageableClass = psiFacade.findClass(fqn, GlobalSearchScope.allScope((Project)project));
        return pageableClass == null ? null : PsiTypesUtil.getClassType((PsiClass)pageableClass);
    }

    @NotNull
    private static String getUnusedName(@NotNull Map<String, PsiType> paramMap, @NotNull String name) {
        if (paramMap == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(26);
        }
        if (name == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(27);
        }
        String paramName = name;
        int i = 0;
        while (paramMap.containsKey(paramName)) {
            paramName = name + (++i + 1);
        }
        String string = paramName;
        if (string == null) {
            SpringDataRepositoryMethodParametersInspection.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePair";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredParameterTypes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramMap";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/inspections/SpringDataRepositoryMethodParametersInspection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredParameterTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createParamMap";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRepositoryMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedPropertyPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areAssignableTypes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNotQueryParameter";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableOrDomainClassFrom";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredParameterTypes";
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTypedCollection";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionTypeRequired";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createParamMap";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

