/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

class SpringBootApplicationYamlUtil {
    static final String SPRING_PROFILES_KEY = "spring.profiles";
    private static final int VALUE_PRESENTATION_MAX_ITEMS = 2;
    @NonNls
    private static final String MORE_ITEMS_TEXT = ", [...]";

    SpringBootApplicationYamlUtil() {
    }

    static boolean isInsideApplicationYamlFile(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return false;
        }
        PsiFile originalFile = containingFile.getOriginalFile();
        return originalFile instanceof YAMLFile && SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(originalFile);
    }

    static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue) {
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        while (element != null) {
            YAMLKeyValue parent;
            if (builder.length() > 0) {
                builder.insert(0, '.');
            }
            builder.insert(0, element.getKeyText());
            element = parent = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
        }
        return builder.toString();
    }

    @NotNull
    static String getValuePresentationText(YAMLKeyValue yamlKeyValue) {
        YAMLValue value = yamlKeyValue.getValue();
        if (value instanceof YAMLScalar) {
            String string = ((YAMLScalar)value).getTextValue();
            if (string == null) {
                SpringBootApplicationYamlUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (value instanceof YAMLSequence) {
            List sequenceItems = ((YAMLSequence)value).getItems();
            String suffix = sequenceItems.size() > 2 ? MORE_ITEMS_TEXT : "";
            String string = StringUtil.join((Collection)ContainerUtil.getFirstItems((List)sequenceItems, (int)2), item -> {
                YAMLValue itemValue = item.getValue();
                if (itemValue instanceof YAMLScalar) {
                    return ((YAMLScalar)itemValue).getTextValue();
                }
                return SpringBootApplicationYamlUtil.getSequenceItemText(item);
            }, (String)", ") + suffix;
            if (string == null) {
                SpringBootApplicationYamlUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = yamlKeyValue.getValueText();
        if (string == null) {
            SpringBootApplicationYamlUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String getSequenceItemText(YAMLSequenceItem item) {
        SmartList keysValues = new SmartList();
        int count = 0;
        String suffix = "";
        Iterator iterator = item.getKeysValues().iterator();
        while (iterator.hasNext()) {
            YAMLKeyValue next = (YAMLKeyValue)iterator.next();
            keysValues.add(next);
            if (count++ != 2) continue;
            if (!iterator.hasNext()) break;
            suffix = MORE_ITEMS_TEXT;
            break;
        }
        String string = StringUtil.join((Collection)keysValues, keyValue -> keyValue.getKeyText() + ": " + SpringBootApplicationYamlUtil.getValuePresentationText(keyValue), (String)", ") + suffix;
        if (string == null) {
            SpringBootApplicationYamlUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePresentationText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSequenceItemText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

