/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

public class SpringBootModelApplicationYamlConfigFileContributor
extends SpringBootModelConfigFileContributor {
    public SpringBootModelApplicationYamlConfigFileContributor() {
        super((FileType)YAMLFileType.YML);
    }

    @NotNull
    public List<ConfigurationValueResult> findConfigurationValues(ConfigurationValueSearchParams params) {
        Pair<YAMLFile, Boolean> relevantFileInfo = SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantFile(params);
        if (relevantFileInfo == null) {
            List<ConfigurationValueResult> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(0);
            }
            return list;
        }
        String keyName = params.getConfigKey().getName();
        SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder binder = SpringBootApplicationMetaConfigKeyManager.getInstance().getConfigKeyNameBinder(params.getModule());
        SmartList results = new SmartList();
        Processor processor = arg_0 -> SpringBootModelApplicationYamlConfigFileContributor.lambda$findConfigurationValues$0(keyName, params, (List)results, binder, arg_0);
        YAMLFile yamlFile = (YAMLFile)relevantFileInfo.first;
        if (!((Boolean)relevantFileInfo.second).booleanValue()) {
            boolean processAllDocuments = params.isProcessAllProfiles();
            for (YAMLDocument document : yamlFile.getDocuments()) {
                if (!processAllDocuments && !SpringBootModelApplicationYamlConfigFileContributor.isProfileRelevantDocument(document, params.getActiveProfiles()) || SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)document, (Processor<? super YAMLKeyValue>)processor) || processAllDocuments) continue;
                break;
            }
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(1);
            }
            return smartList;
        }
        YAMLDocument profileDocument = (YAMLDocument)ContainerUtil.getFirstItem((List)yamlFile.getDocuments());
        if (profileDocument != null && !SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)profileDocument, (Processor<? super YAMLKeyValue>)processor)) {
            SmartList smartList = results;
            if (smartList == null) {
                SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(2);
            }
            return smartList;
        }
        List<ConfigurationValueResult> list = Collections.emptyList();
        if (list == null) {
            SpringBootModelApplicationYamlConfigFileContributor.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void processYamlKeyValue(ConfigurationValueSearchParams params, List<ConfigurationValueResult> results, YAMLKeyValue yamlKeyValue) {
        PsiElement keyElement = yamlKeyValue.getKey();
        if (keyElement == null) {
            return;
        }
        YAMLValue valueElement = yamlKeyValue.getValue();
        if (valueElement instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)valueElement;
            for (YAMLSequenceItem item : sequence.getItems()) {
                YAMLValue itemValue = item.getValue();
                if (!(itemValue instanceof YAMLScalar)) continue;
                results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, (PsiElement)itemValue, itemValue.getText(), params));
            }
            return;
        }
        if (valueElement instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)valueElement;
            for (YAMLKeyValue mapKeyValue : mapping.getKeyValues()) {
                if (mapKeyValue.getKey() == null) continue;
                results.add(new YamlConfigurationValueResult(mapKeyValue, mapKeyValue.getKey(), (PsiElement)mapKeyValue.getValue(), mapKeyValue.getValueText(), params));
            }
            return;
        }
        results.add(new YamlConfigurationValueResult(yamlKeyValue, keyElement, (PsiElement)valueElement, yamlKeyValue.getValueText(), params));
    }

    private static boolean isProfileRelevantDocument(YAMLDocument document, Set<String> activeProfiles) {
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return true;
        }
        SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor(document);
        YAMLKeyValue profilesKey = accessor.findExistingKey("spring.profiles");
        if (profilesKey == null) {
            return false;
        }
        String profileText = profilesKey.getValueText();
        return activeProfiles.contains(profileText);
    }

    @Nullable
    private static Pair<YAMLFile, Boolean> isProfileRelevantFile(ConfigurationValueSearchParams params) {
        PsiFile configFile = params.getConfigFile();
        if (!(configFile instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)configFile;
        Set activeProfiles = params.getActiveProfiles();
        if (ContainerUtil.isEmpty((Collection)activeProfiles) || params.isProcessAllProfiles()) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        String profileSuffix = StringUtil.substringAfter((String)fileName, (String)"-");
        if (profileSuffix == null) {
            return Pair.create((Object)yamlFile, (Object)false);
        }
        boolean isInActiveProfiles = activeProfiles.contains(profileSuffix);
        return isInActiveProfiles ? Pair.create((Object)yamlFile, (Object)true) : null;
    }

    private static /* synthetic */ boolean lambda$findConfigurationValues$0(String keyName, ConfigurationValueSearchParams params, List results, SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder binder, YAMLKeyValue keyValue) {
        ProgressManager.checkCanceled();
        String qualifiedKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(keyValue);
        if (qualifiedKeyName.equals(keyName)) {
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(params, results, keyValue);
            return false;
        }
        if (!params.getCheckRelaxedNames()) {
            return true;
        }
        if (binder.bindsTo(params.getConfigKey(), qualifiedKeyName)) {
            SpringBootModelApplicationYamlConfigFileContributor.processYamlKeyValue(params, results, keyValue);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor", "findConfigurationValues"));
    }

    private static class YamlConfigurationValueResult
    extends ConfigurationValueResult {
        @NotNull
        private final YAMLKeyValue myValue;

        YamlConfigurationValueResult(@NotNull YAMLKeyValue yamlKeyValue, @NotNull PsiElement keyElement, @Nullable PsiElement valueElement, @Nullable String valueText, ConfigurationValueSearchParams params) {
            if (yamlKeyValue == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(0);
            }
            if (keyElement == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(1);
            }
            super(keyElement, valueElement, valueText, params);
            this.myValue = yamlKeyValue;
        }

        @NotNull
        public MetaConfigKeyReference getMetaConfigKeyReference() {
            MetaConfigKeyReference metaConfigKeyReference = (MetaConfigKeyReference)ObjectUtils.assertNotNull((Object)ContainerUtil.findInstance((Object[])this.myValue.getReferences(), MetaConfigKeyReference.class));
            if (metaConfigKeyReference == null) {
                YamlConfigurationValueResult.$$$reportNull$$$0(2);
            }
            return metaConfigKeyReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yamlKeyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor$YamlConfigurationValueResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootModelApplicationYamlConfigFileContributor$YamlConfigurationValueResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaConfigKeyReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

